/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import com.intellij.util.ui.UIUtilities;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class TextInstruction
extends RenderInstruction {
    @NotNull
    private final String myText;
    @NotNull
    private final Font myFont;
    @NotNull
    private final Dimension mySize;

    public TextInstruction(@NotNull FontMetrics metrics, @NotNull String text) {
        this.myFont = metrics.getFont();
        this.myText = text;
        Rectangle2D bounds = this.myFont.getStringBounds(this.myText, metrics.getFontRenderContext());
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        this.mySize = new Dimension(w, h);
    }

    @Override
    @NotNull
    public Dimension getSize() {
        return this.mySize;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Override
    public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        assert (this.mySize.height <= bounds.height);
        g2d.setColor(c.getForeground());
        g2d.setFont(this.myFont);
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)c, (Font)this.myFont);
        Rectangle2D newBounds = this.myFont.getStringBounds(this.myText, metrics.getFontRenderContext());
        this.mySize.setSize((int)newBounds.getWidth(), (int)newBounds.getHeight());
        int textY = bounds.y + metrics.getAscent() + (bounds.height - this.mySize.height) / 2;
        g2d.drawString(this.myText, bounds.x, textY);
    }
}

