/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import com.intellij.ui.HyperlinkLabel;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class UrlInstruction
extends RenderInstruction {
    @NotNull
    private final HyperlinkLabel myHyperlinkLabel;
    @NotNull
    private final Dimension mySize;

    public UrlInstruction(@NotNull Font font, @NotNull String text, @NotNull String url) {
        this.myHyperlinkLabel = new HyperlinkLabel(text);
        this.myHyperlinkLabel.setHyperlinkTarget(url);
        this.myHyperlinkLabel.setFont(font);
        this.mySize = this.myHyperlinkLabel.getMinimumSize();
        this.setMouseHandler(evt -> this.myHyperlinkLabel.dispatchEvent((AWTEvent)evt));
    }

    @Override
    @NotNull
    public Dimension getSize() {
        return this.mySize;
    }

    @Override
    public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.translate(bounds.x, bounds.y);
        this.myHyperlinkLabel.setBounds(bounds);
        this.myHyperlinkLabel.paint((Graphics)g2d);
        g2d.translate(-bounds.x, -bounds.y);
    }
}

