/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SeriesData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionModel
extends AspectModel<Aspect> {
    @NotNull
    private final Range mySelectionRange;
    @NotNull
    private final Range myPreviousSelectionRange;
    @NotNull
    private final List<SelectionListener> myListeners = new ArrayList<SelectionListener>();
    @NotNull
    private final List<DurationDataModel<? extends ConfigurableDurationData>> myConstraints;
    private boolean mySelectionEnabled;
    private boolean myIsUpdating;
    private boolean myPostponeSelectionEvent;
    @Nullable
    private Consumer<SelectionListener> myEventToFire;

    public SelectionModel(@NotNull Range selection) {
        this.mySelectionRange = selection;
        this.myPreviousSelectionRange = new Range(this.mySelectionRange);
        this.mySelectionEnabled = true;
        this.mySelectionRange.addDependency(this).onChange(Range.Aspect.RANGE, this::selectionChanged);
        this.myConstraints = new ArrayList<DurationDataModel<? extends ConfigurableDurationData>>();
    }

    public void addConstraint(@Nullable DurationDataModel<? extends ConfigurableDurationData> constraints) {
        this.myConstraints.add(constraints);
    }

    public void addListener(SelectionListener listener) {
        this.myListeners.add(listener);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }

    private void fireListeners() {
        if (this.myIsUpdating) {
            this.myPostponeSelectionEvent = true;
            return;
        }
        if (this.myEventToFire != null) {
            this.myListeners.forEach(this.myEventToFire);
            this.myEventToFire = null;
        }
    }

    private void notifyEvent(@NotNull Consumer<SelectionListener> event) {
        this.myEventToFire = event;
        this.fireListeners();
    }

    private void selectionChanged() {
        this.changed(Aspect.SELECTION);
        if (this.mySelectionRange.isEmpty()) {
            this.notifyEvent(SelectionListener::selectionCleared);
        } else if (this.myPreviousSelectionRange.isEmpty()) {
            this.notifyEvent(SelectionListener::selectionCreated);
        }
        this.myPreviousSelectionRange.set(this.mySelectionRange);
    }

    public void beginUpdate() {
        this.myIsUpdating = true;
    }

    public void endUpdate() {
        if (this.myIsUpdating) {
            this.myIsUpdating = false;
            if (this.myPostponeSelectionEvent) {
                this.myPostponeSelectionEvent = false;
                this.fireListeners();
            }
        }
    }

    public void clear() {
        if (!this.mySelectionEnabled) {
            return;
        }
        this.mySelectionRange.clear();
    }

    public void set(double min, double max) {
        if (!this.mySelectionEnabled) {
            return;
        }
        if (this.myConstraints.isEmpty()) {
            this.mySelectionRange.set(min, max);
            return;
        }
        Range proposedRange = new Range(min, max);
        ConstrainedRangeResult result = this.getConstrainedRange(proposedRange);
        if (result == null) {
            this.mySelectionRange.clear();
            this.notifyEvent(SelectionListener::selectionCreationFailure);
        } else {
            Range finalRange;
            Range range = finalRange = result.getData() != null && result.getData().canSelectPartialRange() ? result.getRange().getIntersection(proposedRange) : result.getRange();
            if (!this.mySelectionRange.isSameAs(finalRange)) {
                this.myPreviousSelectionRange.clear();
                this.mySelectionRange.set(finalRange);
            }
        }
    }

    @Nullable
    private ConstrainedRangeResult getConstrainedRange(@NotNull Range proposedRange) {
        if (this.myConstraints.isEmpty()) {
            return new ConstrainedRangeResult(proposedRange, null);
        }
        boolean found = false;
        ConstrainedRangeResult result = null;
        for (DurationDataModel<? extends ConfigurableDurationData> constraint : this.myConstraints) {
            DataSeries<? extends ConfigurableDurationData> series = constraint.getSeries().getDataSeries();
            List<SeriesData<? extends ConfigurableDurationData>> constraints = series.getDataForXRange(proposedRange);
            for (SeriesData<? extends ConfigurableDurationData> data : constraints) {
                long dataMax;
                Range r;
                long duration = ((ConfigurableDurationData)data.value).getDurationUs();
                if (duration == Long.MAX_VALUE && !((ConfigurableDurationData)data.value).getSelectableWhenMaxDuration() || (r = new Range(data.x, dataMax = duration == Long.MAX_VALUE ? duration : data.x + duration)).getIntersection(proposedRange).isEmpty()) continue;
                result = new ConstrainedRangeResult(r, (ConfigurableDurationData)data.value);
                if (r.getIntersection(this.mySelectionRange).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return result;
    }

    public boolean canSelectRange(@NotNull Range testRange) {
        ConstrainedRangeResult result = this.getConstrainedRange(testRange);
        return result != null;
    }

    @NotNull
    public Range getSelectionRange() {
        return this.mySelectionRange;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.mySelectionEnabled = enabled;
    }

    private static class ConstrainedRangeResult {
        @NotNull
        private final Range myRange;
        ConfigurableDurationData myData;

        @NotNull
        public Range getRange() {
            return this.myRange;
        }

        @Nullable
        public ConfigurableDurationData getData() {
            return this.myData;
        }

        public ConstrainedRangeResult(@NotNull Range range, @Nullable ConfigurableDurationData data) {
            this.myRange = range;
            this.myData = data;
        }
    }

    public static enum Aspect {
        SELECTION;

    }
}

