/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.axis;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import org.jetbrains.annotations.NotNull;

public final class ClampedAxisComponentModel
extends AxisComponentModel
implements Updatable {
    private boolean myIsUpdating = false;

    private ClampedAxisComponentModel(@NotNull AxisComponentModel.BaseBuilder<ClampedAxisComponentModel> builder) {
        super(builder);
    }

    @Override
    public void update(long elapsedNs) {
        double max;
        if (this.myIsUpdating) {
            return;
        }
        this.myIsUpdating = true;
        boolean needsUpdate = false;
        double clampedMaxTarget = this.calculateClampedMaxTarget();
        double d = max = this.myFirstUpdate ? clampedMaxTarget : Updater.lerp(this.myRange.getMax(), clampedMaxTarget, 0.99f, elapsedNs, (double)((float)(clampedMaxTarget * (double)0.001f)));
        if (Double.compare(max, this.myRange.getMax()) != 0 || this.myFirstUpdate) {
            this.myRange.setMax(max);
            needsUpdate = true;
        }
        this.myFirstUpdate = false;
        if (needsUpdate) {
            this.changed(AxisComponentModel.Aspect.AXIS);
        }
        this.myIsUpdating = false;
    }

    @Override
    public void updateImmediately() {
        this.update(0L);
    }

    private double calculateClampedMaxTarget() {
        double maxTarget = this.myRange.getMax() - this.getZero();
        double rangeTarget = this.myRange.getLength();
        long majorInterval = this.myFormatter.getMajorInterval(rangeTarget);
        float majorNumTicksTarget = (float)Math.ceil(maxTarget / (double)majorInterval);
        return (double)(majorNumTicksTarget * (float)majorInterval) + this.getZero();
    }

    public static class Builder
    extends AxisComponentModel.BaseBuilder<ClampedAxisComponentModel> {
        public Builder(@NotNull Range range, @NotNull BaseAxisFormatter formatter) {
            super(range, formatter);
        }

        @Override
        @NotNull
        public ClampedAxisComponentModel build() {
            return new ClampedAxisComponentModel(this);
        }
    }
}

