/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import gnu.trove.TIntArrayList;
import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAxisFormatter {
    private long mMultiplier;
    private final int mMaxMinorTicks;
    private final int mMaxMajorTicks;
    private final int mSwitchThreshold;
    private final boolean mHasSeparator;

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold, boolean hasSeparator) {
        this.mMaxMinorTicks = Math.max(1, maxMinorTicks);
        this.mMaxMajorTicks = Math.max(1, maxMajorTicks);
        this.mSwitchThreshold = switchThreshold;
        this.mHasSeparator = hasSeparator;
    }

    protected BaseAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        this(maxMinorTicks, maxMajorTicks, switchThreshold, false);
    }

    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        int index = this.getMultiplierIndex(globalRange, 1);
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        String formattedValue = decimalFormat.format((float)value / (float)this.mMultiplier);
        if (!includeUnit) {
            return formattedValue;
        }
        String pattern = this.mHasSeparator ? "%s %s" : "%s%s";
        return String.format(pattern, formattedValue, this.getUnit(index)).trim();
    }

    public long getMajorInterval(double range) {
        return this.getInterval(range, this.mMaxMajorTicks);
    }

    public long getMinorInterval(double range) {
        return this.getInterval(range, this.mMaxMinorTicks);
    }

    public long getInterval(double range, int numTicks) {
        int index = this.getMultiplierIndex(range, this.mSwitchThreshold);
        int base = this.getUnitBase(index);
        int minInterval = this.getUnitMinimalInterval(index);
        TIntArrayList factors = this.getUnitBaseFactors(index);
        return (long)BaseAxisFormatter.getInterval(range / (double)this.mMultiplier, numTicks, base, minInterval, factors) * this.mMultiplier;
    }

    protected abstract int getNumUnits();

    @NotNull
    protected abstract String getUnit(int var1);

    protected abstract int getUnitBase(int var1);

    protected abstract int getUnitMultiplier(int var1);

    protected abstract int getUnitMinimalInterval(int var1);

    @NotNull
    protected abstract TIntArrayList getUnitBaseFactors(int var1);

    protected int getMultiplierIndex(double value, int threshold) {
        this.mMultiplier = 1L;
        int count = this.getNumUnits();
        for (int i = 0; i < count; ++i) {
            long temp = this.mMultiplier * (long)this.getUnitMultiplier(i);
            if (value < (double)(temp * (long)threshold)) {
                return i;
            }
            this.mMultiplier = temp;
        }
        return count - 1;
    }

    protected static int getInterval(double range, int maxTicks, int base, int minInterval, TIntArrayList baseFactors) {
        int power;
        int magnitude;
        double interval = Math.max((double)minInterval, range / (double)maxTicks);
        float multiplier = (float)Math.max(1.0, interval / (double)(magnitude = (int)Math.pow(base, power = (int)Math.floor(Math.log(interval) / Math.log(base)))));
        if (multiplier > 1.0f) {
            for (int i = 1; i < baseFactors.size(); ++i) {
                if (!(multiplier > (float)baseFactors.get(i))) continue;
                multiplier = baseFactors.get(i - 1);
                break;
            }
        }
        return (int)multiplier * magnitude;
    }

    @NotNull
    protected static TIntArrayList getMultiplierFactors(int base) {
        TIntArrayList factors = new TIntArrayList();
        while (base > 1) {
            int divider = 2;
            while (base % divider != 0) {
                if (++divider * divider <= base) continue;
                divider = base;
                break;
            }
            factors.add(base);
            base /= divider;
        }
        factors.add(1);
        return factors;
    }

    protected long getMultiplier() {
        return this.mMultiplier;
    }
}

