/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import java.text.Format;
import java.text.NumberFormat;
import org.jetbrains.annotations.NotNull;

public class NumberFormatter {
    private static final Format INTEGER_FORMAT = NumberFormat.getIntegerInstance();
    private static final String[] FILE_SIZE_UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    private static final int FILE_SIZE_MULTIPLIER = 1024;

    @NotNull
    public static String formatInteger(@NotNull Number number) {
        return INTEGER_FORMAT.format(number);
    }

    @NotNull
    public static String formatFileSize(long sizeInBytes) {
        double result = sizeInBytes;
        String unit = FILE_SIZE_UNITS[0];
        for (int i = 1; i < FILE_SIZE_UNITS.length && !(result < 1024.0); result /= 1024.0, ++i) {
            unit = FILE_SIZE_UNITS[i];
        }
        String decimalFormat = result < 100.0 ? "%.1f" : "%.0f";
        return String.format(decimalFormat + " %s", result, unit);
    }
}

