/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.legend;

import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SeriesLegend
implements Legend {
    @VisibleForTesting
    static final String UNAVAILABLE_MESSAGE = "N/A";
    @NotNull
    private final Range myRange;
    @NotNull
    private final RangedContinuousSeries mySeries;
    @NotNull
    private final BaseAxisFormatter myFormatter;
    @NotNull
    private final String myName;
    @NotNull
    private final Interpolatable<Long, Double> myInterpolator;
    @NotNull
    private final Predicate<Range> myDisplayFilter;

    public SeriesLegend(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range) {
        this(series, formatter, range, Interpolatable.SegmentInterpolator);
    }

    public SeriesLegend(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range, @NotNull Interpolatable<Long, Double> interpolator) {
        this(series, formatter, range, series.getName(), interpolator);
    }

    public SeriesLegend(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range, @NotNull String name, @NotNull Interpolatable<Long, Double> interpolator) {
        this(series, formatter, range, name, interpolator, val -> true);
    }

    public SeriesLegend(@NotNull RangedContinuousSeries series, @NotNull BaseAxisFormatter formatter, @NotNull Range range, @NotNull String name, @NotNull Interpolatable<Long, Double> interpolator, @NotNull Predicate<Range> displayFilter) {
        this.myRange = range;
        this.mySeries = series;
        this.myFormatter = formatter;
        this.myName = name;
        this.myInterpolator = interpolator;
        this.myDisplayFilter = displayFilter;
    }

    @Override
    @Nullable
    public String getValue() {
        double time = this.myRange.getMax();
        Range range = new Range(time, time);
        if (!this.myDisplayFilter.test(range)) {
            return UNAVAILABLE_MESSAGE;
        }
        List<SeriesData<Long>> data = this.mySeries.getDataSeries().getDataForXRange(range);
        if (data.isEmpty()) {
            return UNAVAILABLE_MESSAGE;
        }
        return this.myFormatter.getFormattedString(this.mySeries.getYRange().getLength(), this.getInterpolatedValueAt(time, data), true);
    }

    private double getInterpolatedValueAt(double time, @NotNull List<SeriesData<Long>> data) {
        SeriesData<Long> key = new SeriesData<Long>((long)time, 0L);
        int index = Collections.binarySearch(data, key, (left, right) -> {
            long diff = left.x - right.x;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        });
        if (index >= 0) {
            return ((Long)data.get((int)index).value).longValue();
        }
        if ((index = -(index + 1)) == 0) {
            return ((Long)data.get((int)index).value).longValue();
        }
        if (index >= data.size()) {
            return ((Long)data.get((int)(data.size() - 1)).value).longValue();
        }
        return this.myInterpolator.interpolate(data.get(index - 1), data.get(index), time);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }
}

