/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonComboBoxModel;
import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.adtui.stdui.CommonComboBoxRenderer;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.adtui.stdui.Lookup;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0010\b\u0001\u0010\u0002 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\r\u0010\t\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0014J\b\u0010\u0014\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/adtui/stdui/CommonComboBox;", "E", "M", "Lcom/android/tools/adtui/model/stdui/CommonComboBoxModel;", "Lcom/intellij/openapi/ui/ComboBox;", "model", "(Lcom/android/tools/adtui/model/stdui/CommonComboBoxModel;)V", "textField", "Lcom/android/tools/adtui/stdui/CommonTextField;", "getModel", "()Lcom/android/tools/adtui/model/stdui/CommonComboBoxModel;", "installDefaultRenderer", "", "moveNext", "moveNextPage", "movePrevious", "movePreviousPage", "setFromModel", "togglePopup", "updateFromModel", "updateUI", "CommonComboBoxEditor", "TextFieldForComboBox", "intellij.android.adt.ui"})
public class CommonComboBox<E, M extends CommonComboBoxModel<E>>
extends ComboBox<E> {
    private CommonTextField<?> textField;

    protected void updateFromModel() {
        this.setFromModel();
    }

    private final void setFromModel() {
        this.setEnabled(this.getModel().getEnabled());
        if (this.isEditable != this.getModel().getEditable()) {
            super.setEditable(this.getModel().getEditable());
        }
    }

    private final void togglePopup() {
        Object object = this.textField;
        if (object != null && (object = object.getLookup()) != null) {
            if (((Lookup)object).isVisible()) {
                return;
            }
        }
        if (!this.isPopupVisible()) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void moveNext() {
        Object object = this.textField;
        if (object != null && (object = object.getLookup()) != null) {
            if (((Lookup)object).isVisible()) {
                Object object2 = this.textField;
                if (object2 == null || (object2 = object2.getLookup()) == null) return;
                ((Lookup)object2).selectNext();
                return;
            }
        }
        if (!this.isPopupVisible()) {
            this.showPopup();
            return;
        } else {
            int size = this.dataModel.getSize();
            int index = this.getSelectedIndex();
            this.setSelectedIndex(Integer.min(index + 1, size - 1));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void movePrevious() {
        Object object = this.textField;
        if (object != null && (object = object.getLookup()) != null) {
            if (((Lookup)object).isVisible()) {
                Object object2 = this.textField;
                if (object2 == null || (object2 = object2.getLookup()) == null) return;
                ((Lookup)object2).selectPrevious();
                return;
            }
        }
        if (!this.isPopupVisible()) return;
        int minValue = this.dataModel.getSize() == 0 ? -1 : 0;
        int index = this.getSelectedIndex();
        this.setSelectedIndex(Integer.max(index - 1, minValue));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void moveNextPage() {
        Object object = this.textField;
        if (object != null && (object = object.getLookup()) != null) {
            if (((Lookup)object).isVisible()) {
                Object object2 = this.textField;
                if (object2 == null || (object2 = object2.getLookup()) == null) return;
                ((Lookup)object2).selectNextPage();
                return;
            }
        }
        if (!this.isPopupVisible()) return;
        int size = this.dataModel.getSize();
        int index = this.getSelectedIndex();
        this.setSelectedIndex(Integer.min(index + this.maximumRowCount, size - 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void movePreviousPage() {
        Object object = this.textField;
        if (object != null && (object = object.getLookup()) != null) {
            if (((Lookup)object).isVisible()) {
                Object object2 = this.textField;
                if (object2 == null || (object2 = object2.getLookup()) == null) return;
                ((Lookup)object2).selectPreviousPage();
                return;
            }
        }
        if (!this.isPopupVisible()) return;
        int minValue = this.dataModel.getSize() == 0 ? -1 : 0;
        int index = this.getSelectedIndex();
        this.setSelectedIndex(Integer.max(index - this.maximumRowCount, minValue));
    }

    public void updateUI() {
        super.updateUI();
        this.installDefaultRenderer();
    }

    @NotNull
    public M getModel() {
        ComboBoxModel comboBoxModel = super.getModel();
        if (comboBoxModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type M");
        }
        return (M)((CommonComboBoxModel)comboBoxModel);
    }

    private final void installDefaultRenderer() {
        ListCellRenderer renderer = this.getRenderer();
        if (renderer == null || renderer instanceof UIResource) {
            this.setRenderer(new CommonComboBoxRenderer.UIResource());
        }
    }

    public CommonComboBox(@NotNull M model2) {
        super((ComboBoxModel)model2);
        super.setEditor((ComboBoxEditor)new CommonComboBoxEditor<CommonTextFieldModel>((CommonTextFieldModel)model2, (JComponent)((Object)this)));
        Component component = this.editor.getEditorComponent();
        if (component == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.adtui.stdui.CommonTextField<*>");
        }
        this.textField = (CommonTextField)((Object)component);
        CommonTextField<?> commonTextField = this.textField;
        if (commonTextField != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.moveNext();
                }
            }, KeyStrokes.INSTANCE.getDOWN(), "moveNext", null, 0, 24, null);
        }
        CommonTextField<?> commonTextField2 = this.textField;
        if (commonTextField2 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField2), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.movePrevious();
                }
            }, KeyStrokes.INSTANCE.getUP(), "movePrevious", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return this.isPopupVisible();
                }
            }, 0, 16, null);
        }
        CommonTextField<?> commonTextField3 = this.textField;
        if (commonTextField3 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField3), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.moveNextPage();
                }
            }, KeyStrokes.INSTANCE.getPAGE_DOWN(), "moveNextPage", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return this.isPopupVisible();
                }
            }, 0, 16, null);
        }
        CommonTextField<?> commonTextField4 = this.textField;
        if (commonTextField4 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField4), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.movePreviousPage();
                }
            }, KeyStrokes.INSTANCE.getPAGE_UP(), "movePreviousPage", (Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return this.isPopupVisible();
                }
            }, 0, 16, null);
        }
        CommonTextField<?> commonTextField5 = this.textField;
        if (commonTextField5 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField5), (Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.togglePopup();
                }
            }, KeyStrokes.INSTANCE.getALT_DOWN(), "toggle", null, 0, 24, null);
        }
        KeyBindingKt.registerActionKey((JComponent)((Object)this), (Function0<Unit>)((Function0)9.INSTANCE), KeyStrokes.INSTANCE.getPAGE_DOWN(), "noop", (Function0<Boolean>)((Function0)10.INSTANCE), 1);
        KeyBindingKt.registerActionKey((JComponent)((Object)this), (Function0<Unit>)((Function0)11.INSTANCE), KeyStrokes.INSTANCE.getPAGE_UP(), "noop", (Function0<Boolean>)((Function0)12.INSTANCE), 1);
        this.setFromModel();
        model2.addListener(new ValueChangedListener(){

            @Override
            public final void valueChanged() {
                this.updateFromModel();
                this.repaint();
            }
        });
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\n\b\u0002\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/android/tools/adtui/stdui/CommonComboBox$CommonComboBoxEditor;", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Ljavax/swing/plaf/basic/BasicComboBoxEditor;", "model", "comboBox", "Ljavax/swing/JComponent;", "(Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;Ljavax/swing/JComponent;)V", "createEditorComponent", "Ljavax/swing/JTextField;", "intellij.android.adt.ui"})
    private static final class CommonComboBoxEditor<M extends CommonTextFieldModel>
    extends BasicComboBoxEditor {
        @Override
        @Nullable
        protected JTextField createEditorComponent() {
            return null;
        }

        public CommonComboBoxEditor(@NotNull M model2, @NotNull JComponent comboBox) {
            this.editor = (JTextField)((Object)new TextFieldForComboBox<M>(model2, comboBox));
            this.editor.setBorder((Border)JBUI.Borders.empty());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\n\b\u0002\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/adtui/stdui/CommonComboBox$TextFieldForComboBox;", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/android/tools/adtui/stdui/CommonTextField;", "model", "comboBox", "Ljavax/swing/JComponent;", "(Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;Ljavax/swing/JComponent;)V", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "intellij.android.adt.ui"})
    private static final class TextFieldForComboBox<M extends CommonTextFieldModel>
    extends CommonTextField<M> {
        private final JComponent comboBox;

        @Nullable
        public String getToolTipText() {
            return this.comboBox.getToolTipText();
        }

        @Nullable
        public String getToolTipText(@Nullable MouseEvent event) {
            return this.comboBox.getToolTipText(event);
        }

        public TextFieldForComboBox(@NotNull M model2, @NotNull JComponent comboBox) {
            super(model2);
            this.comboBox = comboBox;
        }
    }
}

