/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.StandardColors;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.jetbrains.annotations.NotNull;

class CommonTabbedPaneUI
extends BasicTabbedPaneUI {
    private final MouseListener mouseHoverListener = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            CommonTabbedPaneUI.this.setHoveredTabIndex(-1);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            CommonTabbedPaneUI.this.setTabIndexForMouseEvent(e);
        }
    };
    private final MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            CommonTabbedPaneUI.this.setTabIndexForMouseEvent(e);
        }
    };
    private int myHoveredTabIndex = -1;

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseListener(this.mouseHoverListener);
        this.tabPane.addMouseMotionListener(this.mouseMotionListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseListener(this.mouseHoverListener);
        this.tabPane.removeMouseMotionListener(this.mouseMotionListener);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabInsets = JBUI.insets((int)9, (int)12, (int)8, (int)12);
        this.tabAreaInsets = JBUI.insets((int)0);
        this.contentBorderInsets = JBUI.insets((int)0, (int)0, (int)0, (int)0);
    }

    private void setHoveredTabIndex(int index) {
        Rectangle tabBound;
        int previousIndex = this.myHoveredTabIndex;
        this.myHoveredTabIndex = index;
        if (previousIndex >= 0) {
            tabBound = this.getTabBounds(this.tabPane, previousIndex);
            this.tabPane.repaint(tabBound);
        }
        if (this.myHoveredTabIndex >= 0) {
            tabBound = this.getTabBounds(this.tabPane, this.myHoveredTabIndex);
            this.tabPane.repaint(tabBound);
        }
    }

    private void setTabIndexForMouseEvent(@NotNull MouseEvent e) {
        int tabIndex = this.tabForCoordinate(this.tabPane, e.getX(), e.getY());
        this.setHoveredTabIndex(tabIndex);
    }

    private Rectangle adjustTabRect(int tabPlacement, Rectangle rect) {
        Rectangle adj = new Rectangle(rect);
        switch (tabPlacement) {
            case 3: {
                --adj.height;
                ++adj.y;
                break;
            }
            case 2: {
                --adj.width;
                break;
            }
            case 4: {
                --adj.width;
                ++adj.x;
                break;
            }
            default: {
                --adj.height;
            }
        }
        return adj;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        int tw = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
        int th = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        g.setColor(StandardColors.TAB_BORDER_COLOR);
        switch (tabPlacement) {
            case 2: {
                g.drawLine(x + tw - 1, y, x + tw - 1, y + h);
                break;
            }
            case 4: {
                g.drawLine(x + w - tw, y, x + w - tw, y + w);
                break;
            }
            case 3: {
                g.drawLine(x, y + h - th, x + w, y + h - th);
                break;
            }
            default: {
                g.drawLine(x, y + th - 1, x + w, y + th - 1);
            }
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
        Rectangle tabRect = this.adjustTabRect(tabPlacement, rects[tabIndex]);
        String title = this.tabPane.getTitleAt(tabIndex);
        Icon icon = this.getIconForTab(tabIndex);
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        Font font = this.tabPane.getFont();
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)this.tabPane, (Graphics)g, (Font)font);
        if (tabIndex == this.myHoveredTabIndex) {
            g.setColor(StandardColors.TAB_HOVER_COLOR);
            g.fillRect(tabRect.x, tabRect.y, tabRect.width, tabRect.height);
        }
        if (this.tabPane.getTabComponentAt(tabIndex) == null) {
            iconRect.y = 0;
            iconRect.x = 0;
            textRect.y = 0;
            textRect.x = 0;
            SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
            g.setColor(isSelected || tabIndex == this.myHoveredTabIndex ? StandardColors.TEXT_COLOR : StandardColors.INACTIVE_TEXT_COLOR);
            g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!isSelected) {
            return;
        }
        g.setColor(StandardColors.TAB_SELECTED_COLOR);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + w - 2 - 1, y, 2, h);
                break;
            }
            case 4: {
                g.fillRect(x + 1, y, 2, h);
                break;
            }
            case 3: {
                g.fillRect(x, y + 1, w, 2);
                break;
            }
            default: {
                g.fillRect(x, y + h - 1 - 2, w, 2);
            }
        }
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }
}

