/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui.menu;

import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.android.tools.adtui.stdui.menu.CommonDropDownButton;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import org.jetbrains.annotations.NotNull;

public class CommonDropDownButtonUI
extends BasicButtonUI {
    private static final int ARROW_REGION_WIDTH = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_WIDTH() + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HORIZONTAL_PADDING() * 2;
    private static final int ARROW_REGION_HEIGHT = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HEIGHT() + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_VERTICAL_PADDING_TOP() + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_VERTICAL_PADDING_BOTTOM();
    @NotNull
    private final MouseAdapter myAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            CommonDropDownButtonUI.this.myHover = true;
            event.getComponent().repaint();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            CommonDropDownButtonUI.this.myHover = false;
            event.getComponent().repaint();
        }
    };
    private boolean myHover;

    @Override
    protected void installDefaults(@NotNull AbstractButton button) {
        super.installDefaults(button);
        LookAndFeel.installProperty(button, "opaque", false);
        Border border = button.getBorder();
        if (border == null || border instanceof UIResource) {
            button.setBorder(new BorderUIResource(JBUI.Borders.empty((int)4)));
        }
    }

    @Override
    protected void installListeners(@NotNull AbstractButton button) {
        super.installListeners(button);
        button.addMouseListener(this.myAdapter);
    }

    @Override
    protected void uninstallListeners(@NotNull AbstractButton button) {
        super.uninstallListeners(button);
        button.removeMouseListener(this.myAdapter);
    }

    @Override
    public Dimension getMinimumSize(@NotNull JComponent component) {
        return this.getPreferredSize(component);
    }

    @Override
    public Dimension getPreferredSize(@NotNull JComponent component) {
        Dimension dim = super.getPreferredSize(component);
        CommonDropDownButton dropdown = (CommonDropDownButton)component;
        if (dropdown.getAction().getShowExpandArrow()) {
            dim = new Dimension(dim.width + ARROW_REGION_WIDTH, Math.max(dim.height, ARROW_REGION_HEIGHT));
        }
        return dim;
    }

    @Override
    public void paint(@NotNull Graphics graphics, @NotNull JComponent component) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        CommonDropDownButton button = (CommonDropDownButton)component;
        if (this.myHover && button.isEnabled() || button.isSelected()) {
            GraphicsUtilKt.paintBackground(graphics, component);
        }
        super.paint(graphics, component);
        if (button.getAction().getShowExpandArrow()) {
            Dimension dim = component.getSize();
            int arrowWidth = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_WIDTH();
            int arrowHeight = (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HEIGHT();
            int arrowRegionWidth = arrowWidth + (int)StandardDimensions.INSTANCE.getDROPDOWN_ARROW_HORIZONTAL_PADDING() * 2;
            float x = (float)dim.width - (float)arrowRegionWidth / 2.0f;
            float y = (float)(dim.height - arrowHeight) / 2.0f;
            Path2D.Float triangle = new Path2D.Float();
            triangle.moveTo(x, y + (float)arrowHeight);
            triangle.lineTo(x - (float)arrowWidth / 2.0f, y);
            triangle.lineTo(x + (float)arrowWidth / 2.0f, y);
            triangle.lineTo(x, y + (float)arrowHeight);
            GraphicsUtilKt.setColorAndAlpha(g2d, StandardColors.DROPDOWN_ARROW_COLOR);
            g2d.fill(triangle);
        }
    }

    @Override
    protected void paintIcon(@NotNull Graphics graphics, @NotNull JComponent component, @NotNull Rectangle iconRect) {
        CommonDropDownButton button = (CommonDropDownButton)component;
        if (button.getAction().getShowExpandArrow()) {
            iconRect.x -= ARROW_REGION_WIDTH / 2;
        }
        super.paintIcon(graphics, component, iconRect);
    }

    @Override
    protected void paintText(@NotNull Graphics graphics, @NotNull AbstractButton component, @NotNull Rectangle textRect, @NotNull String text) {
        CommonDropDownButton button = (CommonDropDownButton)component;
        if (button.getAction().getShowExpandArrow()) {
            textRect.x -= ARROW_REGION_WIDTH / 2;
        }
        super.paintText(graphics, button, textRect, text);
    }
}

