/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JPanel;

public final class AdtUiCursors {
    public static final Cursor GRAB = AdtUiCursors.makeCursor("GRAB", StudioIcons.Cursors.GRAB);
    public static final Cursor GRABBING = AdtUiCursors.makeCursor("GRABBING", StudioIcons.Cursors.GRABBING);

    private static Cursor makeCursor(String name, Icon icon) {
        if (GraphicsEnvironment.isHeadless()) {
            return Cursor.getDefaultCursor();
        }
        float scaleFactor = UIUtil.isRetina() ? 0.5f : 1.0f;
        Icon scaledIcon = ((IconLoader.CachedImageIcon)icon).scale(scaleFactor);
        BufferedImage image = UIUtil.createImage((int)scaledIcon.getIconWidth(), (int)scaledIcon.getIconHeight(), (int)2);
        scaledIcon.paintIcon(new JPanel(), image.getGraphics(), 0, 0);
        return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(image.getWidth() / 2, image.getHeight() / 2), name);
    }
}

