/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.intellij.icons.AllIcons;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HideablePanel
extends JPanel {
    private static final Border HIDEABLE_PANEL_BORDER = new JBEmptyBorder(0, 10, 0, 15);
    private static final Border HIDEABLE_CONTENT_BORDER = new JBEmptyBorder(0, 12, 0, 5);
    private static final int TITLE_RIGHT_PADDING = 3;
    private boolean myExpanded;
    private final JComponent myChild;
    private final JLabel myLabel;
    private final EventListenerList myStateChangeListeners;
    private final JPanel myTitlePanel;

    public HideablePanel(@NotNull Builder builder) {
        super(new BorderLayout());
        this.myChild = builder.myContent;
        this.myStateChangeListeners = new EventListenerList();
        this.myTitlePanel = new JPanel(new TabularLayout("Fit-,*,Fit-"));
        this.myLabel = this.setupTitleBar(builder);
        this.setTitle(builder.myTitle);
        this.myChild.setBorder(builder.myContentBorder == null ? HIDEABLE_CONTENT_BORDER : builder.myContentBorder);
        this.setBorder(builder.myPanelBorder == null ? HIDEABLE_PANEL_BORDER : builder.myPanelBorder);
        this.add((Component)this.myChild, "Center");
        this.myExpanded = !builder.myInitiallyExpanded;
        this.setExpanded(builder.myInitiallyExpanded);
    }

    private JLabel setupTitleBar(@NotNull Builder builder) {
        JComponent clickableComponent;
        JLabel label2 = new JLabel();
        MouseAdapter toggleAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                HideablePanel.this.setExpanded(!HideablePanel.this.isExpanded());
            }
        };
        switch (builder.myClickableComponent) {
            case TITLE: {
                clickableComponent = label2;
                break;
            }
            default: {
                clickableComponent = this.myTitlePanel;
            }
        }
        clickableComponent.addMouseListener(toggleAdapter);
        clickableComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.myTitlePanel.add((Component)label2, new TabularLayout.Constraint(0, 0));
        if (builder.myShowSeparator) {
            JComponent separatorComponent = AdtUiUtils.createHorizontalSeparator();
            separatorComponent.setBorder((Border)new JBEmptyBorder(0, 10, 0, builder.myTitleRightPadding));
            this.myTitlePanel.add((Component)separatorComponent, new TabularLayout.Constraint(0, 1));
        }
        if (builder.myNorthEastComponent != null) {
            this.myTitlePanel.add((Component)builder.myNorthEastComponent, new TabularLayout.Constraint(0, 2));
        }
        this.add((Component)this.myTitlePanel, "North");
        if (builder.myTitleLeftPadding != null) {
            label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)builder.myTitleLeftPadding, (int)0, (int)0));
        }
        if (builder.myIconTextGap != null) {
            label2.setIconTextGap(builder.myIconTextGap);
        }
        return label2;
    }

    public void setTitle(String title) {
        this.myLabel.setText(String.format("<html><nobr>%s</nobr></html>", title));
    }

    public void setExpanded(boolean expanded) {
        if (this.myExpanded != expanded) {
            ActionListener[] listeners;
            this.myExpanded = expanded;
            this.myChild.setVisible(expanded);
            if (expanded) {
                this.myLabel.setIcon(AllIcons.General.SplitDown);
            } else {
                this.myLabel.setIcon(AllIcons.General.SplitRight);
            }
            if (this.getParent() != null) {
                this.getParent().revalidate();
            }
            if ((listeners = (ActionListener[])this.myStateChangeListeners.getListeners(ActionListener.class)) != null) {
                for (ActionListener listener : listeners) {
                    listener.actionPerformed(null);
                }
            }
        }
    }

    public void addStateChangedListener(@NotNull ActionListener expandedListener) {
        this.myStateChangeListeners.add(ActionListener.class, expandedListener);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.myTitlePanel != null) {
            this.myTitlePanel.setBackground(bg);
        }
    }

    public boolean isExpanded() {
        return this.myExpanded;
    }

    public static final class Builder {
        @NotNull
        String myTitle;
        @NotNull
        JComponent myContent;
        @NotNull
        ClickableComponent myClickableComponent = ClickableComponent.TITLE_BAR;
        @Nullable
        JComponent myNorthEastComponent;
        @Nullable
        Consumer<Boolean> myOnStateChangedConsumer;
        @Nullable
        Border myContentBorder;
        @Nullable
        Border myPanelBorder;
        boolean myShowSeparator = true;
        boolean myInitiallyExpanded = true;
        int myTitleRightPadding = 3;
        @Nullable
        Integer myTitleLeftPadding;
        @Nullable
        Integer myIconTextGap;

        public Builder(@NotNull String title, @NotNull JComponent content) {
            this.myTitle = title;
            this.myContent = content;
        }

        @NotNull
        public Builder setNorthEastComponent(@Nullable JComponent northEastComponent) {
            this.myNorthEastComponent = northEastComponent;
            return this;
        }

        @NotNull
        public Builder setInitiallyExpanded(boolean initiallyExpanded) {
            this.myInitiallyExpanded = initiallyExpanded;
            return this;
        }

        @NotNull
        public Builder setShowSeparator(boolean show) {
            this.myShowSeparator = show;
            return this;
        }

        @NotNull
        public Builder setContentBorder(@NotNull Border border) {
            this.myContentBorder = border;
            return this;
        }

        @NotNull
        public Builder setPanelBorder(@NotNull Border border) {
            this.myPanelBorder = border;
            return this;
        }

        @NotNull
        public Builder setTitleLeftPadding(int leftPadding) {
            this.myTitleLeftPadding = leftPadding;
            return this;
        }

        @NotNull
        public Builder setTitleRightPadding(int rightPadding) {
            this.myTitleRightPadding = rightPadding;
            return this;
        }

        @NotNull
        public Builder setIconTextGap(int gap) {
            this.myIconTextGap = gap;
            return this;
        }

        @NotNull
        public Builder setClickableComponent(@NotNull ClickableComponent clickableComponent) {
            this.myClickableComponent = clickableComponent;
            return this;
        }

        @NotNull
        public HideablePanel build() {
            return new HideablePanel(this);
        }
    }

    public static enum ClickableComponent {
        TITLE,
        TITLE_BAR;

    }
}

