/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.util;

import com.google.common.math.IntMath;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;

public class SwingUtil {
    private static final String DOWN = "selectNext";
    private static final String UP = "selectPrevious";

    public static void doNotSelectSeparators(@NotNull JComboBox combo) {
        SwingUtil.doNotSelectItems(combo, e -> e instanceof JSeparator);
    }

    public static void doNotSelectItems(@NotNull JComboBox combo, @NotNull Function<Object, Boolean> skipItem) {
        ActionMap actions = combo.getActionMap();
        actions.put(DOWN, new Actions(DOWN, combo, skipItem));
        actions.put(UP, new Actions(UP, combo, skipItem));
    }

    @NotNull
    public static MouseEvent convertMouseEventID(@NotNull MouseEvent event, int id) {
        return new MouseEvent((Component)event.getSource(), id, event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
    }

    private static class Actions
    extends AbstractAction {
        private JComboBox comboBox;
        private Function<Object, Boolean> mySkipItem;

        public Actions(String name, JComboBox comboBox, Function<Object, Boolean> skipItem) {
            super(name);
            this.comboBox = comboBox;
            this.mySkipItem = skipItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = (String)this.getValue("Name");
            if (key == SwingUtil.DOWN) {
                if (this.comboBox.isShowing()) {
                    if (this.comboBox.isPopupVisible()) {
                        if (this.comboBox.getUI() != null) {
                            this.selectNextPossibleValue();
                        }
                    } else {
                        this.comboBox.showPopup();
                    }
                }
            } else if (key == SwingUtil.UP && this.comboBox.getUI() != null) {
                if (this.comboBox.isPopupVisible()) {
                    this.selectPreviousPossibleValue();
                } else if (UIManager.getBoolean("ComboBox.showPopupOnNavigation")) {
                    this.comboBox.showPopup();
                }
            }
        }

        private JList getPopupList() {
            ComboPopup popup = UIUtil.getComboBoxPopup((JComboBox)this.comboBox);
            assert (popup != null);
            return popup.getList();
        }

        private boolean isTableCellEditor() {
            return Boolean.TRUE.equals(this.comboBox.getClientProperty("JComboBox.isTableCellEditor"));
        }

        private int newIndex(int current, boolean next) {
            int startIndex = current;
            while (startIndex != (current = IntMath.mod((int)(next ? current + 1 : current - 1), (int)this.comboBox.getItemCount())) && this.mySkipItem.apply(this.comboBox.getItemAt(current)).booleanValue()) {
            }
            return current;
        }

        protected void selectNextPossibleValue() {
            boolean isTableCellEditor = this.isTableCellEditor();
            JList listBox = this.getPopupList();
            int si = this.comboBox.isPopupVisible() ? listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            if ((si = this.newIndex(si, true)) <= this.comboBox.getModel().getSize() - 1) {
                listBox.setSelectedIndex(si);
                listBox.ensureIndexIsVisible(si);
                if (!(isTableCellEditor || UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && this.comboBox.isPopupVisible())) {
                    this.comboBox.setSelectedIndex(si);
                }
                this.comboBox.repaint();
            }
        }

        protected void selectPreviousPossibleValue() {
            boolean isTableCellEditor = this.isTableCellEditor();
            JList listBox = this.getPopupList();
            int si = this.comboBox.isPopupVisible() ? listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
            if ((si = this.newIndex(si, false)) >= 0) {
                listBox.setSelectedIndex(si);
                listBox.ensureIndexIsVisible(si);
                if (!(isTableCellEditor || UIManager.getBoolean("ComboBox.noActionOnKeyNavigation") && this.comboBox.isPopupVisible())) {
                    this.comboBox.setSelectedIndex(si);
                }
                this.comboBox.repaint();
            }
        }
    }
}

