/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.google.common.base.Strings;
import com.intellij.icons.AllIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Validator<T> {
    @NotNull
    public Result validate(@NotNull T var1);

    public static final class Result {
        public static final Result OK = new Result(Severity.OK, "");
        @NotNull
        private final Severity mySeverity;
        @NotNull
        private final String myMessage;

        public Result(@NotNull Severity severity, @NotNull String message) {
            this.mySeverity = severity;
            this.myMessage = message;
        }

        @NotNull
        public static Result fromNullableMessage(@Nullable String errorMessage) {
            return Strings.isNullOrEmpty((String)errorMessage) ? OK : new Result(Severity.ERROR, errorMessage);
        }

        @NotNull
        public static Result fromThrowable(@NotNull Throwable throwable) {
            String errorMessage = throwable.getMessage();
            if (errorMessage == null) {
                errorMessage = "Error (" + throwable.getClass().getSimpleName() + ")";
            }
            return Result.fromNullableMessage(errorMessage);
        }

        @NotNull
        public Severity getSeverity() {
            return this.mySeverity;
        }

        @NotNull
        public String getMessage() {
            return this.myMessage;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            return this.mySeverity == other.mySeverity && this.myMessage.equals(other.myMessage);
        }

        public int hashCode() {
            return this.myMessage.hashCode() * 31 + this.mySeverity.ordinal();
        }
    }

    public static enum Severity {
        OK(null),
        INFO(AllIcons.General.BalloonInformation),
        WARNING(AllIcons.General.BalloonWarning),
        ERROR(AllIcons.General.BalloonError);

        @Nullable
        private final Icon myIcon;

        private Severity(Icon icon) {
            this.myIcon = icon;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

