/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class ValidatorPanel
extends JPanel
implements Disposable {
    private static final String BLANK = " ";
    private final ListenerManager myListeners;
    private final List<Validator.Result> myResults;
    private final BoolProperty myHasErrors;
    private JPanel myRootPanel;
    private JPanel mySouthPanel;
    private JBLabel myValidationLabel;

    public ValidatorPanel(@NotNull Disposable parentDisposable, @NotNull JComponent innerPanel) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myListeners = new ListenerManager();
        this.myResults = new ArrayList<Validator.Result>();
        this.myHasErrors = new BoolValueProperty();
        this.add(this.myRootPanel);
        this.myRootPanel.add(innerPanel);
        this.myValidationLabel.setName("ValidationLabel");
        this.myValidationLabel.setText(BLANK);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public <T> void registerValidator(@NotNull ObservableValue<T> value, @NotNull Validator<T> validator) {
        int index = this.myResults.size();
        this.myResults.add(Validator.Result.OK);
        this.myListeners.listenAndFire(value, () -> {
            Validator.Result oldValue = this.myResults.get(index);
            Validator.Result newValue = validator.validate(value.get());
            if (!newValue.equals(oldValue)) {
                this.myResults.set(index, newValue);
                this.updateValidationLabel();
            }
        });
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull Validator.Severity severity, @NotNull String message) {
        this.registerValidator(value, new TrueValidator(severity, message));
    }

    public void registerTest(@NotNull ObservableValue<Boolean> value, @NotNull String message) {
        this.registerTest(value, Validator.Severity.ERROR, message);
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message, @NotNull Validator.Severity severity) {
        this.registerValidator(message, value -> {
            if (value.isEmpty()) {
                return Validator.Result.OK;
            }
            return new Validator.Result(severity, (String)value);
        });
    }

    public void registerMessageSource(@NotNull ObservableValue<String> message) {
        this.registerMessageSource(message, Validator.Severity.ERROR);
    }

    @NotNull
    public ObservableBool hasErrors() {
        return this.myHasErrors;
    }

    private void updateValidationLabel() {
        Validator.Result mostSevereResult = Validator.Result.OK;
        for (Validator.Result result : this.myResults) {
            if (result.getSeverity().compareTo(mostSevereResult.getSeverity()) > 0 && (mostSevereResult = result).getSeverity() == Validator.Severity.ERROR) break;
        }
        if (mostSevereResult.getSeverity() == Validator.Severity.OK) {
            this.myValidationLabel.setIcon(null);
            this.myValidationLabel.setText(BLANK);
        } else {
            this.myValidationLabel.setIcon(mostSevereResult.getSeverity().getIcon());
            String message = mostSevereResult.getMessage().trim();
            if (message.indexOf(10) >= 0 && !XmlStringUtil.isWrappedInHtml((String)message)) {
                message = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.replace((String)XmlStringUtil.escapeString((String)message), (String)"\n", (String)"<br>"));
            }
            this.myValidationLabel.setText(message);
        }
        this.myHasErrors.set((Object)(mostSevereResult.getSeverity() == Validator.Severity.ERROR ? 1 : 0));
    }

    public void dispose() {
        this.myListeners.releaseAll();
    }

    @VisibleForTesting
    @NotNull
    public JLabel getValidationLabel() {
        return this.myValidationLabel;
    }

    @NotNull
    public static Validator.Result truncateMessage(@NotNull Validator.Result validity, int maxLineCount) {
        String message = validity.getMessage();
        int lineCount = 0;
        int lineOffset = 0;
        int offset = 0;
        while ((offset = message.indexOf(10, offset)) >= 0) {
            ++offset;
            if (++lineCount > maxLineCount) {
                message = message.substring(0, lineOffset) + "...";
                return new Validator.Result(validity.getSeverity(), message);
            }
            lineOffset = offset;
        }
        return validity;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 15));
        this.mySouthPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "South");
        this.myValidationLabel = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

