/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SideBorder;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AttachedToolWindow<T>
implements ToolWindowCallback,
Disposable {
    static final String TOOL_WINDOW_PROPERTY_PREFIX = "ATTACHED_TOOL_WINDOW.";
    static final String TOOL_WINDOW_TOOLBAR_PLACE = "TOOL_WINDOW_TOOLBAR";
    static final String LABEL_HEADER = "LABEL";
    static final String SEARCH_HEADER = "SEARCH";
    private final String myWorkBenchName;
    private final ToolWindowDefinition<T> myDefinition;
    private final PropertiesComponent myPropertiesComponent;
    private final SideModel<T> myModel;
    private final JPanel myPanel;
    private final List<UpdatableActionButton> myActionButtons;
    private final AbstractButton myMinimizedButton;
    private final MySearchField mySearchField;
    private final ActionButton mySearchActionButton;
    private ButtonDragListener<T> myDragListener;
    @Nullable
    private ToolContent<T> myContent;
    private boolean myAutoHideOpen;
    private int myToolOrder;

    AttachedToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ButtonDragListener<T> dragListener, @NotNull String workBenchName, @NotNull SideModel<T> model2) {
        this.myWorkBenchName = workBenchName;
        this.myDefinition = definition;
        this.myDragListener = dragListener;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myModel = model2;
        this.myPanel = new JPanel(new BorderLayout());
        if (!ScreenReader.isActive()) {
            this.myPanel.setFocusCycleRoot(true);
        }
        this.myPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.myActionButtons = new ArrayList<UpdatableActionButton>(4);
        this.myMinimizedButton = new MinimizedButton(definition.getTitle(), definition.getIcon(), this);
        this.mySearchField = new MySearchField(TOOL_WINDOW_PROPERTY_PREFIX + workBenchName + ".TEXT_SEARCH_HISTORY");
        this.mySearchActionButton = this.createActionButton(new SearchAction(), this.myDefinition.getButtonSize());
        this.setDefaultProperty(PropertyType.LEFT, definition.getSide().isLeft());
        this.setDefaultProperty(PropertyType.SPLIT, definition.getSplit().isBottom());
        this.setDefaultProperty(PropertyType.AUTO_HIDE, definition.getAutoHide().isAutoHide());
        this.updateContent();
        DumbService.getInstance((Project)model2.getProject()).smartInvokeLater(this::updateActions);
        AnAction globalFindAction = ActionManager.getInstance().getAction("Find");
        if (globalFindAction != null) {
            new FindAction().registerCustomShortcutSet(globalFindAction.getShortcutSet(), this.myPanel, this);
        }
    }

    public void dispose() {
        if (this.myContent != null) {
            this.myContent = null;
            this.myDragListener = null;
            this.myPanel.removeAll();
        }
    }

    @NotNull
    public String getToolName() {
        return this.myDefinition.getName();
    }

    public int getToolOrder() {
        return this.myToolOrder;
    }

    public void setToolOrder(int order) {
        this.myToolOrder = order;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    public AbstractButton getMinimizedButton() {
        return this.myMinimizedButton;
    }

    @Nullable
    public T getContext() {
        return this.myModel.getContext();
    }

    public ToolWindowDefinition<T> getDefinition() {
        return this.myDefinition;
    }

    public boolean isMinimized() {
        return this.getProperty(PropertyType.MINIMIZED);
    }

    public void setMinimized(boolean value) {
        this.setProperty(PropertyType.MINIMIZED, value);
    }

    public boolean isLeft() {
        return this.getProperty(PropertyType.LEFT);
    }

    public void setLeft(boolean value) {
        this.setProperty(PropertyType.LEFT, value);
    }

    public boolean isSplit() {
        return this.getProperty(PropertyType.SPLIT);
    }

    public void setSplit(boolean value) {
        this.setProperty(PropertyType.SPLIT, value);
    }

    public boolean isAutoHide() {
        return this.getProperty(PropertyType.AUTO_HIDE);
    }

    public void setAutoHide(boolean value) {
        this.setProperty(PropertyType.AUTO_HIDE, value);
    }

    public boolean isFloating() {
        return this.getProperty(PropertyType.FLOATING);
    }

    public void setFloating(boolean value) {
        this.setProperty(PropertyType.FLOATING, value);
    }

    public boolean isDetached() {
        return this.getProperty(PropertyType.DETACHED);
    }

    public void setDetached(boolean value) {
        this.setProperty(PropertyType.DETACHED, value);
    }

    public boolean getProperty(@NotNull PropertyType property) {
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            return !this.myAutoHideOpen;
        }
        return this.getLayoutProperty(Layout.CURRENT, property);
    }

    public void setProperty(@NotNull PropertyType property, boolean value) {
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            this.myAutoHideOpen = !value;
        } else {
            this.setLayoutProperty(Layout.CURRENT, property, value);
        }
        if (this.myMinimizedButton != null) {
            this.myMinimizedButton.setSelected(!this.isMinimized());
        }
    }

    private boolean getLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property) {
        return this.myPropertiesComponent.getBoolean(this.getPropertyName(layout, property));
    }

    private void setLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property, boolean value) {
        this.myPropertiesComponent.setValue(this.getPropertyName(layout, property), value);
    }

    public void setDefaultProperty(@NotNull PropertyType property, boolean defaultValue) {
        if (!this.myPropertiesComponent.isValueSet(this.getPropertyName(Layout.DEFAULT, property))) {
            this.myPropertiesComponent.setValue(this.getPropertyName(Layout.DEFAULT, property), defaultValue, !defaultValue);
            this.setLayoutProperty(Layout.CURRENT, property, defaultValue);
        }
    }

    private String getPropertyName(@NotNull Layout layout, @NotNull PropertyType property) {
        return TOOL_WINDOW_PROPERTY_PREFIX + layout.getPrefix() + this.myWorkBenchName + "." + this.myDefinition.getName() + "." + property.name();
    }

    public void setPropertyAndUpdate(@NotNull PropertyType property, boolean value) {
        this.setProperty(property, value);
        if (property == PropertyType.FLOATING && value) {
            property = PropertyType.DETACHED;
            this.setProperty(property, true);
        }
        this.updateContent();
        this.updateActions();
        this.myModel.update(this, property);
        if (property == PropertyType.MINIMIZED && !value && this.myContent != null) {
            this.myContent.getFocusedComponent().requestFocus();
        }
    }

    public void storeDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setLayoutProperty(Layout.DEFAULT, property, this.getLayoutProperty(Layout.CURRENT, property));
        }
    }

    public void restoreDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setProperty(property, this.getLayoutProperty(Layout.DEFAULT, property));
        }
    }

    public void setContext(T context) {
        if (this.myContent != null) {
            this.myContent.setToolContext(context);
        }
    }

    @VisibleForTesting
    public SearchTextField getSearchField() {
        return this.mySearchField;
    }

    @VisibleForTesting
    @Nullable
    ToolContent<T> getContent() {
        return this.myContent;
    }

    private void updateContent() {
        if (this.isDetached() && this.myContent != null) {
            this.myPanel.removeAll();
            this.myContent.setToolContext(null);
            Disposer.dispose(this.myContent);
            this.myContent = null;
        } else if (!this.isDetached() && this.myContent == null) {
            this.myContent = this.myDefinition.getFactory().apply(this);
            assert (this.myContent != null);
            this.myContent.setToolContext(this.myModel.getContext());
            this.myContent.registerCallbacks(this);
            this.myPanel.add((Component)this.createHeader(this.myContent.supportsFiltering(), this.myContent.getAdditionalActions()), "North");
            this.myPanel.add((Component)this.myContent.getComponent(), "Center");
        }
    }

    @Override
    public void restore() {
        if (!this.isDetached() && this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, false);
        }
    }

    @Override
    public void autoHide() {
        if (!this.isDetached() && this.isAutoHide() && !this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private JComponent createHeader(boolean includeSearchButton, @NotNull List<AnAction> additionalActions) {
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)AttachedToolWindow.createTitlePanel(this.myDefinition.getTitle(), includeSearchButton, this.mySearchField), "Center");
        header.add((Component)this.createActionPanel(includeSearchButton, additionalActions), "East");
        header.setBorder((Border)new SideBorder(JBColor.border(), 8));
        return header;
    }

    @NotNull
    private static JPanel createTitlePanel(@NotNull String title, boolean includeSearchField, @NotNull SearchTextField searchField) {
        CardLayout layout = new CardLayout();
        JPanel titlePanel = new JPanel(layout);
        JBLabel titleLabel = new JBLabel(title){

            public void updateUI() {
                super.updateUI();
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }
        };
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)10));
        titlePanel.add((Component)titleLabel, LABEL_HEADER);
        if (includeSearchField) {
            searchField.setPreferredSize(new Dimension(searchField.getPreferredSize().width, titlePanel.getPreferredSize().height));
            titlePanel.add((Component)searchField, SEARCH_HEADER);
        }
        layout.show(titlePanel, LABEL_HEADER);
        return titlePanel;
    }

    private void showSearchField(boolean show) {
        if (this.myContent == null || !this.myContent.supportsFiltering()) {
            return;
        }
        Container parent = this.mySearchField.getParent();
        CardLayout layout = (CardLayout)parent.getLayout();
        if (show) {
            layout.show(parent, SEARCH_HEADER);
            this.mySearchField.requestFocus();
        } else {
            layout.show(parent, LABEL_HEADER);
        }
        this.mySearchActionButton.setVisible(!show);
    }

    @Override
    public void startFiltering(@NotNull String initialSearchString) {
        if (this.myContent == null || !this.myContent.supportsFiltering()) {
            return;
        }
        this.mySearchField.setText(initialSearchString);
        this.showSearchField(true);
    }

    @Override
    public void stopFiltering() {
        if (this.myContent == null || !this.myContent.supportsFiltering()) {
            return;
        }
        this.mySearchField.setText("");
        this.showSearchField(false);
    }

    @NotNull
    private JComponent createActionPanel(boolean includeSearchButton, @NotNull List<AnAction> additionalActions) {
        Dimension buttonSize = this.myDefinition.getButtonSize();
        int border = buttonSize.equals(ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE) ? 4 : 2;
        JPanel actionPanel = new JPanel(new FlowLayout(1, 0, 0));
        actionPanel.setOpaque(false);
        actionPanel.setBorder((Border)JBUI.Borders.empty((int)border, (int)0));
        if (includeSearchButton) {
            actionPanel.add((Component)this.mySearchActionButton);
            this.mySearchActionButton.setVisible(true);
        }
        if (!additionalActions.isEmpty()) {
            additionalActions.forEach(action -> actionPanel.add((Component)this.createActionButton((AnAction)action, buttonSize)));
            actionPanel.add(new JLabel(AllIcons.General.Divider));
        }
        actionPanel.add((Component)this.createActionButton(new GearAction(), buttonSize));
        actionPanel.add((Component)this.createActionButton(new HideAction(), buttonSize));
        return actionPanel;
    }

    @NotNull
    private ActionButton createActionButton(@NotNull AnAction action, @NotNull Dimension buttonSize) {
        UpdatableActionButton button = new UpdatableActionButton(action, buttonSize);
        button.setFocusable(true);
        this.myActionButtons.add(button);
        return button;
    }

    private void updateActions() {
        this.myActionButtons.forEach(UpdatableActionButton::update);
    }

    private void showGearPopup(@NotNull Component component, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        this.addGearPopupActions(group);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)group);
        popupMenu.getComponent().show(component, x, y);
    }

    private void addGearPopupActions(@NotNull DefaultActionGroup group) {
        List<AnAction> myExtraGearActions;
        if (this.myContent != null && !(myExtraGearActions = this.myContent.getGearActions()).isEmpty()) {
            group.addAll(myExtraGearActions);
            group.addSeparator();
        }
        DefaultActionGroup attachedSide = new DefaultActionGroup("Attached Side", true);
        attachedSide.add((AnAction)new TogglePropertyTypeAction(PropertyType.LEFT, "Left"));
        attachedSide.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.LEFT, "Right"));
        attachedSide.add((AnAction)new SwapAction());
        attachedSide.add((AnAction)new TogglePropertyTypeAction(PropertyType.DETACHED, "None"));
        group.add((AnAction)attachedSide);
        ActionManager manager = ActionManager.getInstance();
        group.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.AUTO_HIDE, manager.getAction("ToggleDockMode")));
        group.add((AnAction)new TogglePropertyTypeAction(PropertyType.FLOATING, manager.getAction("ToggleFloatingMode")));
        group.add((AnAction)new TogglePropertyTypeAction(PropertyType.SPLIT, manager.getAction("ToggleSideMode")));
    }

    @VisibleForTesting
    void fireButtonDragged(@NotNull DragEvent event) {
        this.myDragListener.buttonDragged(this, event);
    }

    @VisibleForTesting
    void fireButtonDropped(@NotNull DragEvent event) {
        this.myDragListener.buttonDropped(this, event);
    }

    private final class FindAction
    extends DumbAwareAction {
        private FindAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.showSearchField(true);
        }
    }

    private class MySearchField
    extends SearchTextField
    implements KeyListener {
        private Component myOldFocusComponent;

        private MySearchField(String propertyName) {
            super(propertyName);
            this.addKeyboardListener(this);
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (AttachedToolWindow.this.myContent != null) {
                        AttachedToolWindow.this.myContent.setFilter(MySearchField.this.getText().trim());
                    }
                }
            });
            this.getTextEditor().addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(@NotNull FocusEvent event) {
                    MySearchField.this.myOldFocusComponent = event.getOppositeComponent();
                }
            });
        }

        protected void onFocusLost() {
            Component focusedDescendant = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)((Object)this));
            if (focusedDescendant == null && this.getText().trim().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
            }
            this.myOldFocusComponent = null;
            super.onFocusLost();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyTyped(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyPressed(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
            if (event.getKeyCode() == 27 && this.getText().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
                if (this.myOldFocusComponent != null) {
                    this.myOldFocusComponent.requestFocus();
                } else if (AttachedToolWindow.this.myContent != null) {
                    AttachedToolWindow.this.myContent.getFocusedComponent().requestFocus();
                } else {
                    AttachedToolWindow.this.mySearchActionButton.requestFocus();
                }
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyReleased(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }
    }

    private class SwapAction
    extends AnAction {
        private SwapAction() {
            super("Swap");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.myModel.swap();
            AttachedToolWindow.this.updateActions();
        }
    }

    private class ToggleOppositePropertyTypeAction
    extends TogglePropertyTypeAction {
        private ToggleOppositePropertyTypeAction(@NotNull PropertyType property, String text) {
            super(property, text);
        }

        private ToggleOppositePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            super(property, action);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            return !super.isSelected(event);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            super.setSelected(event, !state);
        }
    }

    private class TogglePropertyTypeAction
    extends ToggleAction {
        private final PropertyType myProperty;

        private TogglePropertyTypeAction(@NotNull PropertyType property, String text) {
            super(text);
            this.myProperty = property;
        }

        private TogglePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            this.myProperty = property;
            this.copyFrom(action);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return AttachedToolWindow.this.getProperty(this.myProperty);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            AttachedToolWindow.this.setPropertyAndUpdate(this.myProperty, state);
        }
    }

    private class HideAction
    extends AnAction {
        private HideAction() {
            super(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]), null, AllIcons.General.HideToolWindow);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    private class GearAction
    extends AnAction {
        private GearAction() {
            super("More Options", null, AllIcons.General.GearPlain);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            int x = 0;
            int y = 0;
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            AttachedToolWindow.this.showGearPopup(inputEvent.getComponent(), x, y);
        }
    }

    private class SearchAction
    extends AnAction {
        private SearchAction() {
            super("Search");
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.Actions.Find);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.showSearchField(true);
        }
    }

    private static class UpdatableActionButton
    extends ActionButton {
        private UpdatableActionButton(@NotNull AnAction action, @NotNull Dimension buttonSize) {
            super(action, action.getTemplatePresentation().clone(), AttachedToolWindow.TOOL_WINDOW_TOOLBAR_PLACE, buttonSize);
        }

        public void update() {
            AnActionEvent event = new AnActionEvent(null, this.getDataContext(), this.myPlace, this.myPresentation, ActionManager.getInstance(), 0);
            ActionUtil.performDumbAwareUpdate((boolean)false, (AnAction)this.myAction, (AnActionEvent)event, (boolean)false);
        }

        protected void presentationPropertyChanged(@NotNull PropertyChangeEvent event) {
            super.presentationPropertyChanged(event);
            this.update();
        }
    }

    private static class MinimizedButton
    extends AnchoredButton {
        private final AttachedToolWindow myToolWindow;
        private JLabel myDragImage;
        private Point myStartDragPosition;

        private MinimizedButton(@NotNull String title, @NotNull Icon icon, @NotNull AttachedToolWindow toolWindow) {
            super(title, icon);
            this.myToolWindow = toolWindow;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setSelected(!toolWindow.isMinimized());
            this.setOpaque(false);
            this.setBackground(null);
            MouseInputAdapter listener = new MouseInputAdapter(){

                @Override
                public void mouseDragged(@NotNull MouseEvent event) {
                    this.handleDragging(event);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent event) {
                    this.stopDragging(event);
                }

                @Override
                public void mouseClicked(@NotNull MouseEvent event) {
                    if (event.getButton() <= 1) {
                        this.setSelected(false);
                        myToolWindow.setPropertyAndUpdate(PropertyType.MINIMIZED, !myToolWindow.isMinimized());
                    } else {
                        myToolWindow.showGearPopup((Component)((Object)this), event.getX(), event.getY());
                    }
                }
            };
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
        }

        public void updateUI() {
            this.setUI(StripeButtonUI.createUI((JComponent)((Object)this)));
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public void paint(@NotNull Graphics graphics) {
            if (this.isDragging()) {
                return;
            }
            if (!this.myToolWindow.isLeft()) {
                super.paint(graphics);
                return;
            }
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(JBUI.scale((int)1), 0);
                super.paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }

        public int getMnemonic2() {
            return 0;
        }

        public ToolWindowAnchor getAnchor() {
            return this.myToolWindow.isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
        }

        private boolean isDragging() {
            return this.myDragImage != null;
        }

        private void handleDragging(@NotNull MouseEvent event) {
            if (!this.isDragging()) {
                this.startDragging(event);
            }
            this.myToolWindow.fireButtonDragged(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
        }

        private void stopDragging(@NotNull MouseEvent event) {
            if (this.isDragging()) {
                this.myToolWindow.fireButtonDropped(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
                this.myDragImage = null;
                this.myStartDragPosition = null;
            }
        }

        private void startDragging(@NotNull MouseEvent event) {
            BufferedImage image = UIUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
            Graphics graphics = image.getGraphics();
            this.paint(graphics);
            graphics.dispose();
            this.myDragImage = new JBLabel((Icon)new JBImageIcon((Image)image));
            this.myStartDragPosition = event.getPoint();
        }
    }

    static interface ButtonDragListener<T> {
        public void buttonDragged(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);

        public void buttonDropped(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);
    }

    static class DragEvent {
        private final MouseEvent myMouseEvent;
        private final Component myDragImage;
        private final Point myDragPoint;

        DragEvent(@NotNull MouseEvent mouseEvent, @NotNull Component dragImage, @NotNull Point dragPoint) {
            this.myMouseEvent = mouseEvent;
            this.myDragImage = dragImage;
            this.myDragPoint = dragPoint;
        }

        @NotNull
        public Point getMousePoint() {
            return this.myMouseEvent.getPoint();
        }

        @NotNull
        public Component getDragImage() {
            return this.myDragImage;
        }

        @NotNull
        public Point getDragPoint() {
            return this.myDragPoint;
        }
    }

    static enum PropertyType {
        AUTO_HIDE,
        MINIMIZED,
        LEFT,
        SPLIT,
        DETACHED,
        FLOATING;

    }
}

