/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DetachedToolWindow<T>
implements ToolWindowCallback,
Disposable {
    private final ToolContent<T> myContent;
    private final ToolWindowEx myToolWindow;
    private AttachedToolWindow<T> myCorrespondingToolWindow;

    DetachedToolWindow(@NotNull Project project, @NotNull ToolWindowDefinition<T> definition) {
        this(definition, ToolWindowManager.getInstance((Project)project));
    }

    private DetachedToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ToolWindowManager toolWindowManager) {
        this.myContent = definition.getFactory().apply(this);
        this.myToolWindow = this.createToolWindow(toolWindowManager, definition);
    }

    public void show(@NotNull AttachedToolWindow<T> correspondingWindow) {
        this.updateState(correspondingWindow);
        this.myContent.setToolContext(correspondingWindow.getContext());
        this.myContent.registerCallbacks(this);
        this.myToolWindow.setAvailable(true, null);
        this.myToolWindow.setType(this.toToolWindowType(correspondingWindow), null);
        this.myToolWindow.setSplitMode(correspondingWindow.isSplit(), null);
        this.myToolWindow.show(null);
    }

    public void hide() {
        this.myContent.setToolContext(null);
        this.myToolWindow.setAvailable(false, null);
    }

    @Override
    public void restore() {
        if (this.myToolWindow.isAvailable() && !this.myToolWindow.isVisible()) {
            this.myToolWindow.show(null);
        }
    }

    @NotNull
    private ToolWindowType toToolWindowType(@NotNull AttachedToolWindow<T> attachedToolWindow) {
        if (attachedToolWindow.isFloating()) {
            return ToolWindowType.FLOATING;
        }
        if (attachedToolWindow.isAutoHide()) {
            return ToolWindowType.SLIDING;
        }
        return ToolWindowType.DOCKED;
    }

    private void updateState(@NotNull AttachedToolWindow<T> correspondingWindow) {
        this.myCorrespondingToolWindow = correspondingWindow;
    }

    private ToolWindowEx createToolWindow(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindowDefinition<T> definition) {
        String id = definition.getTitle();
        ToolWindowEx window = (ToolWindowEx)toolWindowManager.getToolWindow(id);
        if (window == null) {
            ToolWindowAnchor anchor = definition.getSide().isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
            window = (ToolWindowEx)toolWindowManager.registerToolWindow(id, false, anchor, (Disposable)this, true);
            window.setIcon(definition.getIcon());
            window.setAutoHide(false);
            this.setToolWindowContent(window);
            this.setAdditionalGearPopupActions(window);
            this.setAdditionalActions(window);
        }
        return window;
    }

    private void setToolWindowContent(@NotNull ToolWindowEx toolWindow) {
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getSelectedContent();
        if (content == null) {
            content = contentManager.getFactory().createContent(this.myContent.getComponent(), null, false);
            content.setCloseable(false);
            content.setComponent(this.myContent.getComponent());
            content.setPreferredFocusableComponent(this.myContent.getFocusedComponent());
            content.setShouldDisposeContent(true);
            contentManager.addContent(content);
            contentManager.setSelectedContent(content, true);
        }
    }

    private void setAdditionalActions(@NotNull ToolWindowEx toolWindow) {
        List<AnAction> actionList = this.myContent.getAdditionalActions();
        if (!actionList.isEmpty()) {
            AnAction[] actions = new AnAction[actionList.size()];
            actionList.toArray(actions);
            toolWindow.setTitleActions(actions);
        }
    }

    private void setAdditionalGearPopupActions(@NotNull ToolWindowEx toolWindow) {
        DefaultActionGroup attachedSide = new DefaultActionGroup("Attached Side", true);
        attachedSide.add((AnAction)new AttachToSideAction(Side.LEFT));
        attachedSide.add((AnAction)new AttachToSideAction(Side.RIGHT));
        attachedSide.add((AnAction)new DetachedAction());
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{attachedSide}));
    }

    public void dispose() {
    }

    public void updateSettingsInAttachedToolWindow() {
        this.myCorrespondingToolWindow.setAutoHide(this.myToolWindow.getType() == ToolWindowType.SLIDING);
        this.myCorrespondingToolWindow.setFloating(this.myToolWindow.getType() == ToolWindowType.FLOATING);
        this.myCorrespondingToolWindow.setSplit(this.myToolWindow.isSplitMode());
    }

    private static class DetachedAction
    extends ToggleAction {
        private DetachedAction() {
            super("None");
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return true;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
        }
    }

    private class AttachToSideAction
    extends AnAction {
        private final Side mySide;

        private AttachToSideAction(Side side) {
            super(side.isLeft() ? "Left" : "Right");
            this.mySide = side;
        }

        public void update(@NotNull AnActionEvent event) {
            event.getPresentation().setEnabledAndVisible(DetachedToolWindow.this.myCorrespondingToolWindow != null);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (DetachedToolWindow.this.myCorrespondingToolWindow != null) {
                DetachedToolWindow.this.myToolWindow.setAvailable(false, null);
                DetachedToolWindow.this.updateSettingsInAttachedToolWindow();
                DetachedToolWindow.this.myCorrespondingToolWindow.setLeft(this.mySide.isLeft());
                DetachedToolWindow.this.myCorrespondingToolWindow.setPropertyAndUpdate(AttachedToolWindow.PropertyType.DETACHED, false);
            }
        }
    }
}

