/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.DetachedToolWindow;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetachedToolWindowManager
implements ProjectComponent {
    private final Application myApplication;
    private final Project myProject;
    private final FileEditorManager myEditorManager;
    private final MyFileEditorManagerListener myEditorManagerListener;
    private final Map<FileEditor, WorkBench> myWorkBenchMap;
    private final HashMap<String, DetachedToolWindow> myToolWindowMap;
    private DetachedToolWindowFactory myDetachedToolWindowFactory;
    private FileEditor myLastSelectedEditor;

    public static DetachedToolWindowManager getInstance(@NotNull Project project) {
        return (DetachedToolWindowManager)project.getComponent(DetachedToolWindowManager.class);
    }

    DetachedToolWindowManager(@NotNull Application application, @NotNull Project currentProject, @NotNull FileEditorManager fileEditorManager) {
        this.myApplication = application;
        this.myProject = currentProject;
        this.myEditorManager = fileEditorManager;
        this.myEditorManagerListener = new MyFileEditorManagerListener();
        this.myWorkBenchMap = new IdentityHashMap<FileEditor, WorkBench>(13);
        this.myToolWindowMap = new HashMap(8);
        this.myDetachedToolWindowFactory = DetachedToolWindow::new;
    }

    void setDetachedToolWindowFactory(@NotNull DetachedToolWindowFactory factory) {
        this.myDetachedToolWindowFactory = factory;
    }

    FileEditorManagerListener getFileEditorManagerListener() {
        return this.myEditorManagerListener;
    }

    public void register(@Nullable FileEditor fileEditor, @NotNull WorkBench workBench) {
        if (fileEditor != null) {
            this.myWorkBenchMap.put(fileEditor, workBench);
            if (fileEditor == this.myLastSelectedEditor) {
                this.updateToolWindowsForWorkBench(workBench);
            }
        }
    }

    public void unregister(@Nullable FileEditor fileEditor) {
        if (fileEditor != null) {
            this.myWorkBenchMap.remove(fileEditor);
        }
    }

    @NotNull
    public String getComponentName() {
        return DetachedToolWindowManager.class.getSimpleName();
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myEditorManagerListener);
    }

    public void projectClosed() {
        for (DetachedToolWindow detachedToolWindow : this.myToolWindowMap.values()) {
            detachedToolWindow.updateSettingsInAttachedToolWindow();
        }
    }

    @Nullable
    private WorkBench getActiveWorkBench() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof WorkBench) {
            return (WorkBench)((Object)focusOwner);
        }
        WorkBench current = (WorkBench)((Object)SwingUtilities.getAncestorOfClass(WorkBench.class, focusOwner));
        if (current != null) {
            return current;
        }
        FileEditor[] selectedEditors = this.myEditorManager.getSelectedEditors();
        if (selectedEditors.length == 0) {
            return null;
        }
        if (selectedEditors.length == 1) {
            return this.myWorkBenchMap.get(selectedEditors[0]);
        }
        if (focusOwner != null) {
            for (FileEditor editor : selectedEditors) {
                if (!SwingUtilities.isDescendingFrom(focusOwner, editor.getComponent())) continue;
                return this.myWorkBenchMap.get(editor);
            }
        }
        return this.myWorkBenchMap.get(selectedEditors[0]);
    }

    public void updateToolWindowsForWorkBench(@Nullable WorkBench workBench) {
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<String> ids = new HashSet<String>(this.myToolWindowMap.keySet());
        if (workBench != null) {
            List detachedToolWindows = workBench.getDetachedToolWindows();
            for (AttachedToolWindow tool : detachedToolWindows) {
                ToolWindowDefinition definition = tool.getDefinition();
                String id2 = definition.getName();
                DetachedToolWindow detachedToolWindow = this.myToolWindowMap.get(id2);
                if (detachedToolWindow == null) {
                    detachedToolWindow = this.myDetachedToolWindowFactory.create(this.myProject, definition);
                    Disposer.register((Disposable)this.myProject, (Disposable)detachedToolWindow);
                    this.myToolWindowMap.put(id2, detachedToolWindow);
                }
                if (!ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled()) {
                    detachedToolWindow.show(tool);
                }
                ids.remove(id2);
            }
        }
        ids.forEach(id -> this.myToolWindowMap.get(id).hide());
    }

    public void restoreDefaultLayout() {
        this.myApplication.invokeLater(() -> this.updateToolWindowsForWorkBench(this.getActiveWorkBench()));
    }

    static interface DetachedToolWindowFactory {
        public DetachedToolWindow create(@NotNull Project var1, @NotNull ToolWindowDefinition var2);
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            DetachedToolWindowManager.this.myApplication.invokeLater(() -> DetachedToolWindowManager.this.updateToolWindowsForWorkBench(DetachedToolWindowManager.this.getActiveWorkBench()));
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            DetachedToolWindowManager.this.myApplication.invokeLater(() -> DetachedToolWindowManager.this.updateToolWindowsForWorkBench(DetachedToolWindowManager.this.getActiveWorkBench()));
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            DetachedToolWindowManager.this.myLastSelectedEditor = event.getNewEditor();
            DetachedToolWindowManager.this.updateToolWindowsForWorkBench((WorkBench)((Object)DetachedToolWindowManager.this.myWorkBenchMap.get(DetachedToolWindowManager.this.myLastSelectedEditor)));
        }
    }
}

