/*
 * Decompiled with CFR 0.152.
 */
package com.google.services;

import com.android.ddmlib.ClientData;
import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FirebaseLogcatFilterProvider
implements LogcatFilterProvider {
    private static final AndroidLogcatFilter FILTER = new FirebaseLogcatFilter();

    @NotNull
    public AndroidLogcatFilter getFilter(@Nullable ClientData client) {
        return FILTER;
    }

    private static class FirebaseLogcatFilter
    implements AndroidLogcatFilter {
        private static final Pattern myFirebasePackagePattern = Pattern.compile("com\\.google\\.firebase\\..*");
        private static final Pattern myAppIndexingTagPattern = Pattern.compile("AppIndexApi");

        private FirebaseLogcatFilter() {
        }

        @NotNull
        public String getName() {
            return "Firebase";
        }

        public boolean isApplicable(@NotNull String message, @NotNull String tag, @NotNull String pkg, int pid, @NotNull Log.LogLevel logLevel) {
            return myAppIndexingTagPattern.matcher(tag).find() || myFirebasePackagePattern.matcher(pkg).find();
        }
    }
}

