/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import kotlin.Metadata;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/android/AndroidResourceReferenceAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getResourceReferenceTargetDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaPropertyDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "intellij.android.kotlin.idea"})
public final class AndroidResourceReferenceAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (((Boolean)StudioFlags.GUTTER_ICON_ANNOTATOR_IN_BACKGROUND_ENABLED.get()).booleanValue()) {
            return;
        }
        PsiElement psiElement = element;
        if (!(psiElement instanceof KtReferenceExpression)) {
            psiElement = null;
        }
        KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)psiElement;
        if (ktReferenceExpression == null) {
            return;
        }
        KtReferenceExpression reference = ktReferenceExpression;
        AndroidFacet androidFacet = AndroidFacet.getInstance((PsiElement)element);
        if (androidFacet == null) {
            return;
        }
        AndroidFacet androidFacet2 = androidFacet;
        JavaPropertyDescriptor javaPropertyDescriptor = this.getResourceReferenceTargetDescriptor(reference);
        if (javaPropertyDescriptor == null) {
            return;
        }
        JavaPropertyDescriptor referenceTarget = javaPropertyDescriptor;
        ResourceType resourceType = AndroidUtilKt.getAndroidResourceType(referenceTarget);
        if (resourceType == null) {
            return;
        }
        ResourceType resourceType2 = resourceType;
        if (resourceType2 != ResourceType.COLOR && resourceType2 != ResourceType.DRAWABLE && resourceType2 != ResourceType.MIPMAP) {
            return;
        }
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidUtilKt.getResourceReferenceType(referenceTarget);
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration((PsiFile)((KtReferenceExpression)element).getContainingFile(), (AndroidFacet)androidFacet2);
        if (configuration == null) {
            return;
        }
        Configuration configuration2 = configuration;
        ResourceValue resourceValue = AndroidAnnotatorUtil.findResourceValue((ResourceType)resourceType2, (String)reference.getText(), (referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK ? 1 : 0) != 0, (Module)androidFacet2.getModule(), (Configuration)configuration2);
        if (resourceValue == null) {
            return;
        }
        ResourceValue resourceValue2 = resourceValue;
        ResourceResolver resourceResolver = configuration2.getResourceResolver();
        if (resourceResolver == null) {
            return;
        }
        ResourceResolver resourceResolver2 = resourceResolver;
        if (resourceType2 == ResourceType.COLOR) {
            Color color = ResourceHelper.resolveColor((RenderResources)((RenderResources)resourceResolver2), (ResourceValue)resourceValue2, (Project)((KtReferenceExpression)element).getProject());
            if (color != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, color, false));
            }
        } else {
            VirtualFile iconFile = AndroidAnnotatorUtil.resolveDrawableFile((ResourceValue)resourceValue2, (ResourceResolver)resourceResolver2, (AndroidFacet)androidFacet2);
            if (iconFile != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver2, androidFacet2, iconFile, configuration2));
            }
        }
    }

    private final JavaPropertyDescriptor getResourceReferenceTargetDescriptor(@NotNull KtReferenceExpression $receiver) {
        ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$receiver), null, (int)1, null);
        Object object = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        if (!(object instanceof JavaPropertyDescriptor)) {
            object = null;
        }
        return (JavaPropertyDescriptor)object;
    }
}

