/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.navigation;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElementWithRequiredName;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.AndroidUtilKt;
import org.jetbrains.kotlin.android.navigation.GotoResourceHelperKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public class KotlinAndroidGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        KtSimpleNameExpression referenceExpression = GotoResourceHelperKt.getReferenceExpression(sourceElement);
        if (referenceExpression == null) {
            return null;
        }
        AndroidFacet facet = AndroidUtilKt.getAndroidFacetForFile((PsiElement)referenceExpression);
        if (facet == null) {
            return null;
        }
        AndroidResourceUtil.MyReferredResourceFieldInfo info = GotoResourceHelperKt.getInfo(referenceExpression, facet);
        if (info == null) {
            return null;
        }
        String nestedClassName = info.getClassName();
        String fieldName = info.getFieldName();
        ArrayList<PsiElement> resourceList = new ArrayList<PsiElement>();
        if (info.isFromManifest()) {
            KotlinAndroidGotoDeclarationHandler.collectManifestElements(nestedClassName, fieldName, facet, resourceList);
        } else {
            LocalResourceManager manager;
            ModuleResourceManagers managers = ModuleResourceManagers.getInstance((AndroidFacet)facet);
            Object object = manager = info.getNamespace() == ResourceNamespace.ANDROID ? managers.getFrameworkResourceManager(false) : managers.getLocalResourceManager();
            if (manager == null) {
                return null;
            }
            manager.collectLazyResourceElements(info.getNamespace(), nestedClassName, fieldName, false, (PsiElement)referenceExpression, resourceList);
            if (manager instanceof LocalResourceManager) {
                LocalResourceManager lrm = manager;
                if (nestedClassName.equals(ResourceType.ATTR.getName())) {
                    for (Attr attr : lrm.findAttrs(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                    }
                } else if (nestedClassName.equals(ResourceType.STYLEABLE.getName())) {
                    for (DeclareStyleable styleable : lrm.findStyleables(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)styleable.getName().getXmlAttributeValue());
                    }
                    for (DeclareStyleable styleable : lrm.findStyleableAttributesByFieldName(info.getNamespace(), fieldName)) {
                        resourceList.add((PsiElement)styleable.getName().getXmlAttributeValue());
                    }
                }
            }
        }
        if (resourceList.size() > 1) {
            Collections.sort(resourceList, AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        return resourceList.toArray(PsiElement.EMPTY_ARRAY);
    }

    private static void collectManifestElements(@NotNull String nestedClassName, @NotNull String fieldName, @NotNull AndroidFacet facet, @NotNull List<PsiElement> result) {
        List list;
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return;
        }
        if ("permission".equals(nestedClassName)) {
            list = manifest.getPermissions();
        } else if ("permission_group".equals(nestedClassName)) {
            list = manifest.getPermissionGroups();
        } else {
            return;
        }
        for (ManifestElementWithRequiredName domElement : list) {
            XmlAttributeValue psiElement;
            AndroidAttributeValue nameAttribute = domElement.getName();
            String name = (String)nameAttribute.getValue();
            if (!AndroidUtils.equal((String)name, (String)fieldName, (boolean)false) || (psiElement = nameAttribute.getXmlAttributeValue()) == null) continue;
            result.add((PsiElement)psiElement);
        }
    }

    public String getActionText(DataContext context) {
        return null;
    }
}

