/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.sync.ng;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModuleProcessor;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncAndroidModels;
import com.android.tools.idea.gradle.project.sync.ng.ExtraGradleSyncJavaModels;
import com.android.tools.idea.gradle.project.sync.ng.caching.CachedModuleModels;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.android.synthetic.AndroidCommandLineProcessor;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.gradle.model.AllOpen;
import org.jetbrains.kotlin.gradle.model.CompilerArguments;
import org.jetbrains.kotlin.gradle.model.KotlinAndroidExtension;
import org.jetbrains.kotlin.gradle.model.KotlinProject;
import org.jetbrains.kotlin.gradle.model.NoArg;
import org.jetbrains.kotlin.gradle.model.SamWithReceiver;
import org.jetbrains.kotlin.gradle.model.SourceSet;
import org.jetbrains.kotlin.idea.configuration.GradleProjectImportHandler;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.kapt.idea.KaptGradleModel;
import org.jetbrains.kotlin.kapt.idea.KaptSourceSetModel;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class KotlinSyncModels {
    @NotNull
    private static final String ANDROID_COMPILER_PLUGIN_ID = AndroidCommandLineProcessor.Companion.getANDROID_COMPILER_PLUGIN_ID();
    @NotNull
    private static final String ANDROID_PLUGIN_OPTION_PREFIX = "plugin:" + ANDROID_COMPILER_PLUGIN_ID + ":";
    @NotNull
    private static final String ANDROID_PLUGIN_OPTION_FORMAT_STRING = ANDROID_PLUGIN_OPTION_PREFIX + "%s=%s";

    private static void configureKotlin(@NotNull GradleModuleModels moduleModels, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, boolean isAndroid) {
        KaptGradleModel kaptGradleModel;
        KotlinProject kotlinProject = (KotlinProject)moduleModels.findModel(KotlinProject.class);
        if (kotlinProject != null) {
            KotlinFacet facet = KotlinSyncModels.createAndAddFacet(module, modelsProvider);
            KotlinSyncModels.configureFacet(facet, kotlinProject, modelsProvider);
            KotlinSyncModels.configureCompilerArguments(facet, kotlinProject, isAndroid ? KotlinSyncModels.getSelectedVariantName(moduleModels) : null, modelsProvider);
            KotlinSyncModels.mirrorGradleImportHandlerConfiguration(moduleModels, facet, module);
            KotlinAndroidExtension extension = isAndroid ? (KotlinAndroidExtension)moduleModels.findModel(KotlinAndroidExtension.class) : null;
            KotlinSyncModels.setupKotlinAndroidExtensionAsFacetPluginOptions(facet, extension);
        }
        if ((kaptGradleModel = (KaptGradleModel)moduleModels.findModel(KaptGradleModel.class)) == null) {
            kaptGradleModel = (KaptGradleModel)moduleModels.findModel(IdeKaptGradleModel.class);
        }
        if (kaptGradleModel != null) {
            KotlinSyncModels.attemptToConfigureKapt(kaptGradleModel, module, modelsProvider, isAndroid);
        }
    }

    private static void attemptToConfigureKapt(@NotNull KaptGradleModel kaptModel, @NotNull Module module, @NotNull IdeModifiableModelsProvider provider, boolean isAndroid) {
        if (kaptModel.isEnabled()) {
            for (KaptSourceSetModel sourceSet : kaptModel.getSourceSets()) {
                if (isAndroid) {
                    KotlinSyncModels.populateAndroidModelWithKaptSourceSet(sourceSet, module, provider);
                    continue;
                }
                KotlinSyncModels.populateModelWithKaptSourceSet(sourceSet, module, provider);
            }
        }
    }

    private static void populateModelWithKaptSourceSet(@NotNull KaptSourceSetModel sourceSet, @NotNull Module module, @NotNull IdeModifiableModelsProvider provider) {
        File generatedKotlinSources = sourceSet.getGeneratedKotlinSourcesDirFile();
        File generatedJavaSources = sourceSet.getGeneratedSourcesDirFile();
        File generatedClasses = sourceSet.getGeneratedClassesDirFile();
        if (generatedKotlinSources != null) {
            KotlinSyncModels.addGeneratedFolderToContentEntry(module, provider, generatedKotlinSources, sourceSet.isTest());
        }
        if (generatedJavaSources != null) {
            KotlinSyncModels.addGeneratedFolderToContentEntry(module, provider, generatedJavaSources, sourceSet.isTest());
        }
        if (generatedClasses != null) {
            VirtualFile vGeneratedClasses = ExternalSystemUtil.refreshAndFindFileByIoFile((File)generatedClasses);
            if (vGeneratedClasses == null) {
                return;
            }
            Library library = KotlinSyncModels.getOrCreateLibraryForSourceSet(provider, module, sourceSet);
            library.getModifiableModel().addRoot(vGeneratedClasses, OrderRootType.CLASSES);
        }
    }

    @NotNull
    private static Library getOrCreateLibraryForSourceSet(@NotNull IdeModifiableModelsProvider provider, @NotNull Module module, @NotNull KaptSourceSetModel sourceSet) {
        String kaptLibraryName;
        ModifiableRootModel rootModel = provider.getModifiableRootModel(module);
        LibraryTable moduleLibraryTable = rootModel.getModuleLibraryTable();
        Library library = moduleLibraryTable.getLibraryByName(kaptLibraryName = sourceSet.isTest() ? "testKaptGeneratedClasses" : "kaptGeneratedClasses");
        if (library == null) {
            library = moduleLibraryTable.createLibrary(kaptLibraryName);
        }
        if (sourceSet.isTest()) {
            for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
                if (!orderEntry.getPresentableName().equals(kaptLibraryName) || !(orderEntry instanceof ModuleLibraryOrderEntryImpl)) continue;
                ((ModuleLibraryOrderEntryImpl)orderEntry).setScope(DependencyScope.TEST);
            }
        }
        return library;
    }

    private static void populateAndroidModelWithKaptSourceSet(@NotNull KaptSourceSetModel kaptSourceSet, @NotNull Module module, @NotNull IdeModifiableModelsProvider provider) {
        Object artifact;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module, (IdeModifiableModelsProvider)provider);
        if (androidFacet == null) {
            return;
        }
        AndroidModel androidModel = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel();
        if (!(androidModel instanceof AndroidModuleModel)) {
            return;
        }
        AndroidModuleModel androidModuleModel = (AndroidModuleModel)androidModel;
        String sourceSetName = kaptSourceSet.getSourceSetName();
        Variant variant = androidModuleModel.findVariantByName(KotlinSyncModels.getBaseVariantName(sourceSetName));
        if (variant == null) {
            return;
        }
        File generatedKotlinSources = kaptSourceSet.getGeneratedKotlinSourcesDirFile();
        if (generatedKotlinSources != null && variant.equals(androidModuleModel.getSelectedVariant())) {
            KotlinSyncModels.addGeneratedFolderToContentEntry(module, provider, generatedKotlinSources, kaptSourceSet.isTest());
        }
        if ((artifact = sourceSetName.endsWith("UnitTest") ? (BaseArtifact)variant.getExtraJavaArtifacts().stream().filter(ja -> ja.getName().equals("_unit_test_")).findFirst().orElse(null) : (sourceSetName.endsWith("AndroidTest") ? (BaseArtifact)variant.getExtraAndroidArtifacts().stream().filter(aa -> aa.getName().equals("_android_test_")).findFirst().orElse(null) : variant.getMainArtifact())) instanceof IdeBaseArtifact && generatedKotlinSources != null) {
            ((IdeBaseArtifact)artifact).addGeneratedSourceFolder(generatedKotlinSources);
        }
    }

    @NotNull
    private static String getBaseVariantName(@NotNull String sourceSetName) {
        sourceSetName = StringUtils.removeEnd((String)sourceSetName, (String)"UnitTest");
        return StringUtils.removeEnd((String)sourceSetName, (String)"AndroidTest");
    }

    private static void addGeneratedFolderToContentEntry(@NotNull Module module, @NotNull IdeModifiableModelsProvider provider, @NotNull File dirToAdd, boolean isTest) {
        SourceFolder folder;
        JpsModuleSourceRoot sourceRoot;
        JpsElement properties;
        ContentEntry[] contentEntries = provider.getModifiableRootModel(module).getContentEntries();
        ContentEntry parent2 = ContentEntries.findParentContentEntry((File)dirToAdd, Arrays.stream(contentEntries));
        if (parent2 != null && (properties = (sourceRoot = (folder = parent2.addSourceFolder(FilePaths.pathToIdeaUrl((File)dirToAdd), (JpsModuleSourceRootType)(isTest ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE))).getJpsElement()).getProperties()) instanceof JavaSourceRootProperties) {
            ((JavaSourceRootProperties)properties).setForGeneratedSources(true);
        }
    }

    @NotNull
    private static KotlinFacet createAndAddFacet(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        ModifiableFacetModel facetModel = ideModelsProvider.getModifiableFacetModel(module);
        KotlinFacet oldFacet = (KotlinFacet)facetModel.getFacetByType(KotlinFacetType.Companion.getTYPE_ID());
        if (oldFacet != null) {
            facetModel.removeFacet((Facet)oldFacet);
        }
        FacetType facetType = KotlinFacetType.Companion.getINSTANCE();
        KotlinFacet facet = (KotlinFacet)facetType.createFacet(module, "Kotlin", facetType.createDefaultConfiguration(), null);
        ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings().setUseProjectSettings(false);
        facetModel.addFacet((Facet)facet);
        return facet;
    }

    @NotNull
    private static String getSelectedVariantName(@NotNull GradleModuleModels models) {
        Variant variant = (Variant)models.findModel(Variant.class);
        return variant == null ? "debug" : variant.getName();
    }

    private static void configureFacet(@NotNull KotlinFacet facet, @NotNull KotlinProject kotlinProject, @NotNull IdeModifiableModelsProvider modelsProvider) {
        String compilerVersion = kotlinProject.getKotlinVersion();
        IdePlatform platformKind = KotlinSyncModels.convertToTargetPlatformKind(kotlinProject.getProjectType());
        String coroutines = kotlinProject.getExperimentalFeatures().getCoroutines();
        coroutines = coroutines == null ? CoroutineSupport.INSTANCE.getCompilerArgument(LanguageFeature.Coroutines.getDefaultState()) : coroutines;
        LanguageFeature.State coroutinesProperty = CoroutineSupport.INSTANCE.byCompilerArgument(coroutines);
        FacetUtilsKt.configureFacet((KotlinFacet)facet, (String)compilerVersion, (LanguageFeature.State)coroutinesProperty, (IdePlatform)platformKind, (IdeModifiableModelsProvider)modelsProvider);
    }

    private static void configureCompilerArguments(@NotNull KotlinFacet facet, @NotNull KotlinProject kotlinProject, @Nullable String sourceSetName, @NotNull IdeModifiableModelsProvider modelsProvider) {
        SourceSet sourceSet;
        if (sourceSetName == null) {
            sourceSetName = "main";
        }
        if ((sourceSet = KotlinSyncModels.getSourceSetByName(kotlinProject, sourceSetName)) != null) {
            CompilerArguments compilerArguments = sourceSet.getCompilerArguments();
            List currentCompilerArguments = compilerArguments.getCurrentArguments();
            List defaultCompilerArguments = compilerArguments.getDefaultArguments();
            if (!currentCompilerArguments.isEmpty()) {
                FacetUtilsKt.parseCompilerArgumentsToFacet((List)currentCompilerArguments, (List)defaultCompilerArguments, (KotlinFacet)facet, (IdeModifiableModelsProvider)modelsProvider);
            }
        }
        FacetUtilsKt.noVersionAutoAdvance((KotlinFacet)facet);
    }

    @Nullable
    private static IdePlatform convertToTargetPlatformKind(@NotNull KotlinProject.ProjectType projectType) {
        if (projectType == KotlinProject.ProjectType.PLATFORM_COMMON) {
            return CommonIdePlatformKind.Platform.INSTANCE;
        }
        if (projectType == KotlinProject.ProjectType.PLATFORM_JVM) {
            return JvmIdePlatformKind.INSTANCE.getDefaultPlatform();
        }
        if (projectType == KotlinProject.ProjectType.PLATFORM_JS) {
            return JsIdePlatformKind.Platform.INSTANCE;
        }
        return null;
    }

    @Nullable
    private static SourceSet getSourceSetByName(@NotNull KotlinProject kotlinProject, @NotNull String sourceSetName) {
        for (SourceSet sourceSet : kotlinProject.getSourceSets()) {
            if (!sourceSet.getName().equals(sourceSetName)) continue;
            return sourceSet;
        }
        return null;
    }

    private static void setupKotlinAndroidExtensionAsFacetPluginOptions(@NotNull KotlinFacet facet, @Nullable KotlinAndroidExtension extension) {
        String[] oldPluginOptions;
        KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
        CommonCompilerArguments commonArguments = facetSettings.getCompilerArguments();
        if (commonArguments == null) {
            commonArguments = new CommonCompilerArguments.DummyImpl();
        }
        if ((oldPluginOptions = commonArguments.getPluginOptions()) == null) {
            oldPluginOptions = new String[]{};
        }
        ArrayList<String> newPluginOptions = new ArrayList<String>();
        Arrays.stream(oldPluginOptions).filter(option -> !option.startsWith(ANDROID_PLUGIN_OPTION_PREFIX)).forEach(newPluginOptions::add);
        if (extension != null) {
            newPluginOptions.add(String.format(ANDROID_PLUGIN_OPTION_FORMAT_STRING, AndroidCommandLineProcessor.Companion.getEXPERIMENTAL_OPTION().getOptionName(), String.valueOf(extension.isExperimental())));
            newPluginOptions.add(String.format(ANDROID_PLUGIN_OPTION_FORMAT_STRING, AndroidCommandLineProcessor.Companion.getENABLED_OPTION().getOptionName(), "true"));
            newPluginOptions.add(String.format(ANDROID_PLUGIN_OPTION_FORMAT_STRING, AndroidCommandLineProcessor.Companion.getDEFAULT_CACHE_IMPL_OPTION().getOptionName(), extension.getDefaultCacheImplementation()));
        }
        commonArguments.setPluginOptions(newPluginOptions.toArray(new String[0]));
        facetSettings.setCompilerArguments(commonArguments);
    }

    private static void adjustClasspath(@NotNull KotlinFacet kotlinFacet, @NotNull List<String> dependencyClasspath) {
        if (dependencyClasspath.isEmpty()) {
            return;
        }
        CommonCompilerArguments arguments = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getCompilerArguments();
        if (!(arguments instanceof K2JVMCompilerArguments)) {
            return;
        }
        String classpath = ((K2JVMCompilerArguments)arguments).getClasspath();
        if (classpath == null || classpath.isEmpty()) {
            return;
        }
        Object[] fullClasspath = classpath.split(File.pathSeparator);
        ArrayList newClasspath = Lists.newArrayList((Object[])fullClasspath);
        newClasspath.removeAll(dependencyClasspath);
        ((K2JVMCompilerArguments)arguments).setClasspath(!newClasspath.isEmpty() ? String.join((CharSequence)File.pathSeparator, newClasspath) : null);
    }

    private static void mirrorGradleImportHandlerConfiguration(@NotNull GradleModuleModels models, @NotNull KotlinFacet facet, @NotNull Module module) {
        SamWithReceiver samWithReceiverModel;
        NoArg noArgModel;
        ModuleData fakeModuleData = new ModuleData("fake", GradleConstants.SYSTEM_ID, "fake", "fake", "fake", "fake");
        DataNode fakeDataNode = new DataNode(ProjectKeys.MODULE, (Object)fakeModuleData, null);
        List handlers = GradleProjectImportHandler.Companion.getInstances(module.getProject());
        for (GradleProjectImportHandler handler : handlers) {
            handler.importByModule(facet, fakeDataNode);
        }
        Map<String, List<String>> supportedPresets = Collections.singletonMap("jpa", Arrays.asList("javax.persistence.Entity", "javax.persistence.Embeddable", "javax.persistence.MappedSuperclass"));
        AllOpen allOpenModel = (AllOpen)models.findModel(AllOpen.class);
        if (allOpenModel != null) {
            ArrayList<PluginOption> allOpenPluginOptions = new ArrayList<PluginOption>();
            ArrayList<String> allOpenClasspaths = new ArrayList<String>();
            KotlinSyncModels.configureKotlinPluginOptionsAndClasspaths(allOpenPluginOptions, allOpenClasspaths, allOpenModel.getAnnotations(), allOpenModel.getPresets(), supportedPresets, Collections.emptyList(), PathUtil.getKotlinPathsForIdeaPlugin().getAllOpenPluginJarPath());
            KotlinSyncModels.applyOptionsFromKotlinCompilerPluginModel(facet, "org.jetbrains.kotlin.allopen", "allopen", allOpenPluginOptions, allOpenClasspaths);
        }
        if ((noArgModel = (NoArg)models.findModel(NoArg.class)) != null) {
            ArrayList<PluginOption> noArgPluginOptions = new ArrayList<PluginOption>();
            ArrayList<String> noArgClasspaths = new ArrayList<String>();
            PluginOption additionalOption = new PluginOption("invokeInitializers", String.valueOf(noArgModel.isInvokeInitializers()));
            KotlinSyncModels.configureKotlinPluginOptionsAndClasspaths(noArgPluginOptions, noArgClasspaths, noArgModel.getAnnotations(), noArgModel.getPresets(), supportedPresets, Collections.singletonList(additionalOption), PathUtil.getKotlinPathsForIdeaPlugin().getNoArgPluginJarPath());
            KotlinSyncModels.applyOptionsFromKotlinCompilerPluginModel(facet, "org.jetbrains.kotlin.noarg", "noarg", noArgPluginOptions, noArgClasspaths);
        }
        if ((samWithReceiverModel = (SamWithReceiver)models.findModel(SamWithReceiver.class)) != null) {
            ArrayList<PluginOption> samWithReceiverPluginOptions = new ArrayList<PluginOption>();
            ArrayList<String> samWithReceiverClasspaths = new ArrayList<String>();
            KotlinSyncModels.configureKotlinPluginOptionsAndClasspaths(samWithReceiverPluginOptions, samWithReceiverClasspaths, samWithReceiverModel.getAnnotations(), samWithReceiverModel.getPresets(), supportedPresets, Collections.emptyList(), PathUtil.getKotlinPathsForIdeaPlugin().getSamWithReceiverJarPath());
            KotlinSyncModels.applyOptionsFromKotlinCompilerPluginModel(facet, "org.jetbrains.kotlin.samWithReceiver", "sam-with-receiver", samWithReceiverPluginOptions, samWithReceiverClasspaths);
        }
    }

    private static void configureKotlinPluginOptionsAndClasspaths(@NotNull List<PluginOption> options, @NotNull List<String> classpaths, @NotNull List<String> annotations, @NotNull List<String> presets, @NotNull Map<String, List<String>> supportedPresets, @NotNull List<PluginOption> additionalOptions, @NotNull File pluginJarPath) {
        ArrayList<String> allAnnotations = new ArrayList<String>();
        allAnnotations.addAll(annotations);
        allAnnotations.addAll(presets.stream().flatMap(preset -> ((List)supportedPresets.get(preset)).stream()).collect(Collectors.toList()));
        options.addAll(allAnnotations.stream().map(annotation -> new PluginOption("annotation", (String)annotation)).collect(Collectors.toList()));
        options.addAll(additionalOptions);
        classpaths.add(pluginJarPath.getAbsolutePath());
    }

    private static void applyOptionsFromKotlinCompilerPluginModel(@NotNull KotlinFacet facet, @NotNull String compilerPluginId, @NotNull String pluginName, @NotNull List<PluginOption> options, @NotNull List<String> classpaths) {
        KotlinFacetSettings settings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
        CommonCompilerArguments commonArguments = settings.getCompilerArguments();
        if (commonArguments == null) {
            commonArguments = new CommonCompilerArguments.DummyImpl();
        }
        String compilerPluginOptionPrefix = String.format("plugin:%s:", compilerPluginId);
        List newOptionsForPlugin = options.stream().map(option -> String.format("%s%s=%s", compilerPluginOptionPrefix, option.key, option.value)).collect(Collectors.toList());
        String[] oldPluginOptions = commonArguments.getPluginOptions();
        ArrayList newPluginOptions = new ArrayList();
        if (oldPluginOptions != null) {
            newPluginOptions.addAll(Arrays.stream(oldPluginOptions).filter(option -> !option.startsWith(compilerPluginOptionPrefix)).collect(Collectors.toList()));
        }
        newPluginOptions.addAll(newOptionsForPlugin);
        String[] oldPluginClasspaths = commonArguments.getPluginClasspaths();
        ArrayList<String> newPluginClasspaths = new ArrayList<String>();
        if (oldPluginClasspaths != null) {
            newPluginClasspaths.addAll(Arrays.stream(oldPluginClasspaths).filter(classpath -> {
                int lastIndexOfFile = Math.max(classpath.lastIndexOf(47), classpath.lastIndexOf(File.separatorChar));
                if (lastIndexOfFile < 0) {
                    return true;
                }
                return !classpath.substring(lastIndexOfFile + 1).matches("(kotlin-)?(maven)?" + pluginName + "-.*//.jar");
            }).collect(Collectors.toList()));
        }
        newPluginClasspaths.addAll(classpaths);
        commonArguments.setPluginOptions(newPluginOptions.toArray(new String[0]));
        commonArguments.setPluginClasspaths(newPluginClasspaths.toArray(new String[0]));
        settings.setCompilerArguments(commonArguments);
    }

    private static class PluginOption {
        @NotNull
        public String key;
        @NotNull
        public String value;

        private PluginOption(@NotNull String key, @NotNull String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class IdeKaptSourceSet
    implements KaptSourceSetModel {
        @NotNull
        private String myGeneratedClassesDir;
        @Nullable
        private File myGeneratedClassesDirFile;
        @NotNull
        private String myGeneratedKotlinSourcesDir;
        @Nullable
        private File myGeneratedKotlinSourcesDirFile;
        @NotNull
        private String myGeneratedSourcesDir;
        @Nullable
        private File myGeneratedSourcesDirFile;
        private boolean myIsTest;
        @NotNull
        private String mySourceSetName;

        public IdeKaptSourceSet(@NotNull KaptSourceSetModel model) {
            this.myGeneratedClassesDir = model.getGeneratedClassesDir();
            this.myGeneratedClassesDirFile = model.getGeneratedClassesDirFile();
            this.myGeneratedKotlinSourcesDir = model.getGeneratedKotlinSourcesDir();
            this.myGeneratedKotlinSourcesDirFile = model.getGeneratedKotlinSourcesDirFile();
            this.myGeneratedSourcesDir = model.getGeneratedSourcesDir();
            this.myGeneratedSourcesDirFile = model.getGeneratedSourcesDirFile();
            this.myIsTest = model.isTest();
            this.mySourceSetName = model.getSourceSetName();
        }

        @NotNull
        public String getGeneratedClassesDir() {
            return this.myGeneratedClassesDir;
        }

        @Nullable
        public File getGeneratedClassesDirFile() {
            return this.myGeneratedClassesDirFile;
        }

        @NotNull
        public String getGeneratedKotlinSourcesDir() {
            return this.myGeneratedKotlinSourcesDir;
        }

        @Nullable
        public File getGeneratedKotlinSourcesDirFile() {
            return this.myGeneratedKotlinSourcesDirFile;
        }

        @NotNull
        public String getGeneratedSourcesDir() {
            return this.myGeneratedSourcesDir;
        }

        @Nullable
        public File getGeneratedSourcesDirFile() {
            return this.myGeneratedSourcesDirFile;
        }

        public boolean isTest() {
            return this.myIsTest;
        }

        @NotNull
        public String getSourceSetName() {
            return this.mySourceSetName;
        }
    }

    public static class IdeKaptGradleModel
    implements KaptGradleModel {
        @NotNull
        private File myBuildDirectory;
        private boolean myIsEnabled;
        @NotNull
        List<KaptSourceSetModel> mySourceSets;

        public IdeKaptGradleModel(@NotNull KaptGradleModel kaptGradleModel) {
            this.myBuildDirectory = kaptGradleModel.getBuildDirectory();
            this.myIsEnabled = kaptGradleModel.isEnabled();
            this.mySourceSets = new ArrayList<KaptSourceSetModel>();
            for (KaptSourceSetModel sourceSetModel : kaptGradleModel.getSourceSets()) {
                this.mySourceSets.add(new IdeKaptSourceSet(sourceSetModel));
            }
        }

        @NotNull
        public File getBuildDirectory() {
            return this.myBuildDirectory;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        @NotNull
        public List<KaptSourceSetModel> getSourceSets() {
            return this.mySourceSets;
        }
    }

    public static class KotlinJavaSyncModels
    extends ExtraGradleSyncJavaModels {
        @NotNull
        public Set<Class<?>> getModelTypes() {
            return Sets.newHashSet((Object[])new Class[]{KotlinProject.class, AllOpen.class, NoArg.class, SamWithReceiver.class, KaptGradleModel.class});
        }

        public void applyModelsToModule(@NotNull GradleModuleModels moduleModels, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
            KotlinSyncModels.configureKotlin(moduleModels, module, modelsProvider, false);
        }

        public void addModelsToCache(@NotNull Module module, @NotNull CachedModuleModels cache) {
            KaptGradleModel kaptGradleModel;
            GradleModuleModels moduleModels = (GradleModuleModels)module.getUserData(AndroidModuleProcessor.MODULE_GRADLE_MODELS_KEY);
            if (moduleModels != null && (kaptGradleModel = (KaptGradleModel)moduleModels.findModel(KaptGradleModel.class)) != null) {
                cache.addModel((Serializable)((Object)new IdeKaptGradleModel(kaptGradleModel)));
            }
        }
    }

    public static class KotlinAndroidSyncModels
    extends ExtraGradleSyncAndroidModels {
        @NotNull
        public Set<Class<?>> getModelTypes() {
            return Sets.newHashSet((Object[])new Class[]{KotlinAndroidExtension.class, KotlinProject.class, AllOpen.class, NoArg.class, SamWithReceiver.class, KaptGradleModel.class});
        }

        public void applyModelsToModule(@NotNull GradleModuleModels moduleModels, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
            KotlinSyncModels.configureKotlin(moduleModels, module, modelsProvider, true);
        }

        public void addModelsToCache(@NotNull Module module, @NotNull CachedModuleModels cache) {
        }
    }
}

