/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsConverter;
import org.jetbrains.plugins.gradle.service.task.ExecuteGradleTaskHistoryService;
import org.jetbrains.plugins.gradle.service.task.GradleRunTaskDialog;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleExecuteTaskAction
extends ExternalSystemAction {
    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (!super.isVisible(e)) {
            return false;
        }
        ExternalProjectsView projectsView = (ExternalProjectsView)ExternalSystemDataKeys.VIEW.getData(e.getDataContext());
        return projectsView == null || GradleConstants.SYSTEM_ID.equals((Object)this.getSystemId(e));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation p = e.getPresentation();
        p.setVisible(this.isVisible(e));
        p.setEnabled(this.isEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GradleActionsUsagesCollector.trigger(project, (AnAction)this, e);
        ExecuteGradleTaskHistoryService historyService = ExecuteGradleTaskHistoryService.getInstance(project);
        GradleRunTaskDialog dialog = new GradleRunTaskDialog(project, historyService.getHistory());
        String lastWorkingDirectory = historyService.getWorkDirectory();
        if (lastWorkingDirectory.length() == 0) {
            lastWorkingDirectory = GradleExecuteTaskAction.obtainAppropriateWorkingDirectory(e);
        }
        dialog.setWorkDirectory(lastWorkingDirectory);
        if (StringUtil.isEmptyOrSpaces((String)historyService.getCanceledCommand())) {
            if (historyService.getHistory().size() > 0) {
                dialog.setCommandLine(historyService.getHistory().get(0));
            }
        } else {
            dialog.setCommandLine(historyService.getCanceledCommand());
        }
        if (!dialog.showAndGet()) {
            historyService.setCanceledCommand(dialog.getCommandLine());
            return;
        }
        historyService.setCanceledCommand(null);
        String fullCommandLine = dialog.getCommandLine();
        fullCommandLine = fullCommandLine.trim();
        String workDirectory = dialog.getWorkDirectory();
        historyService.addCommand(fullCommandLine, workDirectory);
        GradleExecuteTaskAction.runGradle(project, null, workDirectory, fullCommandLine);
    }

    public static void runGradle(@NotNull Project project, @Nullable Executor executor, @NotNull String workDirectory, @NotNull String fullCommandLine) {
        ExternalTaskExecutionInfo taskExecutionInfo;
        try {
            taskExecutionInfo = GradleExecuteTaskAction.buildTaskInfo(workDirectory, fullCommandLine, executor);
        }
        catch (CommandLineArgumentException ex) {
            NotificationData notificationData = new NotificationData("<b>Command-line arguments cannot be parsed</b>", "<i>" + fullCommandLine + "</i> \n" + ex.getMessage(), NotificationCategory.WARNING, NotificationSource.TASK_EXECUTION);
            notificationData.setBalloonNotification(true);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(GradleConstants.SYSTEM_ID, notificationData);
            return;
        }
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (String)taskExecutionInfo.getExecutorId(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        RunnerAndConfigurationSettings configuration = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings((ExternalSystemTaskExecutionSettings)taskExecutionInfo.getSettings(), (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (configuration == null) {
            return;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings existingConfiguration = runManager.findConfigurationByTypeAndName(configuration.getType(), configuration.getName());
        if (existingConfiguration == null) {
            runManager.setTemporaryConfiguration(configuration);
        } else {
            runManager.setSelectedConfiguration(existingConfiguration);
        }
    }

    private static ExternalTaskExecutionInfo buildTaskInfo(@NotNull String projectPath, @NotNull String fullCommandLine, @Nullable Executor executor) throws CommandLineArgumentException {
        CommandLineParser gradleCmdParser = new CommandLineParser();
        GradleCommandLineOptionsConverter commandLineConverter = new GradleCommandLineOptionsConverter();
        commandLineConverter.configure(gradleCmdParser);
        ParsedCommandLine parsedCommandLine = gradleCmdParser.parse((Iterable)ParametersListUtil.parse((String)fullCommandLine, (boolean)true));
        Map<String, List<String>> optionsMap = commandLineConverter.convert(parsedCommandLine, new HashMap<String, List<String>>());
        List<String> systemProperties = optionsMap.remove("system-prop");
        String vmOptions = systemProperties == null ? "" : StringUtil.join(systemProperties, entry -> "-D" + entry, (String)" ");
        String scriptParameters = StringUtil.join(optionsMap.entrySet(), entry -> {
            List values = (List)entry.getValue();
            String longOptionName = (String)entry.getKey();
            if (values != null && !values.isEmpty()) {
                return StringUtil.join((Collection)values, entry1 -> "--" + longOptionName + ' ' + entry1, (String)" ");
            }
            return "--" + longOptionName;
        }, (String)" ");
        List tasks = parsedCommandLine.getExtraArguments();
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(projectPath);
        settings.setTaskNames(tasks);
        settings.setScriptParameters(scriptParameters);
        settings.setVmOptions(vmOptions);
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.toString());
        return new ExternalTaskExecutionInfo(settings, executor == null ? DefaultRunExecutor.EXECUTOR_ID : executor.getId());
    }

    private static String obtainAppropriateWorkingDirectory(AnActionEvent e) {
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            Module module = ExternalSystemActionUtil.getModule((DataContext)e.getDataContext());
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
            return projectPath == null ? "" : projectPath;
        }
        ExternalSystemNode node = (ExternalSystemNode)selectedNodes.get(0);
        Object externalData = node.getData();
        if (externalData instanceof ExternalConfigPathAware) {
            return ((ExternalConfigPathAware)externalData).getLinkedExternalProjectPath();
        }
        ExternalConfigPathAware parentExternalConfigPathAware = (ExternalConfigPathAware)node.findParentData(ExternalConfigPathAware.class);
        return parentExternalConfigPathAware != null ? parentExternalConfigPathAware.getLinkedExternalProjectPath() : "";
    }
}

