/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.ui.GradleProjectCompositeSelectorDialog;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleOpenProjectCompositeConfigurationAction
extends ExternalSystemAction {
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        if (this.getSystemId(e) == null) {
            return false;
        }
        return ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext()) != null;
    }

    protected boolean isVisible(@NotNull AnActionEvent e) {
        Project project = this.getProject(e);
        if (project == null) {
            return false;
        }
        ProjectSystemId systemId = this.getSystemId(e);
        if (!GradleConstants.SYSTEM_ID.equals((Object)systemId)) {
            return false;
        }
        if (GradleSettings.getInstance(project).getLinkedProjectsSettings().size() > 1) {
            ProjectNode projectNode = (ProjectNode)ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext());
            if (projectNode == null || projectNode.getData() == null) {
                return false;
            }
            GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(project).getLinkedProjectSettings(((ProjectData)projectNode.getData()).getLinkedExternalProjectPath());
            GradleProjectSettings.CompositeBuild compositeBuild = null;
            if (projectSettings != null) {
                compositeBuild = projectSettings.getCompositeBuild();
            }
            if (compositeBuild == null || compositeBuild.getCompositeDefinitionSource() == CompositeDefinitionSource.IDE) {
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = this.getProject(e);
        if (project == null) {
            return;
        }
        GradleActionsUsagesCollector.trigger(project, (AnAction)this, e);
        ProjectNode projectNode = (ProjectNode)ExternalSystemDataKeys.SELECTED_PROJECT_NODE.getData(e.getDataContext());
        if (projectNode == null || projectNode.getData() == null) {
            return;
        }
        new GradleProjectCompositeSelectorDialog(project, ((ProjectData)projectNode.getData()).getLinkedExternalProjectPath()).showAndGet();
    }
}

