/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ToggleOfflineAction
extends ExternalSystemToggleAction {
    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (!super.isVisible(e)) {
            return false;
        }
        return GradleConstants.SYSTEM_ID.equals((Object)this.getSystemId(e));
    }

    protected boolean doIsSelected(@NotNull AnActionEvent e) {
        return GradleSettings.getInstance(this.getProject(e)).isOfflineWork();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project = this.getProject(e);
        GradleActionsUsagesCollector.trigger(project, (AnAction)this, e);
        GradleSettings.getInstance(project).setOfflineWork(state);
    }
}

