/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Executor;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import groovyjarjarcommonscli.Option;
import icons.GradleIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.action.GradleExecuteTaskAction;
import org.jetbrains.plugins.gradle.execution.RunAnythingGradleItem;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunAnythingProvider
extends RunAnythingProviderBase<String> {
    @NotNull
    public RunAnythingItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        return new RunAnythingGradleItem(this.getCommand(value), this.getIcon(value));
    }

    @Nullable
    public String findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        return pattern.startsWith(this.getHelpCommand()) ? this.getCommand(pattern) : null;
    }

    @NotNull
    public Collection<String> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (!pattern.startsWith(this.getHelpCommand())) {
            return Collections.emptyList();
        }
        List result = ContainerUtil.newSmartList();
        String prefix = StringUtil.notNullize((String)StringUtil.substringBeforeLast((String)pattern, (String)" "), (String)this.getHelpCommand()).trim() + ' ';
        String toComplete = StringUtil.notNullize((String)StringUtil.substringAfterLast((String)pattern, (String)" "));
        this.appendProjectsVariants(result, dataContext, prefix);
        if (!result.isEmpty()) {
            return result;
        }
        GradleRunAnythingProvider.appendArgumentsVariants(result, prefix, toComplete);
        if (!result.isEmpty()) {
            return result;
        }
        this.appendTasksVariants(result, prefix, dataContext);
        return result;
    }

    private void appendProjectsVariants(@NotNull List<String> result, @NotNull DataContext dataContext, @NotNull String prefix) {
        if (!prefix.trim().equals(this.getHelpCommand())) {
            return;
        }
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        Collection<GradleProjectSettings> projectsSettings = GradleSettings.getInstance(project).getLinkedProjectsSettings();
        if (projectsSettings.size() <= 1) {
            return;
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        projectsSettings.stream().map(setting -> dataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath())).filter(projectInfo -> projectInfo != null && projectInfo.getExternalProjectStructure() != null).map(projectInfo -> (ProjectData)projectInfo.getExternalProjectStructure().getData()).forEach(data -> result.add(prefix + data.getExternalName()));
    }

    private void appendTasksVariants(@NotNull List<String> result, @NotNull String prefix, @NotNull DataContext dataContext) {
        String commandLine;
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        ProjectData projectData = GradleRunAnythingProvider.getProjectData(project, commandLine = StringUtil.trimStart((String)prefix, (String)this.getHelpCommand()).trim());
        if (projectData == null) {
            return;
        }
        MultiMap<String, String> tasks = GradleRunAnythingProvider.fetchTasks(dataContext).get(projectData);
        if (tasks == null) {
            return;
        }
        for (Map.Entry entry : tasks.entrySet()) {
            for (String taskName : (Collection)entry.getValue()) {
                String taskFqn = (String)entry.getKey() + taskName;
                result.add(prefix + taskFqn);
            }
        }
    }

    private static void appendArgumentsVariants(@NotNull List<String> result, @NotNull String prefix, @NotNull String toComplete) {
        if (!toComplete.startsWith("-")) {
            return;
        }
        boolean isLongOpt = toComplete.startsWith("--");
        prefix = prefix + (isLongOpt ? "--" : "-");
        for (Object option : GradleCommandLineOptionsProvider.getSupportedOptions().getOptions()) {
            String opt;
            if (!(option instanceof Option) || !StringUtil.isNotEmpty((String)(opt = isLongOpt ? ((Option)option).getLongOpt() : ((Option)option).getOpt()))) continue;
            result.add(prefix + opt);
        }
    }

    public void execute(@NotNull DataContext dataContext, @NotNull String value) {
        String commandLine;
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        ProjectData projectData = GradleRunAnythingProvider.getProjectData(project, commandLine = StringUtil.trimStart((String)value, (String)this.getHelpCommand()).trim());
        if (projectData == null) {
            return;
        }
        commandLine = StringUtil.trimStart((String)commandLine, (String)projectData.getExternalName());
        Executor executor = (Executor)RunAnythingAction.EXECUTOR_KEY.getData(dataContext);
        GradleExecuteTaskAction.runGradle(project, executor, projectData.getLinkedExternalProjectPath(), commandLine);
    }

    @Nullable
    private static ProjectData getProjectData(@NotNull Project project, @NotNull String commandLine) {
        Collection<GradleProjectSettings> projectsSettings = GradleSettings.getInstance(project).getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return null;
        }
        ProjectDataManager dataManager = ProjectDataManager.getInstance();
        return projectsSettings.stream().map(setting -> dataManager.getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath())).filter(projectInfo -> projectInfo != null && projectInfo.getExternalProjectStructure() != null).map(projectInfo -> (ProjectData)projectInfo.getExternalProjectStructure().getData()).filter(projectData -> projectsSettings.size() == 1 || StringUtil.startsWith((CharSequence)commandLine, (CharSequence)projectData.getExternalName())).findFirst().orElse(null);
    }

    @NotNull
    public String getCommand(@NotNull String value) {
        return value;
    }

    @Nullable
    public Icon getIcon(@NotNull String value) {
        return GradleIcons.Gradle;
    }

    @Nullable
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        String placeholder = this.getHelpCommandPlaceholder(dataContext);
        String commandPrefix = this.getHelpCommand();
        return new RunAnythingHelpItem(placeholder, commandPrefix, this.getHelpDescription(), this.getHelpIcon());
    }

    @NotNull
    public String getCompletionGroupTitle() {
        return "Gradle tasks";
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        return this.getHelpCommandPlaceholder(null);
    }

    @NotNull
    public String getHelpCommandPlaceholder(@Nullable DataContext dataContext) {
        Project project;
        if (dataContext != null && GradleSettings.getInstance(project = RunAnythingUtil.fetchProject((DataContext)dataContext)).getLinkedProjectsSettings().size() > 1) {
            return "gradle <rootProjectName> <taskName...> <--option-name...>";
        }
        return "gradle <taskName...> <--option-name...>";
    }

    @NotNull
    public String getHelpCommand() {
        return "gradle";
    }

    public Icon getHelpIcon() {
        return GradleIcons.Gradle;
    }

    private static Map<ProjectData, MultiMap<String, String>> fetchTasks(@NotNull DataContext dataContext) {
        Project project = RunAnythingUtil.fetchProject((DataContext)dataContext);
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(GradleRunAnythingProvider.getTasksMap(project), (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)}));
    }

    @NotNull
    private static Map<ProjectData, MultiMap<String, String>> getTasksMap(Project project) {
        LinkedHashMap tasks = ContainerUtil.newLinkedHashMap();
        for (GradleProjectSettings setting : GradleSettings.getInstance(project).getLinkedProjectsSettings()) {
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, setting.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) continue;
            MultiMap projectTasks = MultiMap.createOrderedSet();
            for (DataNode moduleDataNode : ExternalSystemApiUtil.getChildren((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE)) {
                int colonIndex;
                String moduleId = ((ModuleData)moduleDataNode.getData()).getId();
                String gradlePath = moduleId.charAt(0) != ':' ? ((colonIndex = moduleId.indexOf(58)) > 0 ? moduleId.substring(colonIndex) : ":") : moduleId;
                for (DataNode node : ExternalSystemApiUtil.getChildren((DataNode)moduleDataNode, (Key)ProjectKeys.TASK)) {
                    TaskData taskData = (TaskData)node.getData();
                    String taskName = taskData.getName();
                    if (!StringUtil.isNotEmpty((String)taskName)) continue;
                    String taskPathPrefix = ":".equals(gradlePath) || taskName.startsWith(gradlePath) ? "" : gradlePath + ':';
                    projectTasks.putValue((Object)taskPathPrefix, (Object)taskName);
                }
            }
            tasks.put(projectData.getExternalProjectStructure().getData(), projectTasks);
        }
        return tasks;
    }
}

