/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonState;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonsUi;
import org.jetbrains.plugins.gradle.internal.daemon.GradleDaemonServices;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;

public class ShowGradleDaemonsAction
extends DumbAwareAction {
    private DaemonsUi myUi;

    public ShowGradleDaemonsAction() {
        super("Show Gradle Daemons");
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(this.myUi == null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        GradleActionsUsagesCollector.trigger(project, "showGradleDaemonsAction");
        this.myUi = new DaemonsUi(project){

            @Override
            public void dispose() {
                ShowGradleDaemonsAction.this.myUi = null;
            }
        };
        List<DaemonState> daemonsStatus = GradleDaemonServices.getDaemonsStatus();
        this.myUi.show(daemonsStatus);
    }
}

