/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.Jar;
import org.jetbrains.plugins.gradle.model.data.WebResource;

public class War
extends Jar {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myWebAppDirName;
    @NotNull
    private final File myWebAppDir;
    @Nullable
    private File myWebXml;
    @NotNull
    private List<WebResource> myWebResources;
    @NotNull
    private Set<File> myClasspath;

    public War(@NotNull String name, @NotNull String webAppDirName, @NotNull File webAppDir) {
        super(name);
        this.myWebAppDirName = webAppDirName;
        this.myWebAppDir = webAppDir;
        this.myWebResources = Collections.emptyList();
        this.myClasspath = Collections.emptySet();
    }

    @NotNull
    public String getWebAppDirName() {
        return this.myWebAppDirName;
    }

    @NotNull
    public File getWebAppDir() {
        return this.myWebAppDir;
    }

    public void setWebXml(@Nullable File webXml) {
        this.myWebXml = webXml;
    }

    @Nullable
    public File getWebXml() {
        return this.myWebXml;
    }

    public void setWebResources(@Nullable List<WebResource> webResources) {
        this.myWebResources = webResources == null ? Collections.emptyList() : webResources;
    }

    @NotNull
    public List<WebResource> getWebResources() {
        return this.myWebResources;
    }

    public void setClasspath(@Nullable Set<File> classpath) {
        this.myClasspath = classpath == null ? Collections.emptySet() : classpath;
    }

    @NotNull
    public Set<File> getClasspath() {
        return this.myClasspath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof War)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        War war = (War)o;
        if (!this.myWebAppDirName.equals(war.myWebAppDirName)) {
            return false;
        }
        if (!this.myWebResources.equals(war.myWebResources)) {
            return false;
        }
        return this.myClasspath.equals(war.myClasspath);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myWebAppDirName.hashCode();
        result = 31 * result + this.myWebResources.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "War{name='" + this.getName() + '\'' + ", webAppDirName='" + this.myWebAppDirName + '\'' + ", webAppDir=" + this.myWebAppDir + ", webXml=" + this.myWebXml + ", webResources=" + this.myWebResources + '}';
    }
}

