/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEventImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptorImpl;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResultImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;

public class GradleProgressListener
implements org.gradle.tooling.ProgressListener,
ProgressListener {
    private final ExternalSystemTaskNotificationListener myListener;
    private final ExternalSystemTaskId myTaskId;
    private final Map<String, Long> myStatusEventIds = new HashMap<String, Long>();
    private final String myBuildRootDir;
    private final int myOperationId;

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener, @NotNull ExternalSystemTaskId taskId) {
        this(listener, taskId, null);
    }

    public GradleProgressListener(@NotNull ExternalSystemTaskNotificationListener listener, @NotNull ExternalSystemTaskId taskId, @Nullable String buildRootDir) {
        this.myListener = listener;
        this.myTaskId = taskId;
        this.myBuildRootDir = buildRootDir;
        this.myOperationId = taskId.hashCode() + FileUtil.pathHashCode((String)(buildRootDir == null ? UUID.randomUUID().toString() : buildRootDir));
    }

    public void statusChanged(org.gradle.tooling.ProgressEvent event) {
        String eventDescription = event.getDescription();
        this.myListener.onStatusChange(new ExternalSystemTaskNotificationEvent(this.myTaskId, eventDescription));
        if (StringUtil.equals((CharSequence)"Starting Gradle Daemon", (CharSequence)eventDescription)) {
            this.reportGradleDaemonStartingEvent(eventDescription);
        }
    }

    public void statusChanged(ProgressEvent event) {
        OperationDescriptor operationDescriptor;
        ExternalSystemProgressEvent progressEvent;
        ExternalSystemTaskNotificationEvent notificationEvent;
        if (!GradleEnvironment.GRADLE_PROGRESS_VERBOSE_EVENTS) {
            String displayName = event.getDisplayName();
            if (displayName.startsWith("Resolve ")) {
                return;
            }
            if (displayName.startsWith("Apply plugin ")) {
                return;
            }
            if (displayName.startsWith("Apply script ")) {
                return;
            }
            if (displayName.startsWith("Notify ") && displayName.contains(" listeners")) {
                return;
            }
            if (displayName.startsWith("Realize task ")) {
                return;
            }
            if (displayName.startsWith("Metadata of ")) {
                return;
            }
            if (displayName.equals("Snapshot task inputs")) {
                return;
            }
            if (displayName.startsWith("Build model ")) {
                return;
            }
        }
        if ((notificationEvent = GradleProgressEventConverter.convert(this.myTaskId, event, this.myOperationId + "_")) instanceof ExternalSystemTaskExecutionEvent && (progressEvent = ((ExternalSystemTaskExecutionEvent)notificationEvent).getProgressEvent()).getParentEventId() == null && "Run build".equals(event.getDescriptor().getName()) && (operationDescriptor = progressEvent.getDescriptor()) instanceof OperationDescriptorImpl) {
            ((OperationDescriptorImpl)operationDescriptor).setHint(this.myBuildRootDir);
        }
        this.myListener.onStatusChange(notificationEvent);
        if (notificationEvent instanceof ExternalSystemTaskExecutionEvent) {
            ExternalSystemFinishEvent finishEvent;
            progressEvent = ((ExternalSystemTaskExecutionEvent)notificationEvent).getProgressEvent();
            if (progressEvent instanceof ExternalSystemStatusEvent) {
                ExternalSystemStatusEvent statusEvent = (ExternalSystemStatusEvent)progressEvent;
                if ("bytes".equals(statusEvent.getUnit())) {
                    Long oldProgress = this.myStatusEventIds.get(statusEvent.getEventId());
                    if (oldProgress == null) {
                        String totalSizeInfo = statusEvent.getTotal() > 0L ? " (" + StringUtil.formatFileSize((long)statusEvent.getTotal()) + ")" : "";
                        this.myListener.onTaskOutput(this.myTaskId, statusEvent.getDisplayName() + totalSizeInfo + "\n", true);
                        this.myStatusEventIds.put(statusEvent.getEventId(), 0L);
                    } else {
                        double fraction = (double)statusEvent.getProgress() / (double)statusEvent.getTotal();
                        int progressBarSize = 14;
                        int progress = (int)(fraction * (double)progressBarSize + 0.5);
                        if (oldProgress != (long)progress) {
                            this.myStatusEventIds.put(statusEvent.getEventId(), Long.valueOf(progress));
                            if (statusEvent.getTotal() > 0L) {
                                int remaining = progressBarSize - progress;
                                remaining = remaining < 0 ? 0 : remaining;
                                int offset = 3 - ((int)Math.log10(fraction * 100.0) + 1);
                                offset = offset < 0 ? 0 : offset;
                                this.myListener.onTaskOutput(this.myTaskId, "\r[" + StringUtil.repeat((String)" ", (int)offset) + (int)(fraction * 100.0) + "%" + ']' + " [ " + StringUtil.repeat((String)"=", (int)(progress * 4 - 3)) + ">" + StringUtil.repeat((String)" ", (int)(remaining * 4)) + " ] " + StringUtil.formatFileSize((long)statusEvent.getProgress()), true);
                            } else {
                                this.myListener.onTaskOutput(this.myTaskId, StringUtil.formatFileSize((long)statusEvent.getProgress()) + "\n", true);
                            }
                        }
                    }
                }
            } else if (progressEvent instanceof ExternalSystemFinishEvent && this.myStatusEventIds.containsKey((finishEvent = (ExternalSystemFinishEvent)progressEvent).getEventId())) {
                OperationResult operationResult = finishEvent.getOperationResult();
                String duration = StringUtil.formatDuration((long)(operationResult.getEndTime() - operationResult.getStartTime()));
                this.myListener.onTaskOutput(this.myTaskId, "\n" + finishEvent.getDisplayName() + " succeeded, took " + duration + "\n", true);
                this.myListener.onTaskOutput(this.myTaskId, "Unzipping ...\n\n", true);
                this.myStatusEventIds.remove(finishEvent.getEventId());
            }
        }
    }

    private void reportGradleDaemonStartingEvent(String eventDescription) {
        ExternalSystemTaskExecutionEvent startDaemonEvent;
        Long startTime = this.myStatusEventIds.get(eventDescription);
        if (startTime == null) {
            startTime = System.currentTimeMillis();
            startDaemonEvent = new ExternalSystemTaskExecutionEvent(this.myTaskId, (ExternalSystemProgressEvent)new ExternalSystemStartEventImpl(eventDescription, null, (OperationDescriptor)new OperationDescriptorImpl(eventDescription, startTime.longValue())));
            this.myStatusEventIds.put(eventDescription, startTime);
        } else {
            long eventTime = System.currentTimeMillis();
            startDaemonEvent = new ExternalSystemTaskExecutionEvent(this.myTaskId, (ExternalSystemProgressEvent)new ExternalSystemFinishEventImpl(eventDescription, null, (OperationDescriptor)new OperationDescriptorImpl(eventDescription, eventTime), (OperationResult)new SuccessResultImpl(startTime.longValue(), eventTime, false)));
        }
        this.myListener.onStatusChange((ExternalSystemTaskNotificationEvent)startDaemonEvent);
    }
}

