/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleDebugSettingsEditor;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunConfiguration
extends ExternalSystemRunConfiguration {
    public static final String DEBUG_FLAG_NAME = "GradleScriptDebugEnabled";
    public static final Key<Boolean> DEBUG_FLAG_KEY = Key.create((String)"DEBUG_GRADLE_SCRIPT");
    private boolean isScriptDebugEnabled = true;

    public GradleRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(GradleConstants.SYSTEM_ID, project, factory, name);
    }

    public boolean isScriptDebugEnabled() {
        return this.isScriptDebugEnabled;
    }

    public void setScriptDebugEnabled(boolean scriptDebugEnabled) {
        this.isScriptDebugEnabled = scriptDebugEnabled;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        this.putUserData(DEBUG_FLAG_KEY, this.isScriptDebugEnabled);
        return super.getState(executor, env);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        super.readExternal(element);
        Element child = element.getChild(DEBUG_FLAG_NAME);
        if (child != null) {
            this.isScriptDebugEnabled = Boolean.valueOf(child.getText());
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        super.writeExternal(element);
        Element child = new Element(DEBUG_FLAG_NAME);
        child.setText(String.valueOf(this.isScriptDebugEnabled));
        element.addContent(child);
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditor editor = super.getConfigurationEditor();
        if (editor instanceof SettingsEditorGroup) {
            SettingsEditorGroup group = (SettingsEditorGroup)editor;
            group.addEditor(GradleBundle.message("gradle.settings.title.debug", new Object[0]), (SettingsEditor)new GradleDebugSettingsEditor());
        }
        return editor;
    }
}

