/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.callback.OpenExternalSystemSettingsCallback;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.notification.GotoSourceNotificationCallback;
import org.jetbrains.plugins.gradle.service.notification.OpenGradleSettingsCallback;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleNotificationExtension
implements ExternalSystemNotificationExtension {
    @NotNull
    public ProjectSystemId getTargetExternalSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    public void customize(@NotNull NotificationData notification, @NotNull Project project, @Nullable Throwable error) {
        if (error == null) {
            return;
        }
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof ExternalSystemException) {
            this.updateNotification(notification, project, (ExternalSystemException)unwrapped);
        }
    }

    protected void updateNotification(@NotNull NotificationData notificationData, @NotNull Project project, @NotNull ExternalSystemException e) {
        for (String fix : e.getQuickFixes()) {
            if ("open_gradle_settings".equals(fix)) {
                notificationData.setListener("open_gradle_settings", (NotificationListener)new OpenGradleSettingsCallback(project));
                continue;
            }
            if ("goto_source".equals(fix)) {
                notificationData.setListener("goto_source", (NotificationListener)new GotoSourceNotificationCallback(notificationData, project));
                continue;
            }
            if (!"#open_external_system_settings".equals(fix)) continue;
            String linkedProjectPath = e instanceof LocationAwareExternalSystemException ? ((LocationAwareExternalSystemException)e).getFilePath() : null;
            notificationData.setListener("#open_external_system_settings", (NotificationListener)new OpenExternalSystemSettingsCallback(project, GradleConstants.SYSTEM_ID, linkedProjectPath));
        }
    }
}

