/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.google.gson.GsonBuilder;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.model.project.TestData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerConfiguration;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMapImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaJavaLanguageSettings;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClassSetProjectImportExtraModelProvider;
import org.jetbrains.plugins.gradle.model.DefaultGradleExtensions;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.IntelliJProjectSettings;
import org.jetbrains.plugins.gradle.model.IntelliJSettings;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.ProjectImportExtraModelProvider;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestsModel;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataService;
import org.jetbrains.plugins.gradle.service.project.data.GradleExtensionsDataService;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.tooling.builder.ModelBuildScriptClasspathBuilderImpl;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=0x7FFFFFFF)
public class BaseGradleProjectResolverExtension
implements GradleProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(BaseGradleProjectResolverExtension.class);
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private ProjectResolverContext resolverCtx;
    @NotNull
    private final BaseProjectImportErrorHandler myErrorHandler = new BaseProjectImportErrorHandler();

    @Override
    public void setProjectResolverContext(@NotNull ProjectResolverContext projectResolverContext) {
        this.resolverCtx = projectResolverContext;
    }

    @Override
    public void setNext(@NotNull GradleProjectResolverExtension next) {
    }

    @Override
    @Nullable
    public GradleProjectResolverExtension getNext() {
        return null;
    }

    @Override
    @NotNull
    public ProjectData createProject() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(ExternalProject.class);
        String projectName = externalProject != null ? externalProject.getName() : this.resolverCtx.getModels().getIdeaProject().getName();
        return new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectDirPath, projectDirPath);
    }

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        IntelliJSettings intellijSettings;
        ExternalProject externalProject = this.resolverCtx.getExtraProject(ExternalProject.class);
        if (externalProject != null) {
            ideProject.createChild(ExternalProjectDataService.KEY, (Object)externalProject);
            ((ProjectData)ideProject.getData()).setDescription(externalProject.getDescription());
        }
        if ((intellijSettings = (IntelliJSettings)this.resolverCtx.getExtraProject(IntelliJProjectSettings.class)) != null) {
            ideProject.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
    }

    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        DataNode<ModuleData> mainModuleNode = GradleProjectResolverUtil.createMainModule(this.resolverCtx, gradleModule, projectDataNode);
        ModuleData mainModuleData = (ModuleData)mainModuleNode.getData();
        String mainModuleConfigPath = mainModuleData.getLinkedExternalProjectPath();
        String mainModuleFileDirectoryPath = mainModuleData.getModuleFileDirectoryPath();
        String jdkName = BaseGradleProjectResolverExtension.getJdkName(gradleModule);
        String[] moduleGroup = null;
        if (!this.resolverCtx.isUseQualifiedModuleNames()) {
            moduleGroup = this.getIdeModuleGroup(mainModuleData.getInternalName(), gradleModule);
            mainModuleData.setIdeModuleGroup(moduleGroup);
        }
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (this.resolverCtx.isResolveModulePerSourceSet() && externalProject != null) {
            for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
                String moduleId = GradleProjectResolverUtil.getModuleId(this.resolverCtx, gradleModule, sourceSet);
                String moduleExternalName = gradleModule.getName() + ":" + sourceSet.getName();
                String moduleInternalName = GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, sourceSet.getName(), this.resolverCtx);
                GradleSourceSetData sourceSetData = new GradleSourceSetData(moduleId, moduleExternalName, moduleInternalName, mainModuleFileDirectoryPath, mainModuleConfigPath);
                sourceSetData.setGroup(externalProject.getGroup());
                if ("main".equals(sourceSet.getName())) {
                    sourceSetData.setPublication((ProjectCoordinate)new ProjectId(externalProject.getGroup(), externalProject.getName(), externalProject.getVersion()));
                }
                sourceSetData.setVersion(externalProject.getVersion());
                sourceSetData.setIdeModuleGroup(moduleGroup);
                sourceSetData.setSourceCompatibility(sourceSet.getSourceCompatibility());
                sourceSetData.setTargetCompatibility(sourceSet.getTargetCompatibility());
                sourceSetData.setSdkName(jdkName);
                THashSet artifacts = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY);
                if ("main".equals(sourceSet.getName())) {
                    Set defaultArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("default");
                    if (defaultArtifacts != null) {
                        artifacts.addAll(defaultArtifacts);
                    }
                } else if ("test".equals(sourceSet.getName())) {
                    sourceSetData.setProductionModuleId(GradleProjectResolverUtil.getInternalModuleName(gradleModule, externalProject, "main", this.resolverCtx));
                    Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                    if (testsArtifacts != null) {
                        artifacts.addAll(testsArtifacts);
                    }
                }
                artifacts.addAll(sourceSet.getArtifacts());
                for (ExternalSourceDirectorySet directorySet : sourceSet.getSources().values()) {
                    artifacts.addAll(directorySet.getGradleOutputDirs());
                }
                sourceSetData.setArtifacts(ContainerUtil.newArrayList((Iterable)artifacts));
                DataNode sourceSetDataNode = mainModuleNode.createChild(GradleSourceSetData.KEY, (Object)sourceSetData);
                Map sourceSetMap = (Map)projectDataNode.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
                assert (sourceSetMap != null);
                sourceSetMap.put(moduleId, Pair.create((Object)sourceSetDataNode, (Object)sourceSet));
            }
        } else {
            try {
                IdeaJavaLanguageSettings languageSettings = gradleModule.getJavaLanguageSettings();
                if (languageSettings != null) {
                    if (languageSettings.getLanguageLevel() != null) {
                        mainModuleData.setSourceCompatibility(languageSettings.getLanguageLevel().toString());
                    }
                    if (languageSettings.getTargetBytecodeVersion() != null) {
                        mainModuleData.setTargetCompatibility(languageSettings.getTargetBytecodeVersion().toString());
                    }
                }
                mainModuleData.setSdkName(jdkName);
            }
            catch (UnsupportedMethodException languageSettings) {
                // empty catch block
            }
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        if (StringUtil.equals((CharSequence)mainModuleData.getLinkedExternalProjectPath(), (CharSequence)projectData.getLinkedExternalProjectPath())) {
            projectData.setGroup(mainModuleData.getGroup());
            projectData.setVersion(mainModuleData.getVersion());
        }
        return mainModuleNode;
    }

    @NotNull
    protected String[] getIdeModuleGroup(String moduleName, IdeaModule gradleModule) {
        String[] stringArray;
        boolean isRootModule;
        String gradlePath = gradleModule.getGradleProject().getPath();
        String rootName = gradleModule.getProject().getName();
        boolean bl = isRootModule = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath);
        if (isRootModule) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = moduleName;
        } else {
            stringArray = (rootName + gradlePath).split(":");
        }
        String[] moduleGroup = stringArray;
        return moduleGroup;
    }

    @Nullable
    private static String getJdkName(@NotNull IdeaModule gradleModule) {
        try {
            return gradleModule.getJdkName();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ProjectImportAction.AllModels models;
        ExternalTestsModel externalTestsModel;
        IntelliJSettings intellijSettings;
        GradleExtensions gradleExtensions = this.resolverCtx.getExtraProject(gradleModule, GradleExtensions.class);
        if (gradleExtensions != null) {
            DefaultGradleExtensions extensions = new DefaultGradleExtensions(gradleExtensions);
            ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
            if (externalProject != null) {
                extensions.getTasks().addAll(externalProject.getTasks().values());
            }
            ideModule.createChild(GradleExtensionsDataService.KEY, (Object)extensions);
        }
        if ((intellijSettings = this.resolverCtx.getExtraProject(gradleModule, IntelliJSettings.class)) != null) {
            ideModule.createChild(ProjectKeys.CONFIGURATION, (Object)new ConfigurationDataImpl(GradleConstants.SYSTEM_ID, intellijSettings.getSettings()));
        }
        if ((externalTestsModel = (ExternalTestsModel)(models = this.resolverCtx.getModels()).getExtraProject(gradleModule, ExternalTestsModel.class)) != null) {
            for (ExternalTestSourceMapping testSourceMapping : externalTestsModel.getTestSourceMappings()) {
                String testName = testSourceMapping.getTestName();
                String testTaskName = testSourceMapping.getTestTaskPath();
                String cleanTestTaskName = testSourceMapping.getCleanTestTaskPath();
                Set sourceFolders = testSourceMapping.getSourceFolders();
                TestData testData = new TestData(GradleConstants.SYSTEM_ID, testName, testTaskName, cleanTestTaskName, sourceFolders);
                ideModule.createChild(ProjectKeys.TEST, (Object)testData);
            }
        }
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            this.addExternalProjectContentRoots(gradleModule, ideModule, externalProject);
        } else if (this.resolverCtx.isResolveModulePerSourceSet()) {
            LOG.error("External Project model is missing for module-per-sourceSet import mode. Please, check import log for error messages.");
        }
        PathPrefixTreeMapImpl contentRootIndex = new PathPrefixTreeMapImpl();
        for (Object contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            contentRootIndex.set(contentRootData.getRootPath(), (Object)contentRootData);
        }
        DomainObjectSet contentRoots = gradleModule.getContentRoots();
        if (contentRoots == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            Set excluded;
            File rootDirectory;
            if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
            boolean oldGradle = false;
            String contentRootPath = FileUtil.toCanonicalPath((String)rootDirectory.getAbsolutePath());
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, contentRootPath);
            contentRootIndex.set(contentRootPath, (Object)ideContentRoot);
            if (!this.resolverCtx.isResolveModulePerSourceSet()) {
                List testResourceDirectories;
                List resourceDirectories;
                List testDirectories;
                List sourceDirectories;
                block13: {
                    sourceDirectories = gradleContentRoot.getSourceDirectories().getAll();
                    testDirectories = gradleContentRoot.getTestDirectories().getAll();
                    resourceDirectories = Collections.emptyList();
                    testResourceDirectories = Collections.emptyList();
                    try {
                        Set<File> notResourceDirs = BaseGradleProjectResolverExtension.collectExplicitNonResourceDirectories(externalProject);
                        resourceDirectories = gradleContentRoot.getResourceDirectories().getAll();
                        BaseGradleProjectResolverExtension.removeDuplicateResources(sourceDirectories, resourceDirectories, notResourceDirs);
                        testResourceDirectories = gradleContentRoot.getTestResourceDirectories().getAll();
                        BaseGradleProjectResolverExtension.removeDuplicateResources(testDirectories, testResourceDirectories, notResourceDirs);
                    }
                    catch (UnsupportedMethodException e) {
                        oldGradle = true;
                        LOG.debug(e.getMessage());
                        if (externalProject != null) break block13;
                        BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
                        BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
                    }
                }
                if (!oldGradle) {
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.SOURCE, sourceDirectories);
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST, testDirectories);
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.RESOURCE, resourceDirectories);
                    BaseGradleProjectResolverExtension.populateContentRoot((PathPrefixTreeMap<ContentRootData>)contentRootIndex, ExternalSystemSourceType.TEST_RESOURCE, testResourceDirectories);
                }
            }
            if ((excluded = gradleContentRoot.getExcludeDirectories()) == null) continue;
            for (File file : excluded) {
                ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getAbsolutePath());
            }
        }
        LinkedHashSet<String> existsContentRoots = new LinkedHashSet<String>();
        for (DataNode contentRootDataNode : ExternalSystemApiUtil.findAll(ideModule, (Key)ProjectKeys.CONTENT_ROOT)) {
            ContentRootData contentRootData = (ContentRootData)contentRootDataNode.getData();
            existsContentRoots.add(contentRootData.getRootPath());
        }
        for (ContentRootData ideContentRoot : contentRootIndex.getValues()) {
            if (existsContentRoots.contains(ideContentRoot.getRootPath())) continue;
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    private void addExternalProjectContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull ExternalProject externalProject) {
        BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

            @Override
            public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                    ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                    ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                    for (File file : sourceDirectorySet.getSrcDirs()) {
                        ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, file.getAbsolutePath());
                        ideContentRoot.storePath(sourceType, file.getAbsolutePath());
                        dataNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
                    }
                }
            }
        });
    }

    private static void removeDuplicateResources(@NotNull List<? extends IdeaSourceDirectory> sourceDirectories, @NotNull List<? extends IdeaSourceDirectory> resourceDirectories, @NotNull Set<File> notResourceDirs) {
        resourceDirectories.removeIf(ideaSourceDirectory -> notResourceDirs.contains(ideaSourceDirectory.getDirectory()));
        BaseGradleProjectResolverExtension.removeAll(sourceDirectories, resourceDirectories);
    }

    @NotNull
    private static Set<File> collectExplicitNonResourceDirectories(@Nullable ExternalProject externalProject) {
        if (externalProject == null) {
            return Collections.emptySet();
        }
        return (Set)externalProject.getSourceSets().values().stream().flatMap(ss -> ss.getSources().entrySet().stream().filter(e -> !((IExternalSystemSourceType)e.getKey()).isResource()).flatMap(e -> ((ExternalSourceDirectorySet)e.getValue()).getSrcDirs().stream())).collect(Collectors.toCollection(() -> ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.FILE_HASHING_STRATEGY)));
    }

    private static void removeAll(List<? extends IdeaSourceDirectory> list, List<? extends IdeaSourceDirectory> toRemove) {
        Set files = toRemove.stream().map(o -> o.getDirectory()).collect(Collectors.toSet());
        list.removeIf(o -> files.contains(o.getDirectory()));
    }

    private static void processSourceSets(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalProject externalProject, @NotNull DataNode<ModuleData> ideModule, @NotNull SourceSetsProcessor processor) {
        HashMap sourceSetsMap = ContainerUtil.newHashMap();
        for (DataNode dataNode : ExternalSystemApiUtil.findAll(ideModule, GradleSourceSetData.KEY)) {
            sourceSetsMap.put(((GradleSourceSetData)((Object)dataNode.getData())).getId(), dataNode);
        }
        for (ExternalSourceSet sourceSet : externalProject.getSourceSets().values()) {
            DataNode moduleDataNode;
            if (sourceSet == null || sourceSet.getSources().isEmpty()) continue;
            String moduleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule, sourceSet);
            DataNode dataNode = moduleDataNode = sourceSetsMap.isEmpty() ? ideModule : (DataNode)sourceSetsMap.get(moduleId);
            if (moduleDataNode == null) continue;
            processor.process((DataNode<? extends ModuleData>)moduleDataNode, sourceSet);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        boolean inheritOutputDirs;
        ModuleData moduleData = (ModuleData)ideModule.getData();
        moduleData.useExternalCompilerOutput(this.resolverCtx.isDelegatedBuild());
        File ideaOutDir = new File(moduleData.getLinkedExternalProjectPath(), "out");
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (this.resolverCtx.isResolveModulePerSourceSet() && externalProject != null) {
            DataNode projectDataNode = ideModule.getDataNode(ProjectKeys.PROJECT);
            assert (projectDataNode != null);
            final Map moduleOutputsMap = (Map)projectDataNode.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
            assert (moduleOutputsMap != null);
            final HashSet outputDirs = ContainerUtil.newHashSet();
            BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                @Override
                public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                    MultiMap gradleOutputMap = (MultiMap)dataNode.getUserData(GradleProjectResolver.GRADLE_OUTPUTS);
                    if (gradleOutputMap == null) {
                        gradleOutputMap = MultiMap.create();
                        dataNode.putUserData(GradleProjectResolver.GRADLE_OUTPUTS, (Object)gradleOutputMap);
                    }
                    ModuleData moduleData = (ModuleData)dataNode.getData();
                    moduleData.useExternalCompilerOutput(BaseGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild());
                    for (Map.Entry directorySetEntry : sourceSet.getSources().entrySet()) {
                        ExternalSystemSourceType sourceType = ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)directorySetEntry.getKey()));
                        ExternalSourceDirectorySet sourceDirectorySet = (ExternalSourceDirectorySet)directorySetEntry.getValue();
                        File ideOutputDir = BaseGradleProjectResolverExtension.getIdeOutputDir(sourceDirectorySet);
                        File gradleOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(sourceDirectorySet);
                        File outputDir = BaseGradleProjectResolverExtension.this.resolverCtx.isDelegatedBuild() ? gradleOutputDir : ideOutputDir;
                        moduleData.setCompileOutputPath(sourceType, ideOutputDir == null ? null : ideOutputDir.getAbsolutePath());
                        moduleData.setExternalCompilerOutputPath(sourceType, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                        moduleData.setInheritProjectCompileOutputPath(sourceDirectorySet.isCompilerOutputPathInherited());
                        if (outputDir == null) continue;
                        outputDirs.add(outputDir.getPath());
                        for (File file : sourceDirectorySet.getGradleOutputDirs()) {
                            String gradleOutputPath = ExternalSystemApiUtil.toCanonicalPath((String)file.getAbsolutePath());
                            gradleOutputMap.putValue((Object)sourceType, (Object)gradleOutputPath);
                            if (file.getPath().equals(outputDir.getPath())) continue;
                            moduleOutputsMap.put(gradleOutputPath, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                        }
                    }
                }
            });
            if (outputDirs.stream().anyMatch(path -> FileUtil.isAncestor((File)ideaOutDir, (File)new File((String)path), (boolean)false))) {
                BaseGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
            return;
        }
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        boolean bl = inheritOutputDirs = moduleCompilerOutput != null && moduleCompilerOutput.getInheritOutputDirs();
        if (moduleCompilerOutput != null) {
            File outputDir = moduleCompilerOutput.getOutputDir();
            if (outputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, outputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, outputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.SOURCE, new File(ideaOutDir, "production/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.RESOURCE, new File(ideaOutDir, "production/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.SOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.SOURCE, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "main", ExternalSystemSourceType.RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            File testOutputDir = moduleCompilerOutput.getTestOutputDir();
            if (testOutputDir != null) {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, testOutputDir.getAbsolutePath());
                moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, testOutputDir.getAbsolutePath());
            } else {
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST, new File(ideaOutDir, "test/classes").getAbsolutePath());
                moduleData.setCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE, new File(ideaOutDir, "test/resources").getAbsolutePath());
                if (externalProject != null) {
                    File gradleOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST, gradleOutputDir == null ? null : gradleOutputDir.getAbsolutePath());
                    File gradleResourceOutputDir = BaseGradleProjectResolverExtension.getGradleOutputDir(externalProject, "test", ExternalSystemSourceType.TEST_RESOURCE);
                    moduleData.setExternalCompilerOutputPath(ExternalSystemSourceType.TEST_RESOURCE, gradleResourceOutputDir == null ? null : gradleResourceOutputDir.getAbsolutePath());
                }
            }
            if (!(this.resolverCtx.isDelegatedBuild() || inheritOutputDirs || outputDir != null && testOutputDir != null)) {
                BaseGradleProjectResolverExtension.excludeOutDir(ideModule, ideaOutDir);
            }
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    @Nullable
    private static File getGradleOutputDir(@NotNull ExternalProject externalProject, @NotNull String sourceSetName, @NotNull ExternalSystemSourceType sourceType) {
        ExternalSourceSet sourceSet = (ExternalSourceSet)externalProject.getSourceSets().get(sourceSetName);
        if (sourceSet == null) {
            return null;
        }
        return BaseGradleProjectResolverExtension.getGradleOutputDir((ExternalSourceDirectorySet)sourceSet.getSources().get(sourceType));
    }

    @Nullable
    private static File getIdeOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getOutputDir();
    }

    @Nullable
    private static File getGradleOutputDir(@Nullable ExternalSourceDirectorySet sourceDirectorySet) {
        if (sourceDirectorySet == null) {
            return null;
        }
        return sourceDirectorySet.getGradleOutputDirs().stream().findFirst().orElse(null);
    }

    private static void excludeOutDir(@NotNull DataNode<ModuleData> ideModule, File ideaOutDir) {
        ContentRootData excludedContentRootData;
        DataNode contentRootDataDataNode = ExternalSystemApiUtil.find(ideModule, (Key)ProjectKeys.CONTENT_ROOT);
        if (contentRootDataDataNode == null || !FileUtil.isAncestor((File)new File(((ContentRootData)contentRootDataDataNode.getData()).getRootPath()), (File)ideaOutDir, (boolean)false)) {
            excludedContentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, ideaOutDir.getAbsolutePath());
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)excludedContentRootData);
        } else {
            excludedContentRootData = (ContentRootData)contentRootDataDataNode.getData();
        }
        excludedContentRootData.storePath(ExternalSystemSourceType.EXCLUDED, ideaOutDir.getAbsolutePath());
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, final @NotNull DataNode<ProjectData> ideProject) {
        ExternalSystemTaskId taskId;
        Project project;
        List dependencies;
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            final Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
            final Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
            assert (artifactsMap != null);
            if (this.resolverCtx.isResolveModulePerSourceSet()) {
                assert (sourceSetMap != null);
                BaseGradleProjectResolverExtension.processSourceSets(this.resolverCtx, gradleModule, externalProject, ideModule, new SourceSetsProcessor(){

                    @Override
                    public void process(@NotNull DataNode<? extends ModuleData> dataNode, @NotNull ExternalSourceSet sourceSet) {
                        GradleProjectResolverUtil.buildDependencies(BaseGradleProjectResolverExtension.this.resolverCtx, sourceSetMap, artifactsMap, dataNode, sourceSet.getDependencies(), (DataNode<ProjectData>)ideProject);
                    }
                });
                return;
            }
        }
        if ((dependencies = gradleModule.getDependencies().getAll()) == null) {
            return;
        }
        ArrayList orphanModules = ContainerUtil.newArrayList();
        HashMap modulesIndex = ContainerUtil.newHashMap();
        for (DataNode dataNode : ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE)) {
            modulesIndex.put(((ModuleData)dataNode.getData()).getExternalName(), dataNode.getData());
        }
        for (int i = 0; i < dependencies.size(); ++i) {
            ModuleDependencyData d;
            IdeaDependency dependency = (IdeaDependency)dependencies.get(i);
            if (dependency == null) continue;
            DependencyScope scope = BaseGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = BaseGradleProjectResolverExtension.buildDependency(this.resolverCtx, ideModule, (IdeaModuleDependency)dependency, modulesIndex);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                d.setOrder(i);
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                ModuleData targetModule = (ModuleData)d.getTarget();
                if (!targetModule.getId().isEmpty() || !targetModule.getLinkedExternalProjectPath().isEmpty()) continue;
                orphanModules.add(targetModule.getExternalName());
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            d.setOrder(i);
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
        if (!orphanModules.isEmpty() && (project = (taskId = this.resolverCtx.getExternalSystemTaskId()).findProject()) != null) {
            String msg = "Can't find the following module" + (orphanModules.size() > 1 ? "s" : "") + ": " + StringUtil.join((Collection)orphanModules, (String)", ") + "\nIt can be caused by composite build configuration inside your *.gradle scripts with Gradle version older than 3.3.\nTry Gradle 3.3 or better or enable 'Create separate module per source set' option";
            NotificationData notification = new NotificationData("Gradle project structure problems", msg, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(taskId.getProjectSystemId(), notification);
        }
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        boolean isFlatProject;
        ArrayList tasks = ContainerUtil.newArrayList();
        String moduleConfigPath = ((ModuleData)ideModule.getData()).getLinkedExternalProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        String rootProjectPath = ((ProjectData)ideProject.getData()).getLinkedExternalProjectPath();
        try {
            GradleBuild build = this.resolverCtx.getExtraProject(gradleModule, GradleBuild.class);
            if (build != null) {
                rootProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)build.getRootProject().getProjectDirectory().getCanonicalPath());
            }
        }
        catch (IOException e) {
            LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
        }
        boolean bl = isFlatProject = !FileUtil.isAncestor((String)rootProjectPath, (String)moduleConfigPath, (boolean)false);
        if (externalProject != null) {
            for (ExternalTask task : externalProject.getTasks().values()) {
                String taskName = isFlatProject ? task.getQName() : task.getName();
                String taskGroup = task.getGroup();
                if (taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
                String taskPath = isFlatProject ? rootProjectPath : moduleConfigPath;
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, taskPath, task.getDescription());
                taskData.setGroup(taskGroup);
                taskData.setType(task.getType());
                taskData.setTest(task.isTest());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(StringUtil.equals((CharSequence)task.getName(), (CharSequence)task.getQName()));
                tasks.add(taskData);
            }
            return tasks;
        }
        for (GradleTask task : gradleModule.getGradleProject().getTasks()) {
            String taskName = task.getName();
            String taskGroup = BaseGradleProjectResolverExtension.getTaskGroup(task);
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask(taskName, taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task.getDescription());
            taskData.setGroup(taskGroup);
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks.add(taskData);
        }
        return tasks;
    }

    @Nullable
    private static String getTaskGroup(GradleTask task) {
        String taskGroup;
        try {
            taskGroup = task.getGroup();
        }
        catch (UnsupportedMethodException e) {
            taskGroup = null;
        }
        return taskGroup;
    }

    @Override
    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set result = ContainerUtil.set((Object[])new Class[]{GradleBuild.class, ModuleExtendedModel.class});
        result.add(BuildScriptClasspathModel.class);
        result.add(GradleExtensions.class);
        result.add(ExternalProject.class);
        result.add(ExternalTestsModel.class);
        result.add(IntelliJProjectSettings.class);
        result.add(IntelliJSettings.class);
        return result;
    }

    @Override
    @NotNull
    public ProjectImportExtraModelProvider getExtraModelProvider() {
        return new ClassSetProjectImportExtraModelProvider(this.getExtraProjectModelClasses());
    }

    @Override
    @NotNull
    public Set<Class> getToolingExtensionsClasses() {
        return ContainerUtil.set((Object[])new Class[]{ExternalSystemSourceType.class, ProjectImportAction.class, ModelBuildScriptClasspathBuilderImpl.class, Multimap.class, GsonBuilder.class, ShortTypeHandling.class});
    }

    @Override
    public Set<Class> getTargetTypes() {
        return ContainerUtil.set((Object[])new Class[]{ExternalProjectDependency.class, ExternalLibraryDependency.class, FileCollectionDependency.class, UnresolvedExternalDependency.class});
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            List hosts;
            ArrayList extraJvmArgs = ContainerUtil.newArrayList();
            HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
            if (!StringUtil.isEmpty((String)httpConfigurable.PROXY_EXCEPTIONS) && !(hosts = StringUtil.split((String)httpConfigurable.PROXY_EXCEPTIONS, (String)",")).isEmpty()) {
                String nonProxyHosts = StringUtil.join((Collection)hosts, (Function)StringUtil.TRIMMER, (String)"|");
                extraJvmArgs.add(Pair.pair((Object)"http.nonProxyHosts", (Object)nonProxyHosts));
                extraJvmArgs.add(Pair.pair((Object)"https.nonProxyHosts", (Object)nonProxyHosts));
            }
            if (httpConfigurable.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)httpConfigurable.getProxyLogin())) {
                extraJvmArgs.add(Pair.pair((Object)"http.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                extraJvmArgs.add(Pair.pair((Object)"https.proxyUser", (Object)httpConfigurable.getProxyLogin()));
                String plainProxyPassword = httpConfigurable.getPlainProxyPassword();
                extraJvmArgs.add(Pair.pair((Object)"http.proxyPassword", (Object)plainProxyPassword));
                extraJvmArgs.add(Pair.pair((Object)"https.proxyPassword", (Object)plainProxyPassword));
            }
            extraJvmArgs.addAll(httpConfigurable.getJvmProperties(false, null));
            return extraJvmArgs;
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<String> getExtraCommandLineArgs() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        return this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
    }

    @Override
    public void preImportCheck() {
    }

    @Override
    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmAgentSetup, @NotNull Consumer<String> initScriptConsumer) {
        if (!StringUtil.isEmpty((String)jvmAgentSetup)) {
            ForkedDebuggerConfiguration forkedDebuggerSetup = ForkedDebuggerConfiguration.parse((String)jvmAgentSetup);
            if (forkedDebuggerSetup != null) {
                this.setupDebugForAllJvmForkedTasks(initScriptConsumer, forkedDebuggerSetup.getForkSocketPort());
            } else {
                String names = "[\"" + StringUtil.join(taskNames, (String)"\", \"") + "\"]";
                String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task instanceof JavaForkOptions && (" + names + ".contains(task.name) || " + names + ".contains(task.path))) {", "        def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp')}", "        jvmArgs << '" + jvmAgentSetup.trim().replace("\\", "\\\\") + '\'', "        task.jvmArgs = jvmArgs", "    }}"};
                String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
                initScriptConsumer.consume((Object)script);
            }
        }
    }

    public void setupDebugForAllJvmForkedTasks(@NotNull Consumer<String> initScriptConsumer, int debugPort) {
        String esRtJarPath = PathUtil.getCanonicalPath((String)PathManager.getJarPathForClass(ExternalSystemSourceType.class));
        String[] lines = new String[]{"initscript {", "  dependencies {", "    classpath files(\"" + esRtJarPath + "\")", "  }", "}", "gradle.taskGraph.beforeTask { Task task ->", " if (task instanceof org.gradle.api.tasks.testing.Test) {", "  task.maxParallelForks = 1", "  task.forkEvery = 0", " }", " if (task instanceof JavaForkOptions) {", "  def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib:jdwp') && !it?.startsWith('-Xrunjdwp')}", "  jvmArgs << com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerHelper.setupDebugger(task.path, " + debugPort + ")", "  task.jvmArgs = jvmArgs", " }", "}", "gradle.taskGraph.afterTask { Task task ->", "    if (task instanceof JavaForkOptions) {", "        com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerHelper.processFinished(task.path, " + debugPort + ")", "    }", "}"};
        String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
        initScriptConsumer.consume((Object)script);
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
    }

    private static void populateContentRoot(@NotNull PathPrefixTreeMap<ContentRootData> contentRootIndex, @NotNull ExternalSystemSourceType type, @Nullable Iterable<? extends IdeaSourceDirectory> dirs) throws IllegalArgumentException {
        if (dirs == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            catch (Throwable e) {
                LOG.debug(e);
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            String path = FileUtil.toCanonicalPath((String)ideaSourceDirectory.getDirectory().getAbsolutePath());
            if (contentRootIndex.getAllAncestorKeys(path).isEmpty()) {
                ContentRootData contentRootData = new ContentRootData(GradleConstants.SYSTEM_ID, path);
                contentRootIndex.set(path, (Object)contentRootData);
            }
            List ancestors = contentRootIndex.getAllAncestorKeys(path);
            String contentRootPath = (String)ancestors.get(ancestors.size() - 1);
            ContentRootData contentRoot = (ContentRootData)contentRootIndex.get(contentRootPath);
            assert (contentRoot != null);
            contentRoot.storePath(dirSourceType, path);
        }
    }

    private static void printToolingProxyDiagnosticInfo(@Nullable Object obj) {
        if (!LOG.isDebugEnabled() || obj == null) {
            return;
        }
        LOG.debug(String.format("obj: %s", obj));
        Class<?> aClass = obj.getClass();
        LOG.debug(String.format("obj class: %s", aClass));
        LOG.debug(String.format("classloader: %s", aClass.getClassLoader()));
        for (Method m : aClass.getDeclaredMethods()) {
            LOG.debug(String.format("obj m: %s", m));
        }
        if (obj instanceof Proxy) {
            try {
                Field hField = ReflectionUtil.findField(obj.getClass(), null, (String)"h");
                hField.setAccessible(true);
                Object h = hField.get(obj);
                Field delegateField = ReflectionUtil.findField(h.getClass(), null, (String)"delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(h);
                LOG.debug(String.format("delegate: %s", delegate));
                LOG.debug(String.format("delegate class: %s", delegate.getClass()));
                LOG.debug(String.format("delegate classloader: %s", delegate.getClass().getClassLoader()));
                for (Method m : delegate.getClass().getDeclaredMethods()) {
                    LOG.debug(String.format("delegate m: %s", m));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    @Nullable
    private static DependencyScope parseScope(@Nullable IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    @NotNull
    private static ModuleDependencyData buildDependency(@NotNull ProjectResolverContext resolverContext, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaModuleDependency dependency, @NotNull Map<String, ModuleData> registeredModulesIndex) throws IllegalStateException {
        ModuleData moduleData;
        ModuleData moduleData2;
        IdeaModule dependencyModule;
        GradleVersion projectGradleVersion;
        GradleExecutionSettings gradleExecutionSettings = resolverContext.getSettings();
        String projectGradleVersionString = resolverContext.getProjectGradleVersion();
        if (gradleExecutionSettings != null && projectGradleVersionString != null && (projectGradleVersion = GradleVersion.version((String)projectGradleVersionString)).compareTo(GradleVersion.version((String)"4.0")) < 0 && (dependencyModule = dependency.getDependencyModule()) != null && (moduleData2 = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByModule(resolverContext, dependencyModule)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData2);
        }
        String moduleName = dependency.getTargetModuleName();
        if (gradleExecutionSettings != null && (moduleData = gradleExecutionSettings.getExecutionWorkspace().findModuleDataByGradleModuleName(moduleName)) != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), moduleData);
        }
        ModuleData registeredModuleData = registeredModulesIndex.get(moduleName);
        if (registeredModuleData != null) {
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), registeredModuleData);
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModulesIndex.keySet()));
    }

    @NotNull
    private LibraryDependencyData buildDependency(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ownerModule, @NotNull IdeaSingleEntryLibraryDependency dependency, @NotNull DataNode<ProjectData> ideProject) throws IllegalStateException {
        String libraryName;
        LibraryLevel level;
        File binaryPath = dependency.getFile();
        if (binaryPath == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getName().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            if (binaryPath.isFile()) {
                boolean isModuleLocalLibrary = false;
                try {
                    isModuleLocalLibrary = FileUtil.isAncestor((File)gradleModule.getGradleProject().getProjectDirectory(), (File)binaryPath, (boolean)false);
                }
                catch (UnsupportedMethodException unsupportedMethodException) {
                    // empty catch block
                }
                level = isModuleLocalLibrary ? LibraryLevel.MODULE : LibraryLevel.PROJECT;
                libraryName = this.chooseName(binaryPath, level, ideProject);
            } else {
                level = LibraryLevel.MODULE;
                libraryName = "";
            }
            if (unresolved) {
                int dependencyNameIndex;
                libraryName = binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                int i = libraryName.indexOf(32);
                if (i >= 0) {
                    i = CharArrayUtil.shiftForward((CharSequence)libraryName, (int)(i + 1), (String)" ");
                }
                if (i >= 0 && i < libraryName.length() && (i = libraryName.indexOf(32, dependencyNameIndex = i)) > 0) {
                    libraryName = String.format("%s-%s", libraryName.substring(dependencyNameIndex, i), libraryName.substring(i + 1));
                }
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtil.getNameWithoutExtension((File)binaryPath);
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        if (StringUtil.isNotEmpty((String)libraryName) && !FileUtilRt.extensionEquals((String)binaryPath.getName(), (String)"jar")) {
            libraryName = libraryName + ":" + FileUtilRt.getExtension((String)binaryPath.getName());
        }
        LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, unresolved);
        if (moduleVersion != null) {
            library.setGroup(moduleVersion.getGroup());
            library.setArtifactId(moduleVersion.getName());
            library.setVersion(moduleVersion.getVersion());
        }
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getAbsolutePath());
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
        }
        if (!unresolved && sourcePath == null) {
            GradleProjectResolverUtil.attachGradleSdkSources(gradleModule, binaryPath, library, this.resolverCtx);
            if (this.resolverCtx instanceof DefaultProjectResolverContext) {
                GradleProjectResolverUtil.attachSourcesAndJavadocFromGradleCacheIfNeeded(((DefaultProjectResolverContext)this.resolverCtx).getGradleUserHome(), library);
            }
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getAbsolutePath());
        }
        if (level == LibraryLevel.PROJECT && !GradleProjectResolverUtil.linkProjectLibrary(ideProject, library)) {
            level = LibraryLevel.MODULE;
        }
        return new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
    }

    private String chooseName(File path, LibraryLevel level, DataNode<ProjectData> ideProject) {
        String candidateName;
        DataNode libraryData;
        String fileName = FileUtil.getNameWithoutExtension((File)path);
        if (level == LibraryLevel.MODULE) {
            return fileName;
        }
        int count = 0;
        while ((libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, arg_0 -> BaseGradleProjectResolverExtension.lambda$chooseName$8(candidateName = fileName + (count == 0 ? "" : "_" + count), arg_0))) != null) {
            if (((LibraryData)libraryData.getData()).getPaths(LibraryPathType.BINARY).contains(FileUtil.toSystemIndependentName((String)path.getAbsolutePath()))) {
                return candidateName;
            }
            ++count;
        }
        return candidateName;
    }

    private static /* synthetic */ boolean lambda$chooseName$8(String candidateName, DataNode node) {
        return ((LibraryData)node.getData()).getExternalName().equals(candidateName);
    }

    private static interface SourceSetsProcessor {
        public void process(@NotNull DataNode<? extends ModuleData> var1, @NotNull ExternalSourceSet var2);
    }
}

