/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import java.util.Collection;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;

public class TracedProjectResolverExtension
extends AbstractProjectResolverExtension {
    private final PerformanceTrace myTrace;

    public TracedProjectResolverExtension(@NotNull GradleProjectResolverExtension nextExtension, @NotNull PerformanceTrace trace) {
        this.setNext(nextExtension);
        this.myTrace = trace;
    }

    @Override
    @NotNull
    public ProjectData createProject() {
        long startTime = System.currentTimeMillis();
        ProjectData project = super.createProject();
        this.myTrace.logPerformance("Resolver chain createProject", System.currentTimeMillis() - startTime);
        return project;
    }

    @Override
    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        long startTime = System.currentTimeMillis();
        super.populateProjectExtraModels(gradleProject, ideProject);
        this.myTrace.logPerformance("Resolver chain populateProjectExtraModels project " + gradleProject.getName(), System.currentTimeMillis() - startTime);
    }

    @Override
    @NotNull
    public DataNode<ModuleData> createModule(@NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        long startTime = System.currentTimeMillis();
        DataNode<ModuleData> module = super.createModule(gradleModule, projectDataNode);
        this.myTrace.logPerformance("Resolver chain createModule module " + gradleModule.getName(), System.currentTimeMillis() - startTime);
        return module;
    }

    @Override
    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        long startTime = System.currentTimeMillis();
        super.populateModuleExtraModels(gradleModule, ideModule);
        this.myTrace.logPerformance("Resolver chain populateModuleExtraModels module " + gradleModule.getName(), System.currentTimeMillis() - startTime);
    }

    @Override
    public void populateModuleContentRoots(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        long startTime = System.currentTimeMillis();
        super.populateModuleContentRoots(gradleModule, ideModule);
        this.myTrace.logPerformance("Resolver chain populateModuleContentRoots module " + gradleModule.getName(), System.currentTimeMillis() - startTime);
    }

    @Override
    public void populateModuleCompileOutputSettings(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        long startTime = System.currentTimeMillis();
        super.populateModuleCompileOutputSettings(gradleModule, ideModule);
        this.myTrace.logPerformance("Resolver chain populateModuleCompileOutputSettings module " + gradleModule.getName(), System.currentTimeMillis() - startTime);
    }

    @Override
    public void populateModuleDependencies(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) {
        long startTime = System.currentTimeMillis();
        super.populateModuleDependencies(gradleModule, ideModule, ideProject);
        this.myTrace.logPerformance("Resolver chain populateModuleDependencies module " + gradleModule.getName(), System.currentTimeMillis() - startTime);
    }

    @Override
    @NotNull
    public Collection<TaskData> populateModuleTasks(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule, @NotNull DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        long startTime = System.currentTimeMillis();
        Collection<TaskData> data = super.populateModuleTasks(gradleModule, ideModule, ideProject);
        this.myTrace.logPerformance("Resolver chain populateModuleTasks module " + gradleModule.getName(), System.currentTimeMillis() - startTime);
        return data;
    }
}

