/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectSerializer;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class ExternalProjectDataCache {
    private static final Logger LOG = Logger.getInstance(ExternalProjectDataCache.class);
    @NotNull
    private final Map<String, ExternalProject> myExternalRootProjects = ConcurrentFactoryMap.createMap(key -> new ExternalProjectSerializer().load(GradleConstants.SYSTEM_ID, new File((String)key)), () -> ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)FilePathHashingStrategy.create()));

    public static ExternalProjectDataCache getInstance(@NotNull Project project) {
        return (ExternalProjectDataCache)ServiceManager.getService((Project)project, ExternalProjectDataCache.class);
    }

    @Deprecated
    @Nullable
    public ExternalProject getRootExternalProject(@NotNull ProjectSystemId systemId, @NotNull File projectRootDir) {
        if (GradleConstants.SYSTEM_ID != systemId) {
            throw new IllegalStateException("Attempt to use Gradle-specific cache with illegal system id [" + systemId.getReadableName() + "]");
        }
        return this.getRootExternalProject(ExternalSystemApiUtil.toCanonicalPath((String)projectRootDir.getAbsolutePath()));
    }

    @Nullable
    public ExternalProject getRootExternalProject(@NotNull String externalProjectPath) {
        ExternalProject externalProject = this.myExternalRootProjects.get(externalProjectPath);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Can not find data for project at: " + externalProjectPath);
            LOG.debug("Existing imported projects paths: " + ContainerUtil.map(this.myExternalRootProjects.entrySet(), entry -> {
                if (!(entry.getValue() instanceof ExternalProject)) {
                    return null;
                }
                return Pair.create(entry.getKey(), (Object)((ExternalProject)entry.getValue()).getProjectDir());
            }));
        }
        return externalProject;
    }

    public void saveExternalProject(@NotNull ExternalProject externalProject) {
        DefaultExternalProject value = new DefaultExternalProject(externalProject);
        new ExternalProjectSerializer().save((ExternalProject)value);
        this.myExternalRootProjects.put(ExternalSystemApiUtil.toCanonicalPath((String)externalProject.getProjectDir().getAbsolutePath()), (ExternalProject)value);
    }

    @NotNull
    public Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull Module module) {
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        boolean isSourceSet = "sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module));
        return externalProjectId != null ? ExternalProjectDataCache.findExternalProject(parentProject, externalProjectId, isSourceSet) : Collections.emptyMap();
    }

    @NotNull
    private static Map<String, ExternalSourceSet> findExternalProject(@NotNull ExternalProject parentProject, @NotNull String externalProjectId, boolean isSourceSet) {
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(parentProject);
        while (!queue.isEmpty()) {
            ExternalProject externalProject = (ExternalProject)queue.remove();
            String projectId = externalProject.getId();
            boolean isRelatedProject = projectId.equals(externalProjectId);
            HashMap result = ContainerUtil.newHashMap();
            for (Map.Entry sourceSetEntry : externalProject.getSourceSets().entrySet()) {
                String sourceSetName = (String)sourceSetEntry.getKey();
                String sourceSetId = projectId + ":" + sourceSetName;
                if (!isRelatedProject && (!isSourceSet || !externalProjectId.equals(sourceSetId))) continue;
                result.put(sourceSetName, sourceSetEntry.getValue());
            }
            if (!result.isEmpty() || isRelatedProject) {
                return result;
            }
            queue.addAll(externalProject.getChildProjects().values());
        }
        return Collections.emptyMap();
    }
}

