/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.PerformanceTrace;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=1001)
public class PerformanceTraceDataService
extends AbstractProjectDataService<PerformanceTrace, Object> {
    private static final Logger LOG = Logger.getInstance(PerformanceTraceDataService.class);

    @NotNull
    public Key<PerformanceTrace> getTargetDataKey() {
        return PerformanceTrace.TRACE_NODE_KEY;
    }

    public void onSuccessImport(@NotNull Collection<DataNode<PerformanceTrace>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        if (imported.size() > 0) {
            PerformanceTrace trace = (PerformanceTrace)imported.iterator().next().getData();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Gradle successful import performance trace");
                for (Map.Entry entry : trace.getPerformanceTrace().entrySet()) {
                    LOG.debug((String)entry.getKey() + " : " + entry.getValue() + " ms.");
                }
            }
        }
    }
}

