/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleViewContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{GradleSourceSetData.KEY};

    @NotNull
    public ProjectSystemId getSystemId() {
        return GradleConstants.SYSTEM_ID;
    }

    @NotNull
    public List<Key<?>> getKeys() {
        return Arrays.asList(KEYS);
    }

    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result = new SmartList();
        GradleViewContributor.addCustomSourceSetsNodes(externalProjectsView, dataNodes, result);
        return result;
    }

    @Nullable
    public String getDisplayName(@NotNull DataNode node) {
        if (ProjectKeys.MODULE.equals((Object)node.getKey())) {
            return ((ModuleData)node.getData()).getId();
        }
        return super.getDisplayName(node);
    }

    private static void addCustomSourceSetsNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<ExternalSystemNode<?>> result) {
        Collection sourceSetsDataNodes = dataNodes.get(GradleSourceSetData.KEY);
        if (!sourceSetsDataNodes.isEmpty()) {
            SourceSetsNode sourceSetsNode = new SourceSetsNode(externalProjectsView);
            for (DataNode dataNode : sourceSetsDataNodes) {
                sourceSetsNode.add(new SourceSetNode(externalProjectsView, (DataNode<GradleSourceSetData>)dataNode));
            }
            result.add(sourceSetsNode);
        }
    }

    private static class SourceSetNode
    extends ExternalSystemNode<GradleSourceSetData> {
        SourceSetNode(ExternalProjectsView externalProjectsView, DataNode<GradleSourceSetData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Modules.SourceFolder);
            GradleSourceSetData data = (GradleSourceSetData)((Object)this.getData());
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null);
            }
        }

        public String getName() {
            GradleSourceSetData data = (GradleSourceSetData)((Object)this.getData());
            return data != null ? StringUtil.substringAfter((String)data.getExternalName(), (String)":") : "";
        }
    }

    @Order(value=9)
    private static class SourceSetsNode
    extends ExternalSystemNode {
        SourceSetsNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(@NotNull PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.ModuleGroup);
        }

        public String getName() {
            return "Source Sets";
        }
    }
}

