/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.GradleSystemSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.service.settings.IdeaGradleSystemSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public abstract class GradleSettingsControlProvider {
    private static final ExtensionPointName<GradleSettingsControlProvider> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.gradle.settingsControlProvider");

    public abstract String getPlatformPrefix();

    public abstract GradleSystemSettingsControlBuilder getSystemSettingsControlBuilder(@NotNull GradleSettings var1);

    public abstract GradleProjectSettingsControlBuilder getProjectSettingsControlBuilder(@NotNull GradleProjectSettings var1);

    @NotNull
    public static GradleSettingsControlProvider get() {
        GradleSettingsControlProvider result = null;
        String platformPrefix = PlatformUtils.getPlatformPrefix();
        for (GradleSettingsControlProvider provider : (GradleSettingsControlProvider[])EP_NAME.getExtensions()) {
            if (!StringUtil.equals((CharSequence)platformPrefix, (CharSequence)provider.getPlatformPrefix())) continue;
            assert (result == null) : "Multiple GradleSettingsControlProvider extensions found";
            result = provider;
        }
        return (GradleSettingsControlProvider)ObjectUtils.notNull(result, (Object)new GradleSettingsControlProvider(){

            @Override
            public String getPlatformPrefix() {
                return null;
            }

            @Override
            public GradleSystemSettingsControlBuilder getSystemSettingsControlBuilder(@NotNull GradleSettings initialSettings) {
                return new IdeaGradleSystemSettingsControlBuilder(initialSettings);
            }

            @Override
            public GradleProjectSettingsControlBuilder getProjectSettingsControlBuilder(@NotNull GradleProjectSettings initialSettings) {
                return new IdeaGradleProjectSettingsControlBuilder(initialSettings).dropModulesGroupingOptionPanel().dropStoreExternallyCheckBox().dropResolveModulePerSourceSetCheckBox().dropDelegateBuildCombobox().dropTestRunnerCombobox().dropCustomizableWrapperButton().dropUseBundledDistributionButton();
            }
        });
    }
}

