/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.DefaultGradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

public class GradleSettingsService {
    @NotNull
    private final Project myProject;

    public GradleSettingsService(@NotNull Project project) {
        this.myProject = project;
    }

    public boolean isDelegatedBuildEnabled(@NotNull String gradleProjectPath) {
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(this.myProject).getLinkedProjectSettings(gradleProjectPath);
        if (projectSettings == null) {
            return false;
        }
        if (projectSettings.getDelegatedBuild() == ThreeState.UNSURE) {
            return DefaultGradleProjectSettings.getInstance(this.myProject).isDelegatedBuild();
        }
        return projectSettings.getDelegatedBuild().toBoolean();
    }

    @NotNull
    public TestRunner getTestRunner(@NotNull String gradleProjectPath) {
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance(this.myProject).getLinkedProjectSettings(gradleProjectPath);
        return projectSettings == null || projectSettings.getTestRunner() == null ? DefaultGradleProjectSettings.getInstance(this.myProject).getTestRunner() : projectSettings.getTestRunner();
    }

    public static boolean isDelegatedBuildEnabled(@NotNull Module module) {
        String projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (projectPath == null) {
            return false;
        }
        return GradleSettingsService.getInstance(module.getProject()).isDelegatedBuildEnabled(projectPath);
    }

    @NotNull
    public static TestRunner getTestRunner(@NotNull Module module) {
        String projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (projectPath == null) {
            return DefaultGradleProjectSettings.getInstance(module.getProject()).getTestRunner();
        }
        return GradleSettingsService.getInstance(module.getProject()).getTestRunner(projectPath);
    }

    @NotNull
    public static GradleSettingsService getInstance(@NotNull Project project) {
        return (GradleSettingsService)ServiceManager.getService((Project)project, GradleSettingsService.class);
    }
}

