/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupportedImpl;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.rt.execution.ForkedDebuggerConfiguration;
import com.intellij.openapi.externalSystem.task.BaseExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleTaskManager
extends BaseExternalSystemTaskManager<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance(GradleTaskManager.class);
    public static final Key<String> INIT_SCRIPT_KEY = Key.create((String)"INIT_SCRIPT_KEY");
    public static final Key<String> INIT_SCRIPT_PREFIX_KEY = Key.create((String)"INIT_SCRIPT_PREFIX_KEY");
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap = ContainerUtil.newConcurrentMap();

    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable String jvmAgentSetup, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, taskNames, projectPath, settings, jvmAgentSetup, listener)) continue;
                return;
            }
        }
        GradleExecutionSettings effectiveSettings = settings == null ? new GradleExecutionSettings(null, null, DistributionType.BUNDLED, false) : settings;
        ForkedDebuggerConfiguration forkedDebuggerSetup = ForkedDebuggerConfiguration.parse((String)jvmAgentSetup);
        if (forkedDebuggerSetup != null && this.isGradleScriptDebug(settings)) {
            effectiveSettings.withVmOption(forkedDebuggerSetup.getJvmAgentSetup(this.isJdk9orLater(effectiveSettings.getJavaHome())));
        }
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        this.myCancellationMap.put(id, cancellationTokenSource);
        Function f = connection -> {
            try {
                GradleTaskManager.appendInitScriptArgument(taskNames, jvmAgentSetup, effectiveSettings);
                try {
                    GradleVersion gradleVersion = GradleExecutionHelper.getGradleVersion(connection, id, listener, cancellationTokenSource);
                    if (gradleVersion != null && gradleVersion.compareTo(GradleVersion.version((String)"2.5")) < 0) {
                        listener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemTaskExecutionEvent(id, (ExternalSystemProgressEvent)new ExternalSystemProgressEventUnsupportedImpl(gradleVersion + " does not support executions view")));
                    }
                    for (GradleBuildParticipant buildParticipant : effectiveSettings.getExecutionWorkspace().getBuildParticipants()) {
                        effectiveSettings.withArguments(new String[]{"--include-build", buildParticipant.getProjectPath()});
                    }
                    BuildLauncher launcher = this.myHelper.getBuildLauncher(id, (ProjectConnection)connection, effectiveSettings, listener);
                    launcher.forTasks(ArrayUtil.toStringArray((Collection)taskNames));
                    launcher.withCancellationToken(cancellationTokenSource.token());
                    launcher.run();
                }
                finally {
                    this.myCancellationMap.remove(id);
                }
                return null;
            }
            catch (RuntimeException e) {
                LOG.debug("Gradle build launcher error", (Throwable)e);
                GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(effectiveSettings);
                throw projectResolverChain.getUserFriendlyError(e, projectPath, null);
            }
        };
        if (effectiveSettings.getDistributionType() == DistributionType.WRAPPED) {
            this.myHelper.ensureInstalledWrapper(id, GradleUtil.determineRootProject(projectPath), effectiveSettings, listener, cancellationTokenSource.token());
        }
        this.myHelper.execute(projectPath, effectiveSettings, f);
    }

    protected boolean isGradleScriptDebug(@Nullable GradleExecutionSettings settings) {
        return Optional.ofNullable(settings).map(s -> (Boolean)s.getUserData(GradleRunConfiguration.DEBUG_FLAG_KEY)).orElse(false);
    }

    public static void appendInitScriptArgument(@NotNull List<String> taskNames, @Nullable String jvmAgentSetup, @NotNull GradleExecutionSettings effectiveSettings) {
        String initScript;
        GradleProjectResolverExtension projectResolverChain;
        ArrayList initScripts = ContainerUtil.newArrayList();
        for (GradleProjectResolverExtension resolverExtension = projectResolverChain = GradleProjectResolver.createProjectResolverChain(effectiveSettings); resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            String resolverClassName = resolverExtension.getClass().getName();
            resolverExtension.enhanceTaskProcessing(taskNames, jvmAgentSetup, (Consumer<String>)((Consumer)script -> {
                if (StringUtil.isNotEmpty((String)script)) {
                    ContainerUtil.addAllNotNull((Collection)initScripts, (Object[])new String[]{"//-- Generated by " + resolverClassName, script, "//"});
                }
            }));
        }
        if (!initScripts.isEmpty()) {
            try {
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(StringUtil.join((Collection)initScripts, (String)SystemProperties.getLineSeparator()), "ijresolvers");
                effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
            }
            catch (IOException e) {
                throw new ExternalSystemException((Throwable)e);
            }
        }
        if (StringUtil.isNotEmpty((String)(initScript = (String)effectiveSettings.getUserData(INIT_SCRIPT_KEY)))) {
            try {
                String initScriptPrefix = (String)effectiveSettings.getUserData(INIT_SCRIPT_PREFIX_KEY);
                initScriptPrefix = StringUtil.isEmpty((String)initScriptPrefix) ? "ijmiscinit" : FileUtil.sanitizeFileName((String)initScriptPrefix);
                File tempFile = GradleExecutionHelper.writeToFileGradleInitScript(initScript, initScriptPrefix);
                effectiveSettings.withArguments(new String[]{"--init-script", tempFile.getAbsolutePath()});
            }
            catch (IOException e) {
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        CancellationTokenSource cancellationTokenSource = this.myCancellationMap.get(id);
        if (cancellationTokenSource != null) {
            cancellationTokenSource.cancel();
            return true;
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener)) continue;
                return true;
            }
        }
        return false;
    }
}

