/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSystemRunningSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

@State(name="DefaultGradleProjectSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DefaultGradleProjectSettings
implements PersistentStateComponent<MyState> {
    private boolean myMigrated;
    private boolean myDelegatedBuild = true;
    @NotNull
    private TestRunner myTestRunner = TestRunner.GRADLE;

    @NotNull
    public TestRunner getTestRunner() {
        return this.myTestRunner;
    }

    void setTestRunner(@NotNull TestRunner testRunner) {
        this.myTestRunner = testRunner;
    }

    public boolean isDelegatedBuild() {
        return this.myDelegatedBuild;
    }

    public void setDelegatedBuild(boolean delegatedBuild) {
        this.myDelegatedBuild = delegatedBuild;
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    boolean isMigrated() {
        return this.myMigrated;
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
    void setMigrated(boolean migrated) {
        this.myMigrated = migrated;
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        state.delegatedBuild = this.myDelegatedBuild;
        state.testRunner = this.myTestRunner;
        state.isMigrated = this.myMigrated;
        return state;
    }

    public void loadState(@NotNull MyState state) {
        if (!state.isMigrated) {
            this.migrateOldSettings();
        } else {
            this.myDelegatedBuild = state.delegatedBuild;
            this.myTestRunner = state.testRunner;
        }
        this.myMigrated = true;
    }

    private void migrateOldSettings() {
        GradleSystemRunningSettings oldAppSettings = GradleSystemRunningSettings.getInstance();
        this.myDelegatedBuild = oldAppSettings.isUseGradleAwareMake();
        GradleSystemRunningSettings.PreferredTestRunner oldTestRunner = oldAppSettings.getDefaultTestRunner();
        if (oldTestRunner == GradleSystemRunningSettings.PreferredTestRunner.PLATFORM_TEST_RUNNER) {
            this.myTestRunner = TestRunner.PLATFORM;
        } else if (oldTestRunner == GradleSystemRunningSettings.PreferredTestRunner.GRADLE_TEST_RUNNER) {
            this.myTestRunner = TestRunner.GRADLE;
        } else if (oldTestRunner == GradleSystemRunningSettings.PreferredTestRunner.CHOOSE_PER_TEST) {
            this.myTestRunner = TestRunner.CHOOSE_PER_TEST;
        }
    }

    @NotNull
    public static DefaultGradleProjectSettings getInstance(@NotNull Project project) {
        return (DefaultGradleProjectSettings)ServiceManager.getService((Project)project, DefaultGradleProjectSettings.class);
    }

    @ApiStatus.Experimental
    public static class MyState {
        public TestRunner testRunner = TestRunner.PLATFORM;
        public boolean delegatedBuild;
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2019.2")
        public boolean isMigrated;
    }
}

