/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;

public class GradleExecutionSettings
extends ExternalSystemExecutionSettings {
    private static final boolean USE_VERBOSE_GRADLE_API_BY_DEFAULT = Boolean.parseBoolean(System.getProperty("gradle.api.verbose"));
    private static final long serialVersionUID = 1L;
    @NotNull
    private final GradleExecutionWorkspace myExecutionWorkspace = new GradleExecutionWorkspace();
    @NotNull
    private final List<ClassHolder<? extends GradleProjectResolverExtension>> myResolverExtensions = ContainerUtilRt.newArrayList();
    @Nullable
    private final String myGradleHome;
    @Nullable
    private final String myServiceDirectory;
    private final boolean myIsOfflineWork;
    @NotNull
    private final DistributionType myDistributionType;
    @Nullable
    private String wrapperPropertyFile;
    @Nullable
    private String myJavaHome;
    @Nullable
    private String myIdeProjectPath;
    private boolean resolveModulePerSourceSet = true;
    private boolean useQualifiedModuleNames = false;
    private boolean delegatedBuild = true;

    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, boolean isOfflineWork) {
        this.myGradleHome = gradleHome;
        this.myServiceDirectory = serviceDirectory;
        this.myDistributionType = distributionType;
        this.myIsOfflineWork = isOfflineWork;
        this.setVerboseProcessing(USE_VERBOSE_GRADLE_API_BY_DEFAULT);
    }

    public GradleExecutionSettings(@Nullable String gradleHome, @Nullable String serviceDirectory, @NotNull DistributionType distributionType, @Nullable String daemonVmOptions, boolean isOfflineWork) {
        this.myGradleHome = gradleHome;
        this.myServiceDirectory = serviceDirectory;
        this.myDistributionType = distributionType;
        if (daemonVmOptions != null) {
            this.withVmOptions(ParametersListUtil.parse((String)daemonVmOptions));
        }
        this.myIsOfflineWork = isOfflineWork;
        this.setVerboseProcessing(USE_VERBOSE_GRADLE_API_BY_DEFAULT);
    }

    public void setIdeProjectPath(@Nullable String ideProjectPath) {
        this.myIdeProjectPath = ideProjectPath;
    }

    @Nullable
    public String getIdeProjectPath() {
        return this.myIdeProjectPath;
    }

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    @Nullable
    public String getServiceDirectory() {
        return this.myServiceDirectory;
    }

    @Nullable
    public String getJavaHome() {
        return this.myJavaHome;
    }

    public void setJavaHome(@Nullable String javaHome) {
        this.myJavaHome = javaHome;
    }

    public boolean isOfflineWork() {
        return this.myIsOfflineWork;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean resolveModulePerSourceSet) {
        this.resolveModulePerSourceSet = resolveModulePerSourceSet;
    }

    public boolean isUseQualifiedModuleNames() {
        return this.useQualifiedModuleNames;
    }

    public void setUseQualifiedModuleNames(boolean useQualifiedModuleNames) {
        this.useQualifiedModuleNames = useQualifiedModuleNames;
    }

    public boolean isDelegatedBuild() {
        return this.delegatedBuild;
    }

    public void setDelegatedBuild(boolean delegatedBuild) {
        this.delegatedBuild = delegatedBuild;
    }

    @NotNull
    public List<ClassHolder<? extends GradleProjectResolverExtension>> getResolverExtensions() {
        return this.myResolverExtensions;
    }

    public void addResolverExtensionClass(@NotNull ClassHolder<? extends GradleProjectResolverExtension> holder) {
        this.myResolverExtensions.add(holder);
    }

    @Deprecated
    @Nullable
    public String getDaemonVmOptions() {
        return ParametersListUtil.join((List)this.getJvmArguments());
    }

    @Nullable
    public String getWrapperPropertyFile() {
        return this.wrapperPropertyFile;
    }

    public void setWrapperPropertyFile(@Nullable String wrapperPropertyFile) {
        this.wrapperPropertyFile = wrapperPropertyFile;
    }

    @NotNull
    public DistributionType getDistributionType() {
        return this.myDistributionType;
    }

    @NotNull
    public GradleExecutionWorkspace getExecutionWorkspace() {
        return this.myExecutionWorkspace;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myGradleHome != null ? this.myGradleHome.hashCode() : 0);
        result = 31 * result + (this.myServiceDirectory != null ? this.myServiceDirectory.hashCode() : 0);
        result = 31 * result + this.myDistributionType.hashCode();
        result = 31 * result + (this.myJavaHome != null ? this.myJavaHome.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GradleExecutionSettings that = (GradleExecutionSettings)((Object)o);
        if (this.myDistributionType != that.myDistributionType) {
            return false;
        }
        if (this.myGradleHome != null ? !this.myGradleHome.equals(that.myGradleHome) : that.myGradleHome != null) {
            return false;
        }
        if (this.myJavaHome != null ? !this.myJavaHome.equals(that.myJavaHome) : that.myJavaHome != null) {
            return false;
        }
        return !(this.myServiceDirectory != null ? !this.myServiceDirectory.equals(that.myServiceDirectory) : that.myServiceDirectory != null);
    }

    public String toString() {
        return "home: " + this.myGradleHome + ", distributionType: " + (Object)((Object)this.myDistributionType);
    }
}

