/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.List;
import java.util.Optional;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.TestRunner;

public class GradleProjectSettings
extends ExternalProjectSettings {
    @Nullable
    private String myGradleHome;
    @Nullable
    private String myGradleJvm = "#USE_PROJECT_JDK";
    @Nullable
    private DistributionType distributionType;
    private boolean disableWrapperSourceDistributionNotification;
    private boolean resolveModulePerSourceSet = ExternalSystemApiUtil.isJavaCompatibleIde();
    private boolean resolveExternalAnnotations;
    @Nullable
    private CompositeBuild myCompositeBuild;
    private ThreeState storeProjectFilesExternally = ThreeState.NO;
    @NotNull
    private ThreeState delegatedBuild = ThreeState.UNSURE;
    @Nullable
    private TestRunner testRunner;

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    public void setGradleHome(@Nullable String gradleHome) {
        this.myGradleHome = gradleHome;
    }

    @Nullable
    public String getGradleJvm() {
        return this.myGradleJvm;
    }

    public void setGradleJvm(@Nullable String gradleJvm) {
        this.myGradleJvm = gradleJvm;
    }

    @Nullable
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(@Nullable DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public boolean isDisableWrapperSourceDistributionNotification() {
        return this.disableWrapperSourceDistributionNotification;
    }

    public void setDisableWrapperSourceDistributionNotification(boolean disableWrapperSourceDistributionNotification) {
        this.disableWrapperSourceDistributionNotification = disableWrapperSourceDistributionNotification;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean useIdeModulePerSourceSet) {
        this.resolveModulePerSourceSet = useIdeModulePerSourceSet;
    }

    public boolean isResolveExternalAnnotations() {
        return this.resolveExternalAnnotations;
    }

    public void setResolveExternalAnnotations(boolean resolveExternalAnnotations) {
        this.resolveExternalAnnotations = resolveExternalAnnotations;
    }

    @OptionTag(tag="compositeConfiguration", nameAttribute="")
    @Nullable
    public CompositeBuild getCompositeBuild() {
        return this.myCompositeBuild;
    }

    public void setCompositeBuild(@Nullable CompositeBuild compositeBuild) {
        this.myCompositeBuild = compositeBuild;
    }

    @NotNull
    public GradleProjectSettings clone() {
        GradleProjectSettings result = new GradleProjectSettings();
        this.copyTo(result);
        result.myGradleHome = this.myGradleHome;
        result.myGradleJvm = this.myGradleJvm;
        result.distributionType = this.distributionType;
        result.disableWrapperSourceDistributionNotification = this.disableWrapperSourceDistributionNotification;
        result.resolveModulePerSourceSet = this.resolveModulePerSourceSet;
        result.resolveExternalAnnotations = this.resolveExternalAnnotations;
        result.myCompositeBuild = this.myCompositeBuild != null ? this.myCompositeBuild.copy() : null;
        return result;
    }

    @Transient
    public ThreeState getStoreProjectFilesExternally() {
        return this.storeProjectFilesExternally;
    }

    public void setStoreProjectFilesExternally(@NotNull ThreeState value) {
        this.storeProjectFilesExternally = value;
    }

    @OptionTag(value="delegatedBuild", converter=ThreeStateConverter.class)
    @NotNull
    public ThreeState getDelegatedBuild() {
        return this.delegatedBuild;
    }

    public void setDelegatedBuild(@NotNull ThreeState state) {
        this.delegatedBuild = state;
    }

    @Nullable
    public TestRunner getTestRunner() {
        return this.testRunner;
    }

    public void setTestRunner(@Nullable TestRunner testRunner) {
        this.testRunner = testRunner;
    }

    @NotNull
    public GradleVersion resolveGradleVersion() {
        GradleVersion version = GradleInstallationManager.getGradleVersion(this);
        return Optional.ofNullable(version).orElseGet(GradleVersion::current);
    }

    public GradleProjectSettings withQualifiedModuleNames() {
        this.setUseQualifiedModuleNames(true);
        return this;
    }

    private static final class ThreeStateConverter
    extends Converter<ThreeState> {
        private ThreeStateConverter() {
        }

        @Nullable
        public ThreeState fromString(@NotNull String value) {
            if (StringUtil.isEmpty((String)value)) {
                return ThreeState.UNSURE;
            }
            return ThreeState.fromBoolean((boolean)Boolean.valueOf(value));
        }

        @Nullable
        public String toString(@NotNull ThreeState value) {
            if (value == ThreeState.UNSURE) {
                return null;
            }
            return String.valueOf(value.toBoolean());
        }
    }

    @Tag(value="compositeBuild")
    public static class CompositeBuild {
        @Nullable
        private CompositeDefinitionSource myCompositeDefinitionSource;
        private List<BuildParticipant> myCompositeParticipants = new SmartList();

        @Attribute
        @Nullable
        public CompositeDefinitionSource getCompositeDefinitionSource() {
            return this.myCompositeDefinitionSource;
        }

        public void setCompositeDefinitionSource(@Nullable CompositeDefinitionSource compositeDefinitionSource) {
            this.myCompositeDefinitionSource = compositeDefinitionSource;
        }

        @XCollection(propertyElementName="builds", elementName="build")
        @NotNull
        public List<BuildParticipant> getCompositeParticipants() {
            return this.myCompositeParticipants;
        }

        public void setCompositeParticipants(List<BuildParticipant> compositeParticipants) {
            this.myCompositeParticipants = compositeParticipants == null ? new SmartList() : ContainerUtil.newArrayList(compositeParticipants);
        }

        @NotNull
        public CompositeBuild copy() {
            CompositeBuild result = new CompositeBuild();
            result.myCompositeParticipants = ContainerUtil.newArrayList();
            for (BuildParticipant participant : this.myCompositeParticipants) {
                result.myCompositeParticipants.add(participant.copy());
            }
            result.myCompositeDefinitionSource = this.myCompositeDefinitionSource;
            return result;
        }
    }
}

