/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.DelegatingGradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.service.settings.GradleSettingsService;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;

@State(name="GradleSettings", storages={@Storage(value="gradle.xml")})
public class GradleSettings
extends AbstractExternalSystemSettings<GradleSettings, GradleProjectSettings, GradleSettingsListener>
implements PersistentStateComponent<MyState> {
    private final GradleSystemSettings mySystemSettings = GradleSystemSettings.getInstance();

    public GradleSettings(@NotNull Project project) {
        super(GradleSettingsListener.TOPIC, project);
    }

    @NotNull
    public static GradleSettings getInstance(@NotNull Project project) {
        return (GradleSettings)((Object)ServiceManager.getService((Project)project, GradleSettings.class));
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<GradleProjectSettings> listener) {
        this.getProject().getMessageBus().connect((Disposable)this.getProject()).subscribe(GradleSettingsListener.TOPIC, (Object)new DelegatingGradleSettingsListenerAdapter(listener));
    }

    protected void copyExtraSettingsFrom(@NotNull GradleSettings settings) {
    }

    @Nullable
    public MyState getState() {
        MyState state = new MyState();
        this.fillState(state);
        return state;
    }

    public void loadState(@NotNull MyState state) {
        super.loadState((AbstractExternalSystemSettings.State)state);
    }

    @Nullable
    public String getServiceDirectoryPath() {
        return this.mySystemSettings.getServiceDirectoryPath();
    }

    public void setServiceDirectoryPath(@Nullable String newPath) {
        String myServiceDirectoryPath = this.mySystemSettings.getServiceDirectoryPath();
        if (!Comparing.equal((String)myServiceDirectoryPath, (String)newPath)) {
            this.mySystemSettings.setServiceDirectoryPath(newPath);
            ((GradleSettingsListener)this.getPublisher()).onServiceDirectoryPathChange(myServiceDirectoryPath, newPath);
        }
    }

    @Nullable
    public String getGradleVmOptions() {
        return this.mySystemSettings.getGradleVmOptions();
    }

    public void setGradleVmOptions(@Nullable String gradleVmOptions) {
        String myGradleVmOptions = this.mySystemSettings.getGradleVmOptions();
        if (!Comparing.equal((String)myGradleVmOptions, (String)gradleVmOptions)) {
            this.mySystemSettings.setGradleVmOptions(gradleVmOptions);
            ((GradleSettingsListener)this.getPublisher()).onGradleVmOptionsChange(myGradleVmOptions, gradleVmOptions);
        }
    }

    public boolean isOfflineWork() {
        return this.mySystemSettings.isOfflineWork();
    }

    public void setOfflineWork(boolean isOfflineWork) {
        this.mySystemSettings.setOfflineWork(isOfflineWork);
    }

    protected void checkSettings(@NotNull GradleProjectSettings old, @NotNull GradleProjectSettings current) {
        if (!Comparing.equal((String)old.getGradleHome(), (String)current.getGradleHome())) {
            ((GradleSettingsListener)this.getPublisher()).onGradleHomeChange(old.getGradleHome(), current.getGradleHome(), current.getExternalProjectPath());
        }
        if (old.getDistributionType() != current.getDistributionType()) {
            ((GradleSettingsListener)this.getPublisher()).onGradleDistributionTypeChange(current.getDistributionType(), current.getExternalProjectPath());
        }
        if (old.isResolveModulePerSourceSet() != current.isResolveModulePerSourceSet()) {
            ExternalProjectsManager.getInstance((Project)this.getProject()).getExternalProjectsWatcher().markDirty(current.getExternalProjectPath());
        }
        ThreeState storeProjectFilesExternally = current.getStoreProjectFilesExternally();
        if (old.getStoreProjectFilesExternally() != storeProjectFilesExternally) {
            ExternalProjectsManagerImpl.getInstance((Project)this.getProject()).setStoreExternally(storeProjectFilesExternally != ThreeState.NO);
        }
        if (!Comparing.equal((Object)old.getDelegatedBuild(), (Object)current.getDelegatedBuild())) {
            boolean delegatedBuild = GradleSettingsService.getInstance(this.getProject()).isDelegatedBuildEnabled(current.getExternalProjectPath());
            ((GradleSettingsListener)this.getPublisher()).onBuildDelegationChange(delegatedBuild, current.getExternalProjectPath());
        }
        if (!Comparing.equal((Object)((Object)old.getTestRunner()), (Object)((Object)current.getTestRunner()))) {
            TestRunner testRunner = GradleSettingsService.getInstance(this.getProject()).getTestRunner(current.getExternalProjectPath());
            ((GradleSettingsListener)this.getPublisher()).onTestRunnerChange(testRunner, current.getExternalProjectPath());
        }
    }

    @NotNull
    public Collection<GradleProjectSettings> getLinkedProjectsSettings() {
        Collection settings = super.getLinkedProjectsSettings();
        boolean isStoredExternally = ExternalStorageConfigurationManager.getInstance((Project)this.getProject()).isEnabled();
        for (GradleProjectSettings setting : settings) {
            setting.setStoreProjectFilesExternally(ThreeState.fromBoolean((boolean)isStoredExternally));
        }
        return settings;
    }

    public static class MyState
    implements AbstractExternalSystemSettings.State<GradleProjectSettings> {
        private final Set<GradleProjectSettings> myProjectSettings = ContainerUtilRt.newTreeSet();

        @XCollection(elementTypes={GradleProjectSettings.class})
        public Set<GradleProjectSettings> getLinkedExternalProjectsSettings() {
            return this.myProjectSettings;
        }

        public void setLinkedExternalProjectsSettings(Set<GradleProjectSettings> settings) {
            if (settings != null) {
                this.myProjectSettings.addAll(settings);
            }
        }
    }
}

