/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.settings.GradleSettingsService;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "anonymizeGradleVersion", "", "version", "Lorg/gradle/util/GradleVersion;", "getGroupId", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getYesNoUsage", "key", "value", "", "intellij.gradle.common"})
public final class GradleSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.gradle.state";
    }

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Collection<GradleProjectSettings> projectsSettings = gradleSettings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set usages = new LinkedHashSet();
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"hasGradleProject", (boolean)true));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"offlineWork", (boolean)gradleSettings.isOfflineWork()));
        CharSequence charSequence = gradleSettings.getServiceDirectoryPath();
        String string = "hasCustomServiceDirectoryPath";
        Set set = usages;
        boolean bl = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        set.add(StatisticsUtilKt.getBooleanUsage((String)string, (!bl ? 1 : 0) != 0));
        charSequence = gradleSettings.getGradleVmOptions();
        string = "hasCustomGradleVmOptions";
        set = usages;
        bl = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        set.add(StatisticsUtilKt.getBooleanUsage((String)string, (!bl ? 1 : 0) != 0));
        usages.add(StatisticsUtilKt.getBooleanUsage((String)"showSelectiveImportDialogOnInitialImport", (boolean)gradleSettings.showSelectiveImportDialogOnInitialImport()));
        GradleSettingsService settingsService = GradleSettingsService.getInstance(project);
        for (GradleProjectSettings setting : gradleSettings.getLinkedProjectsSettings()) {
            String projectPath = setting.getExternalProjectPath();
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"isCreateEmptyContentRootDirectories", (boolean)setting.isCreateEmptyContentRootDirectories()));
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"isUseQualifiedModuleNames", (boolean)setting.isUseQualifiedModuleNames()));
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"createModulePerSourceSet", (boolean)setting.isResolveModulePerSourceSet()));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"storeProjectFilesExternally", (Enum)((Enum)setting.getStoreProjectFilesExternally())));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"distributionType", (Enum)setting.getDistributionType()));
            usages.add(this.getYesNoUsage("isCompositeBuilds", setting.getCompositeBuild() != null));
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"disableWrapperSourceDistributionNotification", (boolean)setting.isDisableWrapperSourceDistributionNotification()));
            usages.add(ExternalSystemUsagesCollector.Companion.getJRETypeUsage("gradleJvmType", setting.getGradleJvm()));
            usages.add(ExternalSystemUsagesCollector.Companion.getJREVersionUsage(project, "gradleJvmVersion", setting.getGradleJvm()));
            GradleVersion gradleVersion = setting.resolveGradleVersion();
            if (gradleVersion.isSnapshot()) {
                usages.add(new UsageDescriptor("gradleVersion." + this.anonymizeGradleVersion(gradleVersion.getBaseVersion()) + ".SNAPSHOT", 1));
            } else {
                usages.add(new UsageDescriptor("gradleVersion." + this.anonymizeGradleVersion(gradleVersion), 1));
            }
            usages.add(StatisticsUtilKt.getBooleanUsage((String)"delegateBuildRun", (boolean)settingsService.isDelegatedBuildEnabled(projectPath)));
            usages.add(StatisticsUtilKt.getEnumUsage((String)"preferredTestRunner", (Enum)settingsService.getTestRunner(projectPath)));
        }
        return usages;
    }

    private final String anonymizeGradleVersion(GradleVersion version) {
        Object object = Version.parseVersion((String)version.getVersion());
        if (object == null || (object = object.toCompactString()) == null) {
            object = "unknown";
        }
        return object;
    }

    private final UsageDescriptor getYesNoUsage(String key, boolean value) {
        return new UsageDescriptor(key + (value ? ".yes" : ".no"), 1);
    }
}

