/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.Function;
import gnu.trove.THashMap;
import gnu.trove.TObjectByteHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.FileObjectKindFilter;
import org.jetbrains.jps.javac.FileOperations;
import org.jetbrains.jps.javac.JpsJavacFileManager;
import org.jetbrains.jps.javac.ZipFileObject;

class DefaultFileOperations
implements FileOperations {
    private static final File[] NULL_FILE_ARRAY = new File[0];
    private static final FileOperations.Archive NULL_ARCHIVE = new FileOperations.Archive(){

        @Override
        public Iterable<JavaFileObject> list(String relPath, Set<JavaFileObject.Kind> kinds, boolean recurse) {
            return Collections.emptyList();
        }

        @Override
        public void close() {
        }
    };
    private static final byte UNKNOWN = 0;
    private static final byte NO = 1;
    private static final byte YES = 2;
    private final Map<File, File[]> myDirectoryCache = new THashMap();
    private final Map<File, FileOperations.Archive> myArchiveCache = new THashMap();
    private final TObjectByteHashMap<File> myIsFile = new TObjectByteHashMap();

    DefaultFileOperations() {
    }

    @Override
    @NotNull
    public Iterable<File> listFiles(File file, boolean recursively) {
        File[] files = this.listChildren(file);
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        if (recursively) {
            ArrayList<File> result = new ArrayList<File>();
            for (File f : files) {
                this.listRecursively(f, result);
            }
            return result;
        }
        return Arrays.asList(files);
    }

    @Override
    public boolean isFile(File file) {
        byte cachedIsFile = this.myIsFile.get((Object)file);
        if (cachedIsFile == 0) {
            cachedIsFile = file.isFile() ? (byte)2 : 1;
            this.myIsFile.put((Object)file, cachedIsFile);
        }
        return cachedIsFile == 2;
    }

    @Override
    public void clearCaches(@Nullable File file) {
        if (file != null) {
            FileOperations.Archive arch;
            if (this.myDirectoryCache.remove(file) == null && (arch = this.myArchiveCache.remove(file)) != null) {
                try {
                    arch.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            this.myDirectoryCache.clear();
            this.myIsFile.clear();
            Map<File, FileOperations.Archive> archCache = this.myArchiveCache;
            for (Map.Entry<File, FileOperations.Archive> entry : archCache.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (Throwable throwable) {}
            }
            archCache.clear();
        }
    }

    @Override
    @Nullable
    public FileOperations.Archive lookupArchive(File file) {
        FileOperations.Archive arch = this.myArchiveCache.get(file);
        return arch == NULL_ARCHIVE ? null : arch;
    }

    @Override
    public FileOperations.Archive openArchive(File root, String contentEncoding) throws IOException {
        FileOperations.Archive arch = this.myArchiveCache.get(root);
        if (arch != null) {
            return arch == NULL_ARCHIVE ? null : arch;
        }
        try {
            arch = new ZipArchive(root, contentEncoding);
            this.myArchiveCache.put(root, arch);
            return arch;
        }
        catch (IOException e) {
            if (this.isJarOrZip(root)) {
                throw e;
            }
            this.myArchiveCache.put(root, NULL_ARCHIVE);
            return null;
        }
    }

    private boolean isJarOrZip(File root) {
        if (!this.isFile(root)) {
            return false;
        }
        String name = root.getName();
        return StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".jar") || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".zip");
    }

    private void listRecursively(File fileOrDir, List<File> result) {
        File[] files = this.listChildren(fileOrDir);
        if (files != null) {
            for (File file : files) {
                this.listRecursively(file, result);
            }
        } else {
            result.add(fileOrDir);
        }
    }

    private File[] listChildren(File file) {
        File[] cached = this.myDirectoryCache.get(file);
        if (cached == null) {
            cached = file.listFiles();
            this.myDirectoryCache.put(file, cached == null ? NULL_FILE_ARRAY : cached);
        }
        return cached == NULL_FILE_ARRAY ? null : cached;
    }

    private static class ZipArchive
    implements FileOperations.Archive {
        private final ZipFile myZip;
        private final Map<String, Collection<ZipEntry>> myPaths = new THashMap();
        private final Function<ZipEntry, JavaFileObject> myToFileObjectConverter;
        private static final FileObjectKindFilter<ZipEntry> ourEntryFilter = new FileObjectKindFilter<ZipEntry>(new Function<ZipEntry, String>(){

            public String fun(ZipEntry zipEntry) {
                return zipEntry.getName();
            }
        });

        ZipArchive(final File root, final String encodingName) throws IOException {
            this.myZip = new ZipFile(root, 1);
            Enumeration<? extends ZipEntry> entries = this.myZip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String parent = ZipArchive.getParentPath(entry.getName());
                Collection<ZipEntry> children = this.myPaths.get(parent);
                if (children == null) {
                    children = new ArrayList<ZipEntry>();
                    this.myPaths.put(parent, children);
                }
                children.add(entry);
            }
            this.myToFileObjectConverter = new Function<ZipEntry, JavaFileObject>(){

                public JavaFileObject fun(ZipEntry zipEntry) {
                    return new ZipFileObject(root, ZipArchive.this.myZip, zipEntry, encodingName);
                }
            };
        }

        @Override
        @NotNull
        public Iterable<JavaFileObject> list(String relPath, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            Collection<ZipEntry> entries = this.myPaths.get(relPath);
            if (entries == null || entries.isEmpty()) {
                return Collections.emptyList();
            }
            if (recurse) {
                ArrayList allChildren = new ArrayList();
                for (Map.Entry<String, Collection<ZipEntry>> e : this.myPaths.entrySet()) {
                    String dir = e.getKey();
                    if (relPath.isEmpty()) {
                        allChildren.add(e.getValue());
                        continue;
                    }
                    if (!dir.startsWith(relPath) || dir.length() != relPath.length() && dir.charAt(relPath.length()) != '/') continue;
                    allChildren.add(e.getValue());
                }
                return JpsJavacFileManager.convert(JpsJavacFileManager.filter(JpsJavacFileManager.merge(allChildren), ourEntryFilter.getFor(kinds)), this.myToFileObjectConverter);
            }
            return JpsJavacFileManager.convert(JpsJavacFileManager.filter(entries, ourEntryFilter.getFor(kinds)), this.myToFileObjectConverter);
        }

        @Override
        public void close() throws IOException {
            this.myPaths.clear();
            this.myZip.close();
        }

        private static String getParentPath(String path) {
            int idx = path.lastIndexOf(47);
            if (idx == path.length() - 1) {
                idx = path.lastIndexOf(47, idx - 1);
            }
            if (idx < 0) {
                return "";
            }
            return path.substring(0, idx);
        }
    }
}

