/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.PathUtils;
import org.jetbrains.jps.javac.JpsFileObject;

public class InputFileObject
extends JpsFileObject {
    private final File myFile;
    private final String myEncoding;
    private Reference<File> myAbsFileRef;

    InputFileObject(File f, String encoding) {
        super(InputFileObject.createUri(f), InputFileObject.findKind(f.getName()));
        this.myFile = f;
        this.myEncoding = encoding;
    }

    @NotNull
    private static URI createUri(File f) {
        try {
            return PathUtils.toURI(f.getPath());
        }
        catch (Throwable e) {
            return f.toURI().normalize();
        }
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.myFile);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return this.myFile.lastModified();
    }

    @Override
    public boolean delete() {
        return this.myFile.delete();
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> path, boolean caseSensitiveFS) {
        String fPath = this.myFile.getPath();
        for (File file : path) {
            int separatorIdx;
            String dirPath = file.getPath();
            if (dirPath.length() == 0) {
                dirPath = System.getProperty("user.dir");
            }
            if (!fPath.regionMatches(!caseSensitiveFS, 0, dirPath, 0, dirPath.length())) continue;
            int pathLength = fPath.length();
            boolean endsWithSeparator = dirPath.endsWith(File.separator);
            if (!endsWithSeparator && (pathLength <= (separatorIdx = dirPath.length()) || fPath.charAt(separatorIdx) != File.separatorChar)) continue;
            int startIndex = endsWithSeparator ? dirPath.length() : dirPath.length() + 1;
            int endIndex = fPath.lastIndexOf(46);
            if (endIndex <= startIndex) {
                endIndex = fPath.length();
            }
            int length = endIndex - startIndex;
            StringBuilder buf = new StringBuilder(length).append(fPath, startIndex, endIndex);
            for (int idx = 0; idx < length; ++idx) {
                if (buf.charAt(idx) != File.separatorChar) continue;
                buf.setCharAt(idx, '.');
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(@NotNull String cn, JavaFileObject.Kind kind) {
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String n = cn + kind.extension;
        String name = this.myFile.getName();
        if (name.equals(n)) {
            return true;
        }
        if (name.equalsIgnoreCase(n)) {
            try {
                return n.equals(this.myFile.getCanonicalFile().getName());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InputFileObject)) {
            return false;
        }
        InputFileObject o = (InputFileObject)other;
        return this.getAbsoluteFile().equals(o.getAbsoluteFile());
    }

    @Override
    public int hashCode() {
        return this.getAbsoluteFile().hashCode();
    }

    private File getAbsoluteFile() {
        File absFile;
        File file = absFile = this.myAbsFileRef == null ? null : this.myAbsFileRef.get();
        if (absFile == null) {
            absFile = this.myFile.getAbsoluteFile();
            this.myAbsFileRef = new SoftReference<File>(absFile);
        }
        return absFile;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return InputFileObject.loadCharContent(this.myFile, this.myEncoding);
    }
}

