/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.PathUtils;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.javac.CompilationCanceledException;
import org.jetbrains.jps.javac.DefaultFileOperations;
import org.jetbrains.jps.javac.FileObjectKindFilter;
import org.jetbrains.jps.javac.FileOperations;
import org.jetbrains.jps.javac.InputFileObject;
import org.jetbrains.jps.javac.JpsFileObject;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.javac.TransformableJavaFileObject;

public class JpsJavacFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager>
implements StandardJavaFileManager {
    private static final String _OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final boolean isWindows = _OS_NAME.startsWith("windows");
    private static final boolean isOS2 = _OS_NAME.startsWith("os/2") || _OS_NAME.startsWith("os2");
    private static final boolean isMac = _OS_NAME.startsWith("mac");
    private static final boolean isFileSystemCaseSensitive = !isWindows && !isOS2 && !isMac;
    private static final Set<JavaFileObject.Kind> ourSourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    private static final Set<StandardLocation> ourFSLocations = EnumSet.of(StandardLocation.PLATFORM_CLASS_PATH, new StandardLocation[]{StandardLocation.CLASS_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.SOURCE_OUTPUT, StandardLocation.SOURCE_PATH, StandardLocation.ANNOTATION_PROCESSOR_PATH});
    private static final FileObjectKindFilter<File> ourKindFilter = new FileObjectKindFilter<File>(new Function<File, String>(){

        public String fun(File file) {
            return file.getName();
        }
    });
    private final Context myContext;
    private final boolean myJavacBefore9;
    private final Collection<JavaSourceTransformer> mySourceTransformers;
    private final FileOperations myFileOperations = new DefaultFileOperations();
    private final Function<File, JavaFileObject> myFileToInputFileObjectConverter = new Function<File, JavaFileObject>(){

        public JavaFileObject fun(File file) {
            return new InputFileObject(file, JpsJavacFileManager.this.myEncodingName);
        }
    };
    private static final Function<String, File> ourPathToFileConverter = new Function<String, File>(){

        public File fun(String s) {
            return new File(s);
        }
    };
    private Map<File, Set<File>> myOutputsMap = Collections.emptyMap();
    @Nullable
    private String myEncodingName;
    private int myChecksCounter = 0;

    public JpsJavacFileManager(final Context context, boolean javacBefore9, Collection<JavaSourceTransformer> transformers) {
        super(context.getStandardFileManager());
        this.myJavacBefore9 = javacBefore9;
        this.mySourceTransformers = transformers;
        this.myContext = new Context(){

            @Override
            public boolean isCanceled() {
                return context.isCanceled();
            }

            @Override
            @NotNull
            public StandardJavaFileManager getStandardFileManager() {
                return context.getStandardFileManager();
            }

            @Override
            public void consumeOutputFile(@NotNull OutputFileObject obj) {
                try {
                    context.consumeOutputFile(obj);
                }
                finally {
                    JpsJavacFileManager.this.onOutputFileGenerated(obj.getFile());
                }
            }

            @Override
            public void reportMessage(Diagnostic.Kind kind, String message) {
                context.reportMessage(kind, message);
            }
        };
    }

    private Iterable<? extends JavaFileObject> wrapJavaFileObjects(Iterable<? extends JavaFileObject> originalObjects) {
        return this.mySourceTransformers.isEmpty() ? originalObjects : JpsJavacFileManager.convert(originalObjects, new Function<JavaFileObject, JavaFileObject>(){

            public JavaFileObject fun(JavaFileObject fo) {
                return JavaFileObject.Kind.SOURCE.equals((Object)fo.getKind()) ? new TransformableJavaFileObject(fo, JpsJavacFileManager.this.mySourceTransformers) : fo;
            }
        });
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        this.checkCanceled();
        if (!ourSourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        JavaFileObject fo = super.getJavaFileForInput(location, className, kind);
        if (fo == null && !"module-info".equals(className)) {
            throw new FileNotFoundException("Java resource does not exist : " + location + '/' + (Object)((Object)kind) + '/' + className);
        }
        return this.mySourceTransformers.isEmpty() ? fo : new TransformableJavaFileObject(fo, this.mySourceTransformers);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (kind != JavaFileObject.Kind.SOURCE && kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, kind, JpsJavacFileManager.externalizeFileName(className, kind), className, sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        StringBuilder name = new StringBuilder();
        if (packageName.isEmpty()) {
            name.append(relativeName);
        } else {
            name.append(JpsJavacFileManager.externalizeFileName(packageName)).append(File.separatorChar).append(relativeName);
        }
        String fileName = name.toString();
        return this.getFileForOutput(location, JpsJavacFileManager.getKind(fileName), fileName, null, sibling);
    }

    private OutputFileObject getFileForOutput(JavaFileManager.Location location, JavaFileObject.Kind kind, String fileName, @Nullable String className, FileObject sibling) throws IOException {
        JavaFileObject javaFileObject;
        this.checkCanceled();
        JavaFileObject src = null;
        if (sibling instanceof JavaFileObject && (javaFileObject = (JavaFileObject)sibling).getKind() == JavaFileObject.Kind.SOURCE) {
            src = javaFileObject;
        }
        File dir = this.getSingleOutputDirectory(location, src);
        if (location == StandardLocation.CLASS_OUTPUT) {
            if (dir == null) {
                throw new IOException("Output directory is not specified");
            }
        } else if (location == StandardLocation.SOURCE_OUTPUT && dir == null && (dir = this.getSingleOutputDirectory(StandardLocation.CLASS_OUTPUT, src)) == null) {
            throw new IOException("Neither class output directory nor source output are specified");
        }
        File file = dir == null ? new File(fileName).getAbsoluteFile() : new File(dir, fileName);
        return new OutputFileObject(this.myContext, dir, fileName, file, kind, className, src != null ? src.toUri() : null, this.myEncodingName);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : path) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), this.myContext.getStandardFileManager().getClass().getClassLoader());
    }

    private File getSingleOutputDirectory(JavaFileManager.Location loc, JavaFileObject sourceFile) {
        Iterator<? extends File> it;
        File outputDir;
        if (loc == StandardLocation.CLASS_OUTPUT && this.myOutputsMap.size() > 1 && sourceFile != null && (outputDir = this.findOutputDir(PathUtils.convertToFile(sourceFile.toUri()))) != null) {
            return outputDir;
        }
        Iterable<? extends File> location = this.getStdManager().getLocation(loc);
        if (location != null && (it = location.iterator()).hasNext()) {
            return it.next();
        }
        return null;
    }

    private File findOutputDir(File src) {
        File file = FileUtilRt.getParentFile((File)src);
        while (file != null) {
            for (Map.Entry<File, Set<File>> entry : this.myOutputsMap.entrySet()) {
                if (!entry.getValue().contains(file)) continue;
                return entry.getKey();
            }
            file = FileUtilRt.getParentFile((File)file);
        }
        return null;
    }

    private void checkCanceled() {
        int counter;
        this.myChecksCounter = counter = (this.myChecksCounter + 1) % 10;
        if (counter == 0 && this.myContext.isCanceled()) {
            throw new CompilationCanceledException();
        }
    }

    private static JavaFileObject.Kind getKind(String name) {
        if (name.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (name.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (name.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    private static String externalizeFileName(CharSequence cs, JavaFileObject.Kind kind) {
        return JpsJavacFileManager.externalizeFileName(cs) + kind.extension;
    }

    private static String externalizeFileName(CharSequence name) {
        return name.toString().replace('.', File.separatorChar);
    }

    public final Context getContext() {
        return this.myContext;
    }

    @NotNull
    protected StandardJavaFileManager getStdManager() {
        return (StandardJavaFileManager)this.fileManager;
    }

    @Override
    public boolean handleOption(String current, final Iterator<String> remaining) {
        if ("-encoding".equalsIgnoreCase(current) && remaining.hasNext()) {
            String encoding;
            this.myEncodingName = encoding = remaining.next();
            return super.handleOption(current, new Iterator<String>(){
                private boolean encodingConsumed = false;

                @Override
                public boolean hasNext() {
                    return !this.encodingConsumed || remaining.hasNext();
                }

                @Override
                public String next() {
                    if (!this.encodingConsumed) {
                        this.encodingConsumed = true;
                        return encoding;
                    }
                    return (String)remaining.next();
                }

                @Override
                public void remove() {
                    if (this.encodingConsumed) {
                        remaining.remove();
                    }
                }
            });
        }
        return super.handleOption(current, remaining);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        String inferred;
        JavaFileObject _fo = JpsJavacFileManager.unwrapFileObject(file);
        if (_fo instanceof JpsFileObject && (inferred = ((JpsFileObject)_fo).inferBinaryName(this.getLocation(location), isFileSystemCaseSensitive)) != null) {
            return inferred;
        }
        return super.inferBinaryName(location, _fo);
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
        this.getStdManager().setLocation(location, path);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        return this.wrapJavaFileObjects(JpsJavacFileManager.convert(files, this.myFileToInputFileObjectConverter));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(files));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        return this.getJavaFileObjectsFromFiles(JpsJavacFileManager.convert(names, ourPathToFileConverter));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(names));
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        return this.getStdManager().getLocation(location);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        FileObject _a = JpsJavacFileManager.unwrapFileObject(a);
        FileObject _b = JpsJavacFileManager.unwrapFileObject(b);
        if (_a instanceof JpsFileObject || _b instanceof JpsFileObject) {
            return _a.equals(_b);
        }
        return super.isSameFile(_a, _b);
    }

    private static FileObject unwrapFileObject(FileObject a) {
        return a instanceof TransformableJavaFileObject ? ((TransformableJavaFileObject)a).getOriginal() : a;
    }

    private static JavaFileObject unwrapFileObject(JavaFileObject a) {
        return a instanceof TransformableJavaFileObject ? ((TransformableJavaFileObject)a).getOriginal() : a;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        this.checkCanceled();
        FileObject fo = super.getFileForInput(location, packageName, relativeName);
        if (fo == null) {
            throw new FileNotFoundException("Resource does not exist : " + location + '/' + packageName + '/' + relativeName);
        }
        return fo;
    }

    private boolean isFileSystemLocation(JavaFileManager.Location location) {
        try {
            StandardLocation loc = StandardLocation.valueOf(location.getName());
            if (loc == StandardLocation.PLATFORM_CLASS_PATH) {
                return this.myJavacBefore9;
            }
            return ourFSLocations.contains(loc);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> allFiles;
        try {
            if (this.isFileSystemLocation(location)) {
                Iterable<? extends File> locationRoots = this.getLocation(location);
                if (locationRoots == null) {
                    return Collections.emptyList();
                }
                ArrayList result = new ArrayList();
                for (File file : locationRoots) {
                    FileOperations.Archive archive = this.myFileOperations.lookupArchive(file);
                    boolean isFile = archive != null ? true : this.myFileOperations.isFile(file);
                    if (isFile) {
                        try {
                            if (archive == null) {
                                archive = this.myFileOperations.openArchive(file, this.myEncodingName);
                            }
                            if (archive != null) {
                                result.add(archive.list(packageName.replace('.', '/'), kinds, recurse));
                                continue;
                            }
                            result.add(super.list(location, packageName, kinds, recurse));
                            continue;
                        }
                        catch (IOException ex) {
                            throw new IOException("Error reading file " + file + ": " + ex.getMessage(), ex);
                        }
                    }
                    File dir = new File(file, packageName.replace('.', '/'));
                    BooleanFunction<File> kindsFilter = ourKindFilter.getFor(kinds);
                    boolean acceptUnknownFiles = kinds.contains((Object)JavaFileObject.Kind.OTHER);
                    BooleanFunction<File> filter = recurse || !acceptUnknownFiles ? kindsFilter : new BooleanFunction<File>((BooleanFunction)kindsFilter, dir){
                        final /* synthetic */ BooleanFunction val$kindsFilter;
                        final /* synthetic */ File val$dir;
                        {
                            this.val$kindsFilter = booleanFunction;
                            this.val$dir = file;
                        }

                        public boolean fun(File file) {
                            return this.val$kindsFilter.fun((Object)this.val$dir) && JpsJavacFileManager.this.myFileOperations.isFile(file);
                        }
                    };
                    result.add(JpsJavacFileManager.convert(JpsJavacFileManager.filter(this.myFileOperations.listFiles(dir, recurse), filter), this.myFileToInputFileObjectConverter));
                }
                allFiles = JpsJavacFileManager.merge(result);
            } else {
                allFiles = super.list(location, packageName, kinds, recurse);
            }
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                allFiles = super.list(location, packageName, kinds, recurse);
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            allFiles = super.list(location, packageName, kinds, recurse);
        }
        return kinds.contains((Object)JavaFileObject.Kind.SOURCE) ? this.wrapJavaFileObjects(allFiles) : allFiles;
    }

    public void onOutputFileGenerated(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            this.myFileOperations.clearCaches(parent);
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myOutputsMap = Collections.emptyMap();
            this.myFileOperations.clearCaches(null);
        }
    }

    public void setOutputDirectories(Map<File, Set<File>> outputDirToSrcRoots) throws IOException {
        for (File outputDir : outputDirToSrcRoots.keySet()) {
            this.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(outputDir));
        }
        this.myOutputsMap = outputDirToSrcRoots;
    }

    public static <T> Iterable<T> merge(final Iterable<T> first, final Iterable<T> second) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                final Iterator i1 = first.iterator();
                final Iterator i2 = second.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return i1.hasNext() || i2.hasNext();
                    }

                    @Override
                    public T next() {
                        return i1.hasNext() ? i1.next() : i2.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> merge(Collection<Iterable<T>> parts) {
        if (parts.isEmpty()) {
            return Collections.emptyList();
        }
        if (parts.size() == 1) {
            return parts.iterator().next();
        }
        return JpsJavacFileManager.merge(parts);
    }

    public static <T> Iterable<T> merge(final Iterable<Iterable<T>> parts) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                final Iterator partsIterator = parts.iterator();
                return new Iterator<T>(){
                    Iterator<T> currentPart;

                    @Override
                    public boolean hasNext() {
                        return this.getCurrentPart() != null;
                    }

                    @Override
                    public T next() {
                        Iterator part = this.getCurrentPart();
                        if (part != null) {
                            return part.next();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private Iterator<T> getCurrentPart() {
                        while (this.currentPart == null || !this.currentPart.hasNext()) {
                            if (partsIterator.hasNext()) {
                                this.currentPart = ((Iterable)partsIterator.next()).iterator();
                                continue;
                            }
                            this.currentPart = null;
                            break;
                        }
                        return this.currentPart;
                    }
                };
            }
        };
    }

    public static <I, O> Iterable<O> convert(final Iterable<? extends I> from, final Function<I, ? extends O> converter) {
        return new Iterable<O>(){

            @Override
            @NotNull
            public Iterator<O> iterator() {
                final Iterator it = from.iterator();
                return new Iterator<O>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public O next() {
                        return converter.fun(it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> data, final BooleanFunction<? super T> acceptElement) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                final Iterator it = data.iterator();
                return new Iterator<T>(){
                    private T current = null;
                    private boolean isPending = false;

                    @Override
                    public boolean hasNext() {
                        if (!this.isPending) {
                            this.findNext();
                        }
                        return this.isPending;
                    }

                    @Override
                    public T next() {
                        try {
                            if (!this.isPending) {
                                this.findNext();
                                if (!this.isPending) {
                                    throw new NoSuchElementException();
                                }
                            }
                            Object t = this.current;
                            return t;
                        }
                        finally {
                            this.current = null;
                            this.isPending = false;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void findNext() {
                        this.isPending = false;
                        this.current = null;
                        while (it.hasNext()) {
                            Object next = it.next();
                            if (!acceptElement.fun(next)) continue;
                            this.isPending = true;
                            this.current = next;
                            break;
                        }
                    }
                };
            }
        };
    }

    public static interface Context {
        public boolean isCanceled();

        @NotNull
        public StandardJavaFileManager getStandardFileManager();

        public void consumeOutputFile(@NotNull OutputFileObject var1);

        public void reportMessage(Diagnostic.Kind var1, String var2);
    }
}

