/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.PathUtils;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.JpsFileObject;
import org.jetbrains.jps.javac.JpsJavacFileManager;

public final class OutputFileObject
extends JpsFileObject {
    @Nullable
    private final JpsJavacFileManager.Context myContext;
    @Nullable
    private final File myOutputRoot;
    private final String myRelativePath;
    private final File myFile;
    @Nullable
    private final String myClassName;
    @Nullable
    private final URI mySourceUri;
    private volatile BinaryContent myContent;
    private final File mySourceFile;
    private final String myEncodingName;

    public OutputFileObject(@NotNull JpsJavacFileManager.Context context, @Nullable File outputRoot, String relativePath, @NotNull File file, @NotNull JavaFileObject.Kind kind, @Nullable String className, @Nullable URI sourceUri, @Nullable String encodingName) {
        this(context, outputRoot, relativePath, file, kind, className, sourceUri, encodingName, null);
    }

    public OutputFileObject(@Nullable JpsJavacFileManager.Context context, @Nullable File outputRoot, String relativePath, @NotNull File file, @NotNull JavaFileObject.Kind kind, @Nullable String className, @Nullable URI srcUri, @Nullable String encodingName, @Nullable BinaryContent content) {
        super(PathUtils.toURI(file.getPath()), kind);
        this.myContext = context;
        this.mySourceUri = srcUri;
        this.myContent = content;
        this.myOutputRoot = outputRoot;
        this.myRelativePath = relativePath;
        this.myFile = file;
        this.myClassName = className != null ? className.replace('/', '.') : null;
        this.mySourceFile = srcUri != null ? PathUtils.convertToFile(srcUri) : null;
        this.myEncodingName = encodingName;
    }

    @Nullable
    public File getOutputRoot() {
        return this.myOutputRoot;
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    @NotNull
    public File getFile() {
        return this.myFile;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @Nullable
    public File getSourceFile() {
        return this.mySourceFile;
    }

    @Nullable
    public URI getSourceUri() {
        return this.mySourceUri;
    }

    @Override
    @Nullable
    protected String inferBinaryName(Iterable<? extends File> path, boolean caseSensitiveFS) {
        return null;
    }

    @Override
    public ByteArrayOutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    OutputFileObject.this.myContent = new BinaryContent(this.buf, 0, this.size());
                    if (OutputFileObject.this.myContext != null) {
                        OutputFileObject.this.myContext.consumeOutputFile(OutputFileObject.this);
                    }
                }
            }
        };
    }

    @Override
    public InputStream openInputStream() throws IOException {
        BinaryContent bytes = this.myContent;
        if (bytes != null) {
            return new ByteArrayInputStream(bytes.getBuffer(), bytes.getOffset(), bytes.getLength());
        }
        return new BufferedInputStream(new FileInputStream(this.myFile));
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        BinaryContent content = this.myContent;
        String encoding = this.myEncodingName;
        if (content != null) {
            return encoding == null ? new String(content.getBuffer(), content.getOffset(), content.getLength()) : new String(content.getBuffer(), content.getOffset(), content.getLength(), encoding);
        }
        return OutputFileObject.loadCharContent(this.myFile, encoding);
    }

    @Override
    public Writer openWriter() throws IOException {
        String encoding = this.myEncodingName;
        return encoding != null ? new OutputStreamWriter((OutputStream)this.openOutputStream(), encoding) : super.openWriter();
    }

    @Nullable
    public BinaryContent getContent() {
        return this.myContent;
    }

    public void updateContent(@NotNull byte[] updatedContent) {
        this.myContent = new BinaryContent(updatedContent, 0, updatedContent.length);
    }
}

