/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javac.ast.api.JavacNameTable;

public interface JavacRef {
    public static final JavacRef[] EMPTY_ARRAY = new JavacRef[0];

    @NotNull
    public String getName();

    public Set<Modifier> getModifiers();

    @NotNull
    public String getOwnerName();

    @Nullable
    public ImportProperties getImportProperties();

    public static class JavacElementFieldImpl
    extends JavacElementRefBase
    implements JavacField {
        public JavacElementFieldImpl(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            super(element, qualifier, nameTableCache, importProps);
        }
    }

    public static class JavacElementMethodImpl
    extends JavacElementRefBase
    implements JavacMethod {
        public JavacElementMethodImpl(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            super(element, qualifier, nameTableCache, importProps);
        }

        @Override
        public byte getParamCount() {
            return (byte)((ExecutableElement)this.myOriginalElement).getParameters().size();
        }
    }

    public static class JavacElementClassImpl
    extends JavacElementRefBase
    implements JavacClass {
        public JavacElementClassImpl(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            super(element, qualifier, nameTableCache, importProps);
        }

        @Override
        @NotNull
        public String getName() {
            return this.myNameTableCache.parseBinaryName(this.myOriginalElement);
        }

        @Override
        public boolean isAnonymous() {
            return this.myNameTableCache.parseName(this.myOriginalElement.getSimpleName()).isEmpty();
        }
    }

    public static abstract class JavacElementRefBase
    implements JavacRef {
        @NotNull
        protected final Element myOriginalElement;
        @Nullable
        private final Element myQualifier;
        protected final JavacNameTable myNameTableCache;
        private final ImportProperties myImportProps;

        protected JavacElementRefBase(@NotNull Element element, @Nullable Element qualifier, JavacNameTable nameTableCache, ImportProperties importProps) {
            this.myOriginalElement = element;
            this.myQualifier = qualifier;
            this.myNameTableCache = nameTableCache;
            this.myImportProps = importProps;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myNameTableCache.parseName(this.myOriginalElement.getSimpleName());
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.myOriginalElement.getModifiers();
        }

        @Override
        @NotNull
        public String getOwnerName() {
            return this.myNameTableCache.parseBinaryName(this.myQualifier != null ? this.myQualifier : this.myOriginalElement.getEnclosingElement());
        }

        @Override
        @Nullable
        public ImportProperties getImportProperties() {
            return this.myImportProps;
        }

        @Nullable
        public static JavacElementRefBase fromElement(Element element, Element qualifier, JavacNameTable nameTableCache) {
            return JavacElementRefBase.fromElement(element, qualifier, nameTableCache, null);
        }

        @Nullable
        public static JavacElementRefBase fromElement(Element element, Element qualifier, JavacNameTable nameTableCache, @Nullable ImportProperties importProps) {
            TypeMirror type;
            if (qualifier != null && !JavacElementRefBase.isValidType(type = qualifier.asType())) {
                return null;
            }
            if (element instanceof TypeElement) {
                return new JavacElementClassImpl(element, qualifier, nameTableCache, importProps);
            }
            if (element instanceof VariableElement) {
                if (qualifier == null && !JavacElementRefBase.checkEnclosingElement(element)) {
                    return null;
                }
                return new JavacElementFieldImpl(element, qualifier, nameTableCache, importProps);
            }
            if (element instanceof ExecutableElement) {
                if (qualifier == null && !JavacElementRefBase.checkEnclosingElement(element)) {
                    return null;
                }
                return new JavacElementMethodImpl(element, qualifier, nameTableCache, importProps);
            }
            if (element == null || element.getKind() == ElementKind.OTHER || element.getKind() == ElementKind.TYPE_PARAMETER) {
                return null;
            }
            throw new AssertionError((Object)("unexpected element: " + element + " class: " + element.getClass()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavacElementRefBase base = (JavacElementRefBase)o;
            return this.myOriginalElement == base.myOriginalElement && this.myQualifier == base.myQualifier;
        }

        public int hashCode() {
            int hashCode = this.myOriginalElement.hashCode();
            if (this.myQualifier != null) {
                hashCode += this.myQualifier.hashCode();
            }
            return hashCode;
        }

        private static boolean checkEnclosingElement(Element element) {
            Element enclosingElement = element.getEnclosingElement();
            if (enclosingElement == null) {
                return false;
            }
            TypeMirror type = enclosingElement.asType();
            return JavacElementRefBase.isValidType(type);
        }

        private static boolean isValidType(TypeMirror type) {
            return type != null && type.getKind() != TypeKind.NONE && type.getKind() != TypeKind.OTHER;
        }
    }

    public static class JavacFieldImpl
    extends JavacRefBase
    implements JavacField {
        private final String myOwnerName;

        public JavacFieldImpl(String ownerName, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myOwnerName = ownerName;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            return this.myOwnerName;
        }
    }

    public static class JavacMethodImpl
    extends JavacRefBase
    implements JavacMethod {
        private final String myOwnerName;
        private final byte myParamCount;

        public JavacMethodImpl(String ownerName, byte paramCount, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myOwnerName = ownerName;
            this.myParamCount = paramCount;
        }

        @Override
        public byte getParamCount() {
            return this.myParamCount;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            return this.myOwnerName;
        }
    }

    public static class JavacClassImpl
    extends JavacRefBase
    implements JavacClass {
        private final boolean myAnonymous;

        public JavacClassImpl(boolean anonymous, Set<Modifier> modifiers, String name) {
            super(name, modifiers);
            this.myAnonymous = anonymous;
        }

        @Override
        @NotNull
        public String getOwnerName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAnonymous() {
            return this.myAnonymous;
        }
    }

    public static abstract class JavacRefBase
    implements JavacRef {
        private final String myName;
        private final Set<Modifier> myModifiers;

        protected JavacRefBase(String name, Set<Modifier> modifiers) {
            this.myName = name;
            this.myModifiers = modifiers;
        }

        @Override
        @NotNull
        public final String getName() {
            return this.myName;
        }

        @Override
        public final Set<Modifier> getModifiers() {
            return this.myModifiers;
        }

        @Override
        @Nullable
        public ImportProperties getImportProperties() {
            return null;
        }
    }

    public static interface JavacField
    extends JavacRef {
    }

    public static interface JavacMethod
    extends JavacRef {
        public byte getParamCount();
    }

    public static interface JavacClass
    extends JavacRef {
        public boolean isAnonymous();
    }

    public static abstract class ImportProperties {
        public abstract boolean isStatic();

        public abstract boolean isOnDemand();

        public static ImportProperties create(final boolean isStatic, final boolean isOnDemand) {
            return new ImportProperties(){

                @Override
                public boolean isStatic() {
                    return isStatic;
                }

                @Override
                public boolean isOnDemand() {
                    return isOnDemand;
                }
            };
        }
    }
}

