/*
 * Decompiled with CFR 0.152.
 */
package io.nettyjarjar.handler.codec.http;

import io.nettyjarjar.buffer.ByteBuf;
import io.nettyjarjar.buffer.ByteBufUtil;
import io.nettyjarjar.handler.codec.http.HttpObjectEncoder;
import io.nettyjarjar.handler.codec.http.HttpRequest;
import io.nettyjarjar.handler.codec.http.HttpResponse;
import io.nettyjarjar.util.AsciiString;
import io.nettyjarjar.util.CharsetUtil;

public class HttpRequestEncoder
extends HttpObjectEncoder<HttpRequest> {
    private static final char SLASH = '/';
    private static final char QUESTION_MARK = '?';

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && !(msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpRequest request) throws Exception {
        AsciiString method = request.method().asciiName();
        ByteBufUtil.copy(method, method.arrayOffset(), buf, method.length());
        buf.writeByte(32);
        String uri = request.uri();
        if (uri.length() == 0) {
            uri = uri + '/';
        } else {
            int start = uri.indexOf("://");
            if (start != -1 && uri.charAt(0) != '/') {
                int startIndex = start + 3;
                int index = uri.indexOf(63, startIndex);
                if (index == -1) {
                    if (uri.lastIndexOf(47) <= startIndex) {
                        uri = uri + '/';
                    }
                } else if (uri.lastIndexOf(47, index) <= startIndex) {
                    int len = uri.length();
                    StringBuilder sb = new StringBuilder(len + 1);
                    sb.append(uri, 0, index).append('/').append(uri, index, len);
                    uri = sb.toString();
                }
            }
        }
        buf.writeBytes(uri.getBytes(CharsetUtil.UTF_8));
        buf.writeByte(32);
        request.protocolVersion().encode(buf);
        buf.writeBytes(CRLF);
    }
}

